/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.egov.common.contract.models.AuditDetails;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.ds.Tuple;
import org.egov.common.error.handler.ErrorHandler;
import org.egov.common.models.ApiDetails;
import org.egov.common.models.Error;
import org.egov.common.models.ErrorDetails;
import org.egov.common.models.core.URLParams;
import org.egov.common.utils.ValidatorUtils;
import org.egov.common.validator.Validator;
import org.egov.tracer.model.CustomException;
import org.egov.tracer.model.ErrorDetail;
import org.egov.tracer.model.ErrorEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.ReflectionUtils;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    public static final String GET_API_OPERATION = "getApiOperation";
    private static final Map<Class<?>, Map<String, Method>> methodCache = new ConcurrentHashMap();
    private static ObjectMapper objectMapper = new ObjectMapper();

    private CommonUtils() {
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Deprecated
    public static boolean isForUpdate(Object obj) {
        Method getApiOperationMethod = CommonUtils.getMethod(GET_API_OPERATION, obj.getClass());
        Object apiOperation = ReflectionUtils.invokeMethod((Method)getApiOperationMethod, (Object)obj);
        if (apiOperation == null) {
            return false;
        }
        Method nameMethod = CommonUtils.getMethod("name", Enum.class);
        return "UPDATE".equals(ReflectionUtils.invokeMethod((Method)nameMethod, (Object)apiOperation));
    }

    @Deprecated
    public static boolean isForDelete(Object obj) {
        Method getApiOperationMethod = CommonUtils.getMethod(GET_API_OPERATION, obj.getClass());
        Object apiOperation = ReflectionUtils.invokeMethod((Method)getApiOperationMethod, (Object)obj);
        if (apiOperation == null) {
            return false;
        }
        Method nameMethod = CommonUtils.getMethod("name", Enum.class);
        return "DELETE".equals(ReflectionUtils.invokeMethod((Method)nameMethod, (Object)apiOperation));
    }

    @Deprecated
    public static boolean isForCreate(Object obj) {
        Method getApiOperationMethod = CommonUtils.getMethod(GET_API_OPERATION, obj.getClass());
        Object apiOperation = ReflectionUtils.invokeMethod((Method)getApiOperationMethod, (Object)obj);
        if (apiOperation == null) {
            return false;
        }
        Method nameMethod = CommonUtils.getMethod("name", Enum.class);
        String value = (String)ReflectionUtils.invokeMethod((Method)nameMethod, (Object)apiOperation);
        return "CREATE".equals(value);
    }

    public static <T, R> Set<T> getSet(List<R> objects, String methodName) {
        return objects.stream().map(o -> ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod(methodName, o.getClass()), (Object)o)).collect(Collectors.toSet());
    }

    public static <T> List<T> getDifference(List<T> list, List<T> subList) {
        ArrayList<T> newList = new ArrayList<T>(list);
        ArrayList<T> newSubList = new ArrayList<T>(subList);
        if (newList.size() >= newSubList.size()) {
            newList.removeAll(subList);
        }
        return newList;
    }

    @Deprecated
    public static <T> void validateIds(Set<T> idsToValidate, UnaryOperator<List<T>> validator) {
        ArrayList<T> idsToValidateList = new ArrayList<T>(idsToValidate);
        List validIds = (List)validator.apply(idsToValidateList);
        List<T> invalidIds = CommonUtils.getDifference(idsToValidateList, validIds);
        if (!invalidIds.isEmpty()) {
            log.error("Invalid IDs {}", invalidIds);
            throw new CustomException("INVALID_ID", invalidIds.toString());
        }
    }

    public static AuditDetails getAuditDetailsForCreate(RequestInfo requestInfo) {
        log.info("Creating audit details for create api");
        Long time = System.currentTimeMillis();
        return AuditDetails.builder().createdBy(requestInfo.getUserInfo().getUuid()).createdTime(time).lastModifiedBy(requestInfo.getUserInfo().getUuid()).lastModifiedTime(time).build();
    }

    public static AuditDetails getAuditDetailsForUpdate(AuditDetails existingAuditDetails, String modifiedByUuid) {
        log.info("Creating audit details for update/delete api");
        if (existingAuditDetails == null) {
            return AuditDetails.builder().lastModifiedBy(modifiedByUuid).lastModifiedTime(Long.valueOf(System.currentTimeMillis())).build();
        }
        existingAuditDetails.setLastModifiedBy(modifiedByUuid);
        existingAuditDetails.setLastModifiedTime(Long.valueOf(System.currentTimeMillis()));
        return existingAuditDetails;
    }

    public static boolean isSearchByIdOnly(Object obj) {
        return CommonUtils.isSearchByIdOnly(obj, "id");
    }

    public static boolean isSearchByIdOnly(Object obj, String fieldName) {
        Class<?> objClass = obj.getClass();
        String propertyName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        Method setFieldMethod = CommonUtils.getMethod("set" + propertyName, objClass);
        Method getFieldMethod = CommonUtils.getMethod("get" + propertyName, objClass);
        Object finalObject = null;
        try {
            finalObject = objClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        Object id = ReflectionUtils.invokeMethod((Method)getFieldMethod, (Object)obj);
        if (id == null) {
            return false;
        }
        ReflectionUtils.invokeMethod((Method)setFieldMethod, finalObject, (Object[])new Object[]{id});
        if (obj instanceof URLParams) {
            URLParams urlParamsObj = (URLParams)obj;
            URLParams finalUrlParamsObj = finalObject;
            finalUrlParamsObj.setIncludeDeleted(urlParamsObj.getIncludeDeleted());
            finalUrlParamsObj.setTenantId(urlParamsObj.getTenantId());
            finalUrlParamsObj.setOffset(urlParamsObj.getOffset());
            finalUrlParamsObj.setLimit(urlParamsObj.getLimit());
            finalUrlParamsObj.setLastChangedSince(urlParamsObj.getLastChangedSince());
        }
        return CommonUtils.areObjectsEqual(obj, finalObject);
    }

    public static boolean areObjectsEqual(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        Class<?> objClass = obj1.getClass();
        StringBuilder obj1Fields = new StringBuilder();
        StringBuilder obj2Fields = new StringBuilder();
        while (objClass.getSuperclass() != null) {
            for (Field field : objClass.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object value1 = field.get(obj1);
                    Object value2 = field.get(obj2);
                    obj1Fields.append(field.getName()).append(":").append(value1).append(",");
                    obj2Fields.append(field.getName()).append(":").append(value2).append(",");
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            objClass = objClass.getSuperclass();
        }
        return obj1Fields.toString().equals(obj2Fields.toString());
    }

    @Deprecated
    public static <T> void checkRowVersion(Map<String, T> idToObjMap, List<T> objList) {
        Class<?> objClass = CommonUtils.getObjClass(objList);
        CommonUtils.checkRowVersion(idToObjMap, objList, CommonUtils.getMethod("getId", objClass));
    }

    @Deprecated
    public static <T> void checkRowVersion(Map<String, T> idToObjMap, List<T> objList, Method idMethod) {
        Class<?> objClass = CommonUtils.getObjClass(objList);
        Method rowVersionMethod = CommonUtils.getMethod("getRowVersion", objClass);
        Set rowVersionMismatch = objList.stream().filter(obj -> !Objects.equals(ReflectionUtils.invokeMethod((Method)rowVersionMethod, (Object)obj), ReflectionUtils.invokeMethod((Method)rowVersionMethod, idToObjMap.get(ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj))))).map(obj -> ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj)).collect(Collectors.toSet());
        if (!rowVersionMismatch.isEmpty()) {
            log.error("Mismatch in row versions {}", rowVersionMismatch);
            throw new CustomException("ROW_VERSION_MISMATCH", rowVersionMismatch.toString());
        }
    }

    public static <T> List<T> getEntitiesWithMismatchedRowVersion(Map<String, T> idToObjMap, List<T> objList, Method idMethod) {
        Class<?> objClass = CommonUtils.getObjClass(objList);
        Method rowVersionMethod = CommonUtils.getMethod("getRowVersion", objClass);
        return objList.stream().filter(obj -> !Objects.equals(ReflectionUtils.invokeMethod((Method)rowVersionMethod, (Object)obj), ReflectionUtils.invokeMethod((Method)rowVersionMethod, idToObjMap.get(ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj))))).map(obj -> idToObjMap.get(ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj))).collect(Collectors.toList());
    }

    public static <T> String getTenantId(List<T> objList) {
        Object obj = objList.stream().findAny().get();
        Method getTenantIdMethod = CommonUtils.getMethod("getTenantId", obj.getClass());
        String tenantId = (String)ReflectionUtils.invokeMethod((Method)getTenantIdMethod, obj);
        log.info("tenantId is {}", (Object)tenantId);
        return tenantId;
    }

    public static <T> void enrichForCreate(List<T> objList, List<String> idList, RequestInfo requestInfo) {
        CommonUtils.enrichForCreate(objList, idList, requestInfo, true);
    }

    public static <T> void enrichForCreate(List<T> objList, List<String> idList, RequestInfo requestInfo, boolean updateRowVersion) {
        AuditDetails auditDetails = CommonUtils.getAuditDetailsForCreate(requestInfo);
        Class<?> objClass = CommonUtils.getObjClass(objList);
        Method setIdMethod = CommonUtils.getMethod("setId", objClass);
        Method setAuditDetailsMethod = CommonUtils.getMethod("setAuditDetails", objClass);
        Method setIsDeletedMethod = CommonUtils.getMethod("setIsDeleted", objClass);
        IntStream.range(0, objList.size()).forEach(i -> {
            Object obj = objList.get(i);
            ReflectionUtils.invokeMethod((Method)setIdMethod, obj, (Object[])new Object[]{idList.get(i)});
            ReflectionUtils.invokeMethod((Method)setAuditDetailsMethod, obj, (Object[])new Object[]{auditDetails});
            if (updateRowVersion) {
                Method setRowVersionMethod = CommonUtils.getMethod("setRowVersion", objClass);
                ReflectionUtils.invokeMethod((Method)setRowVersionMethod, obj, (Object[])new Object[]{1});
            }
            ReflectionUtils.invokeMethod((Method)setIsDeletedMethod, obj, (Object[])new Object[]{Boolean.FALSE});
        });
    }

    public static <T> Method getIdMethod(List<T> objList) {
        return CommonUtils.getIdMethod(objList, "id", "clientReferenceId");
    }

    public static <T> Method getIdMethod(List<T> objList, String idFieldName) {
        String idMethodName = "get" + idFieldName.substring(0, 1).toUpperCase() + idFieldName.substring(1);
        return CommonUtils.getMethod(idMethodName, CommonUtils.getObjClass(objList));
    }

    public static <T> Method getIdMethod(List<T> objList, String idField, String clientReferenceIdField) {
        String idMethodName = "get" + idField.substring(0, 1).toUpperCase() + idField.substring(1);
        String clientReferenceIdMethodName = "get" + clientReferenceIdField.substring(0, 1).toUpperCase() + clientReferenceIdField.substring(1);
        try {
            Method getId = CommonUtils.getMethod(idMethodName, CommonUtils.getObjClass(objList));
            Object value = ReflectionUtils.invokeMethod((Method)getId, objList.stream().findAny().get());
            if (value != null) {
                return getId;
            }
        }
        catch (CustomException e) {
            log.error(e.getMessage());
        }
        return CommonUtils.getMethod(clientReferenceIdMethodName, CommonUtils.getObjClass(objList));
    }

    public static <T> void enrichId(List<T> objList, List<String> idList) {
        Class<?> objClass = CommonUtils.getObjClass(objList);
        Method setIdMethod = CommonUtils.getMethod("setId", objClass);
        IntStream.range(0, objList.size()).forEach(i -> {
            Object obj = objList.get(i);
            ReflectionUtils.invokeMethod((Method)setIdMethod, obj, (Object[])new Object[]{idList.get(i)});
        });
    }

    public static <T> void enrichForUpdate(Map<String, T> idToObjMap, Object request) {
        Class<?> objClass = CommonUtils.getObjClass(Arrays.asList(idToObjMap.values().toArray()));
        Class<?> requestObjClass = request.getClass();
        Method getRowVersionMethod = CommonUtils.getMethod("getRowVersion", objClass);
        Method setRowVersionMethod = CommonUtils.getMethod("setRowVersion", objClass);
        Method setAuditDetailsMethod = CommonUtils.getMethod("setAuditDetails", objClass);
        Method getAuditDetailsMethod = CommonUtils.getMethod("getAuditDetails", objClass);
        Method getRequestInfoMethod = CommonUtils.getMethod("getRequestInfo", requestObjClass);
        idToObjMap.keySet().forEach(i -> {
            Object obj = idToObjMap.get(i);
            Integer rowVersion = (Integer)ReflectionUtils.invokeMethod((Method)getRowVersionMethod, obj);
            ReflectionUtils.invokeMethod((Method)setRowVersionMethod, obj, (Object[])new Object[]{rowVersion + 1});
            RequestInfo requestInfo = (RequestInfo)ReflectionUtils.invokeMethod((Method)getRequestInfoMethod, (Object)request);
            AuditDetails existingAuditDetails = (AuditDetails)ReflectionUtils.invokeMethod((Method)getAuditDetailsMethod, obj);
            AuditDetails auditDetailsForUpdate = CommonUtils.getAuditDetailsForUpdate(existingAuditDetails, requestInfo.getUserInfo().getUuid());
            ReflectionUtils.invokeMethod((Method)setAuditDetailsMethod, obj, (Object[])new Object[]{auditDetailsForUpdate});
        });
    }

    public static <T> void enrichForUpdate(Map<String, T> idToObjMap, List<T> existingObjList, Object request, Method idMethod) {
        Class<?> objClass = CommonUtils.getObjClass(existingObjList);
        Class<?> requestObjClass = request.getClass();
        Method setIsDeletedMethod = CommonUtils.getMethod("setIsDeleted", objClass);
        Method getRowVersionMethod = CommonUtils.getMethod("getRowVersion", objClass);
        Method setRowVersionMethod = CommonUtils.getMethod("setRowVersion", objClass);
        Method getAuditDetailsMethod = CommonUtils.getMethod("getAuditDetails", objClass);
        Method setAuditDetailsMethod = CommonUtils.getMethod("setAuditDetails", objClass);
        Method getRequestInfoMethod = CommonUtils.getMethod("getRequestInfo", requestObjClass);
        IntStream.range(0, existingObjList.size()).forEach(i -> {
            Object obj = idToObjMap.get(ReflectionUtils.invokeMethod((Method)idMethod, existingObjList.get(i)));
            try {
                Method getApiOperationMethod = CommonUtils.getMethod(GET_API_OPERATION, requestObjClass);
                Object apiOperation = ReflectionUtils.invokeMethod((Method)getApiOperationMethod, (Object)request);
                Method nameMethod = CommonUtils.getMethod("name", Enum.class);
                if ("DELETE".equals(ReflectionUtils.invokeMethod((Method)nameMethod, (Object)apiOperation))) {
                    ReflectionUtils.invokeMethod((Method)setIsDeletedMethod, obj, (Object[])new Object[]{true});
                }
            }
            catch (Exception getApiOperationMethod) {
                // empty catch block
            }
            Integer rowVersion = (Integer)ReflectionUtils.invokeMethod((Method)getRowVersionMethod, obj);
            ReflectionUtils.invokeMethod((Method)setRowVersionMethod, obj, (Object[])new Object[]{rowVersion + 1});
            RequestInfo requestInfo = (RequestInfo)ReflectionUtils.invokeMethod((Method)getRequestInfoMethod, (Object)request);
            AuditDetails existingAuditDetails = (AuditDetails)ReflectionUtils.invokeMethod((Method)getAuditDetailsMethod, existingObjList.get(i));
            AuditDetails auditDetailsForUpdate = CommonUtils.getAuditDetailsForUpdate(existingAuditDetails, requestInfo.getUserInfo().getUuid());
            ReflectionUtils.invokeMethod((Method)setAuditDetailsMethod, obj, (Object[])new Object[]{auditDetailsForUpdate});
        });
    }

    public static <T> void enrichForUpdate(Map<String, T> idToObjMap, List<T> existingObjList, Object request) {
        Class<?> objClass = CommonUtils.getObjClass(existingObjList);
        Method getIdMethod = CommonUtils.getMethod("getId", objClass);
        CommonUtils.enrichForUpdate(idToObjMap, existingObjList, request, getIdMethod);
    }

    public static <T> Map<String, T> getIdToObjMap(List<T> objList) {
        Class<?> objClass = CommonUtils.getObjClass(objList);
        Method idMethod = CommonUtils.getMethod("getId", objClass);
        return CommonUtils.getIdToObjMap(objList, idMethod);
    }

    public static <T> Map<String, T> getIdToObjMap(List<T> objList, Method idMethod) {
        return objList.stream().collect(Collectors.toMap(obj -> (String)ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj), obj -> obj, (obj1, obj2) -> obj2));
    }

    public static <T> void validateEntities(Map<String, T> idToObjInRequestMap, List<T> objInDbList) {
        if (idToObjInRequestMap.size() > objInDbList.size()) {
            List<String> idsForObjInDb = CommonUtils.getIdList(objInDbList);
            List idsForInvalidObj = idToObjInRequestMap.keySet().stream().filter(id -> !idsForObjInDb.contains(id)).collect(Collectors.toList());
            log.error("Invalid entities {}", idsForInvalidObj);
            throw new CustomException("INVALID_ENTITY", idsForInvalidObj.toString());
        }
    }

    public static <T> void validateEntities(Map<String, T> idToObjInRequestMap, List<T> objInDbList, Method idMethod) {
        if (idToObjInRequestMap.size() > objInDbList.size()) {
            List<String> idsForObjInDb = CommonUtils.getIdList(objInDbList, idMethod);
            List idsForInvalidObj = idToObjInRequestMap.keySet().stream().filter(id -> !idsForObjInDb.contains(id)).collect(Collectors.toList());
            log.error("Invalid entities {}", idsForInvalidObj);
            throw new CustomException("INVALID_ENTITY", idsForInvalidObj.toString());
        }
    }

    public static <T> List<T> checkNonExistentEntities(Map<String, T> idToObjInRequestMap, List<T> objInDbList, Method idMethod) {
        if (idToObjInRequestMap.size() > objInDbList.size()) {
            List<String> idsForObjInDb = CommonUtils.getIdList(objInDbList, idMethod);
            return idToObjInRequestMap.entrySet().stream().filter(e -> !idsForObjInDb.contains(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static <T> List<String> getIdList(List<T> objList) {
        if (objList == null || objList.isEmpty()) {
            return Collections.emptyList();
        }
        Class<?> objClass = CommonUtils.getObjClass(objList);
        return CommonUtils.getIdList(objList, CommonUtils.getMethod("getId", objClass));
    }

    public static <T> List<String> getIdList(List<T> objList, Method idMethod) {
        if (objList == null || objList.isEmpty()) {
            return Collections.emptyList();
        }
        return objList.stream().map(obj -> (String)ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj)).collect(Collectors.toList());
    }

    public static <T> Predicate<T> lastChangedSince(Long lastChangedSince) {
        if (lastChangedSince == null) {
            return obj -> true;
        }
        return obj -> {
            Method getAuditDetailsMethod = CommonUtils.getMethod("getAuditDetails", obj.getClass());
            Object auditDetails = ReflectionUtils.invokeMethod((Method)getAuditDetailsMethod, (Object)obj);
            Method getLastModifiedTimeMethod = CommonUtils.getMethod("getLastModifiedTime", auditDetails.getClass());
            Long lastModifiedTime = (Long)ReflectionUtils.invokeMethod((Method)getLastModifiedTimeMethod, (Object)auditDetails);
            return lastModifiedTime > lastChangedSince;
        };
    }

    public static <T> Predicate<T> includeDeleted(Boolean includeDeleted) {
        if (includeDeleted == null || !includeDeleted.booleanValue()) {
            return obj -> {
                Method getIsDeletedMethod = CommonUtils.getMethod("getIsDeleted", obj.getClass());
                Boolean isDeleted = (Boolean)ReflectionUtils.invokeMethod((Method)getIsDeletedMethod, (Object)obj);
                return Objects.equals(isDeleted, false);
            };
        }
        return obj -> true;
    }

    public static <T> Predicate<T> havingTenantId(String tenantId) {
        if (tenantId == null) {
            return obj -> true;
        }
        return obj -> {
            Method getTenantIdMethod = CommonUtils.getMethod("getTenantId", obj.getClass());
            String actualTenantId = (String)ReflectionUtils.invokeMethod((Method)getTenantIdMethod, (Object)obj);
            return Objects.equals(actualTenantId, tenantId);
        };
    }

    public static <T> Class<?> getObjClass(List<T> objList) {
        return objList.stream().findAny().get().getClass();
    }

    public static <T> void identifyNullIds(List<T> objList) {
        Class<?> objClass = CommonUtils.getObjClass(objList);
        CommonUtils.identifyNullIds(objList, CommonUtils.getMethod("getId", objClass));
    }

    public static <T> void identifyNullIds(List<T> objList, Method idMethod) {
        Long nullCount = objList.stream().filter(obj -> null == ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj)).count();
        if (nullCount > 0L) {
            throw new CustomException("NULL_ID", String.format("Ids cannot be null, found %d", nullCount));
        }
    }

    public static <T> List<T> identifyObjectsWithNullIds(List<T> objList, Method idMethod) {
        return objList.stream().filter(obj -> null == ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj)).collect(Collectors.toList());
    }

    public static <T, R> List<R> collectFromList(List<T> objList, Function<T, List<R>> function) {
        return objList.stream().flatMap(obj -> {
            List aList = (List)function.apply(obj);
            if (aList == null || aList.isEmpty()) {
                return new ArrayList().stream();
            }
            return aList.stream();
        }).collect(Collectors.toList());
    }

    public static String getIdFieldName(Object obj) {
        String defaultVal = "id";
        try {
            Field idField = CommonUtils.getParentClassField(obj.getClass(), "id");
            if (idField != null) {
                idField.setAccessible(true);
                Object idFieldValue = idField.get(obj);
                if (idFieldValue != null) {
                    return "id";
                }
            }
            Field clientReferenceIdField = CommonUtils.getParentClassField(obj.getClass(), "clientReferenceId");
            clientReferenceIdField.setAccessible(true);
            Object clientReferenceIdFieldValue = clientReferenceIdField.get(obj);
            if (clientReferenceIdFieldValue != null) {
                return "clientReferenceId";
            }
        }
        catch (IllegalAccessException | NullPointerException e) {
            return defaultVal;
        }
        return defaultVal;
    }

    public static Field getParentClassField(Class<?> clazz, String fieldName) {
        for (Class<?> parentClass = clazz; parentClass != null; parentClass = parentClass.getSuperclass()) {
            try {
                return parentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    public static String getIdFieldName(Method method) {
        if (method != null) {
            return method.getName().contains("Reference") ? "clientReferenceId" : "id";
        }
        return "id";
    }

    public static <T> Predicate<T> notHavingErrors() {
        return obj -> (Boolean)ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod("getHasErrors", obj.getClass()), (Object)obj) == false;
    }

    public static <T> void enrichIdsFromExistingEntities(Map<String, T> idToObjMap, List<T> existingEntities, Method idMethod) {
        IntStream.range(0, existingEntities.size()).forEach(i -> {
            Object existing = existingEntities.get(i);
            String id = (String)ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod("getId", existing.getClass()), existing);
            String clientReferenceId = (String)ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod("getClientReferenceId", existing.getClass()), existing);
            String key = CommonUtils.getIdFieldName(idMethod).equalsIgnoreCase("id") ? id : clientReferenceId;
            Object toUpdate = idToObjMap.get(key);
            ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod("setId", toUpdate.getClass()), toUpdate, (Object[])new Object[]{id});
            ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod("setClientReferenceId", toUpdate.getClass()), toUpdate, (Object[])new Object[]{clientReferenceId});
        });
    }

    public static Function<Integer, List<String>> uuidSupplier() {
        return integer -> {
            ArrayList<String> uuidList = new ArrayList<String>();
            for (int i = 0; i < integer; ++i) {
                uuidList.add(UUID.randomUUID().toString());
            }
            return uuidList;
        };
    }

    public static Method getMethod(String methodName, Class<?> clazz) {
        if (methodCache.containsKey(clazz)) {
            Map<String, Method> methodMap = methodCache.get(clazz);
            if (methodMap.containsKey(methodName)) {
                return methodMap.get(methodName);
            }
            Method method = CommonUtils.findMethod(methodName, clazz);
            methodMap.put(methodName, method);
            return method;
        }
        Method method = CommonUtils.findMethod(methodName, clazz);
        ConcurrentHashMap<String, Method> methodMap = new ConcurrentHashMap<String, Method>();
        methodMap.put(methodName, method);
        methodCache.put(clazz, methodMap);
        return method;
    }

    public static <T> void enrichForDelete(List<T> objList, RequestInfo requestInfo, boolean updateRowVersion) {
        Class<?> objClass = CommonUtils.getObjClass(objList);
        Method setIsDeletedMethod = CommonUtils.getMethod("setIsDeleted", objClass);
        Method setAuditDetailsMethod = CommonUtils.getMethod("setAuditDetails", objClass);
        Method getAuditDetailsMethod = CommonUtils.getMethod("getAuditDetails", objClass);
        objList.forEach(obj -> {
            ReflectionUtils.invokeMethod((Method)setIsDeletedMethod, (Object)obj, (Object[])new Object[]{true});
            if (updateRowVersion) {
                Method getRowVersionMethod = CommonUtils.getMethod("getRowVersion", objClass);
                Method setRowVersionMethod = CommonUtils.getMethod("setRowVersion", objClass);
                Integer rowVersion = (Integer)ReflectionUtils.invokeMethod((Method)getRowVersionMethod, (Object)obj);
                ReflectionUtils.invokeMethod((Method)setRowVersionMethod, (Object)obj, (Object[])new Object[]{rowVersion + 1});
            }
            AuditDetails existingAuditDetails = (AuditDetails)ReflectionUtils.invokeMethod((Method)getAuditDetailsMethod, (Object)obj);
            AuditDetails auditDetailsForUpdate = CommonUtils.getAuditDetailsForUpdate(existingAuditDetails, requestInfo.getUserInfo().getUuid());
            ReflectionUtils.invokeMethod((Method)setAuditDetailsMethod, (Object)obj, (Object[])new Object[]{auditDetailsForUpdate});
        });
    }

    public static <T, R> Tuple<List<T>, Map<T, ErrorDetails>> validate(List<Validator<R, T>> validators, Predicate<Validator<R, T>> applicableValidators, R request, String setPayloadMethodName, String getPayloadMethodName, String errorCode, boolean isBulk) {
        Map<T, ErrorDetails> errorDetailsMap = CommonUtils.validate(validators, applicableValidators, request, setPayloadMethodName);
        if (!errorDetailsMap.isEmpty() && !isBulk) {
            throw new CustomException(errorCode, errorDetailsMap.values().toString());
        }
        Method getEntities = CommonUtils.getMethod(getPayloadMethodName, request.getClass());
        List validEntities = (List)ReflectionUtils.invokeMethod((Method)getEntities, request);
        validEntities = validEntities.stream().filter(CommonUtils.notHavingErrors()).collect(Collectors.toList());
        return new Tuple(validEntities, errorDetailsMap);
    }

    public static <T, R> Map<T, ErrorDetails> validate(List<Validator<R, T>> validators, Predicate<Validator<R, T>> applicableValidators, R request, String setPayloadMethodName) {
        HashMap errorDetailsMap = new HashMap();
        validators.stream().filter(applicableValidators).map(validator -> validator.validate(request)).forEach(e -> CommonUtils.populateErrorDetails(request, errorDetailsMap, e, setPayloadMethodName));
        return errorDetailsMap;
    }

    public static <T, R> void populateErrorDetails(R request, Map<T, ErrorDetails> errorDetailsMap, Map<T, List<Error>> errorMap, String setPayloadMethodName) {
        try {
            for (Map.Entry<T, List<Error>> entry : errorMap.entrySet()) {
                T payload = entry.getKey();
                if (errorDetailsMap.containsKey(payload)) {
                    errorDetailsMap.get(payload).getErrors().addAll((Collection<Error>)entry.getValue());
                    continue;
                }
                RequestInfo requestInfo = (RequestInfo)ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod("getRequestInfo", request.getClass()), request);
                Object newRequest = ReflectionUtils.accessibleConstructor(request.getClass(), null).newInstance(new Object[0]);
                ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod("setRequestInfo", newRequest.getClass()), newRequest, (Object[])new Object[]{requestInfo});
                ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod(setPayloadMethodName, newRequest.getClass()), newRequest, (Object[])new Object[]{Collections.singletonList(payload)});
                ApiDetails apiDetails = ApiDetails.builder().methodType(HttpMethod.POST.name()).contentType("application/json").url(requestInfo.getApiId()).build();
                apiDetails.setRequestBody(objectMapper.writeValueAsString(newRequest));
                ErrorDetails errorDetails = ErrorDetails.builder().errors(entry.getValue()).apiDetails(apiDetails).build();
                errorDetailsMap.put(payload, errorDetails);
            }
        }
        catch (Exception exception) {
            log.error("failure in error handling", (Throwable)exception);
            throw new CustomException("FAILURE_IN_ERROR_HANDLING", exception.getMessage());
        }
    }

    public static <R, T> void populateErrorDetails(R request, Map<T, ErrorDetails> errorDetailsMap, List<T> validPayloads, Exception exception, String setPayloadMethodName) {
        Error.ErrorType errorType = Error.ErrorType.NON_RECOVERABLE;
        String errorCode = "INTERNAL_SERVER_ERROR";
        if (exception instanceof CustomException) {
            errorCode = ((CustomException)((Object)exception)).getCode();
            errorType = exception instanceof CustomException && !"IDGEN_ERROR".equals(((CustomException)((Object)exception)).getCode()) ? Error.ErrorType.RECOVERABLE : Error.ErrorType.NON_RECOVERABLE;
        }
        ArrayList<Error> errorList = new ArrayList<Error>();
        errorList.add(Error.builder().errorMessage(exception.getMessage()).errorCode(errorCode).type(errorType).exception((Exception)((Object)new CustomException(errorCode, exception.getMessage()))).build());
        HashMap errorListMap = new HashMap();
        validPayloads.forEach(payload -> {
            if (errorListMap.containsKey(payload)) {
                ((List)errorListMap.get(payload)).addAll(errorList);
            } else {
                errorListMap.put(payload, errorList);
            }
        });
        CommonUtils.populateErrorDetails(request, errorDetailsMap, errorListMap, setPayloadMethodName);
    }

    public static <R, T> void populateErrorDetails(R request, Map<T, List<Error>> errorListMap, List<T> validPayloads, Exception exception) {
    }

    public static <T> void handleErrors(Map<T, ErrorDetails> errorDetailsMap, boolean isBulk, String errorCode) {
        if (!errorDetailsMap.isEmpty()) {
            log.error("{} errors collected", (Object)errorDetailsMap.size());
            List<ErrorDetail> errorDetailList = errorDetailsMap.values().stream().map(ErrorDetails::getTracerModel).collect(Collectors.toList());
            if (isBulk) {
                ErrorHandler.exceptionAdviseInstance.exceptionHandler(errorDetailList);
            } else {
                Map<String, String> getErrorMap = CommonUtils.getErrorMap(errorDetailList);
                String code = getErrorMap.keySet().stream().collect(Collectors.joining(":"));
                throw new CustomException(code, errorDetailsMap.values().toString());
            }
        }
    }

    private static Map<String, String> getErrorMap(List<ErrorDetail> errorDetailList) {
        return errorDetailList.stream().flatMap(errorDetail -> errorDetail.getErrors().stream()).collect(Collectors.toMap(ErrorEntity::getErrorCode, ErrorEntity::getErrorMessage));
    }

    public static <R, T> HashMap<T, List<Error>> validateForNullId(R request, String getPayloadMethodName) {
        log.info("validating for null id");
        HashMap errorDetailsMap = new HashMap();
        List validPayloads = ((List)ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod(getPayloadMethodName, request.getClass()), request)).stream().filter(CommonUtils.notHavingErrors()).collect(Collectors.toList());
        if (!validPayloads.isEmpty()) {
            Class<?> objClass = CommonUtils.getObjClass(validPayloads);
            Method idMethod = CommonUtils.getMethod("getId", objClass);
            List<Object> payloadWithNullIds = CommonUtils.identifyObjectsWithNullIds(validPayloads, idMethod);
            payloadWithNullIds.forEach(payload -> {
                Error error = ValidatorUtils.getErrorForNullId();
                CommonUtils.populateErrorDetails(payload, error, errorDetailsMap);
            });
            log.info("null id validation completed successfully, total errors: {}", (Object)payloadWithNullIds.size());
        }
        return errorDetailsMap;
    }

    public static <T> void populateErrorDetails(T payload, Error error, Map<T, List<Error>> errorDetailsMap) {
        ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod("setHasErrors", payload.getClass()), payload, (Object[])new Object[]{Boolean.TRUE});
        if (errorDetailsMap.containsKey(payload)) {
            errorDetailsMap.get(payload).add(error);
        } else {
            ArrayList<Error> errors = new ArrayList<Error>();
            errors.add(error);
            errorDetailsMap.put(payload, errors);
        }
    }

    private static Method findMethod(String methodName, Class<?> clazz) {
        return Arrays.stream(ReflectionUtils.getAllDeclaredMethods(clazz)).filter(m -> m.getName().equals(methodName)).findFirst().orElseThrow(() -> new CustomException("INVALID_OBJECT_OR_METHOD", "Invalid object or method"));
    }

    public static boolean isValidPattern(String value, String regexPattern) {
        Pattern pattern = Pattern.compile(regexPattern);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    public static Long constructTotalCountCTEAndReturnResult(String query, Map<String, Object> paramsMap, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        String cteQuery = "WITH result_cte AS (" + query + "), totalCount_cte AS (SELECT COUNT(*) AS totalRows FROM result_cte) select * from totalCount_cte";
        return (Long)namedParameterJdbcTemplate.query(cteQuery, paramsMap, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getLong("totalRows");
            }
            return 0L;
        });
    }
}

