/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.data.query.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.common.data.query.builder.GenericQueryBuilder;
import org.egov.common.data.query.builder.QueryFieldChecker;
import org.egov.common.data.query.exception.QueryBuilderException;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class UpdateQueryBuilder
implements GenericQueryBuilder {
    Map<String, Object> paramsMap = new HashMap<String, Object>();

    public Map<String, Object> getParamsMap() {
        return this.paramsMap;
    }

    @Override
    public String build(Object object) throws QueryBuilderException {
        StringBuilder queryStringBuilder = null;
        try {
            String tableName = GenericQueryBuilder.getTableName(object.getClass());
            List<String> fieldsToUpdate = GenericQueryBuilder.getFieldsWithCondition(object, QueryFieldChecker.isNotNull, this.paramsMap);
            List<String> fieldsToUpdateWith = GenericQueryBuilder.getFieldsWithCondition(object, QueryFieldChecker.isAnnotatedWithUpdateBy, this.paramsMap);
            queryStringBuilder = GenericQueryBuilder.generateQuery(GenericQueryBuilder.updateQueryTemplate(tableName), fieldsToUpdate, fieldsToUpdateWith);
        }
        catch (Exception exception) {
            throw new QueryBuilderException(exception.getMessage());
        }
        return queryStringBuilder.toString();
    }
}

