/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.user;

import org.egov.common.models.user.Role;

public class RoleRequest {
    private String code;
    private String name;
    private String tenantId;

    public RoleRequest(Role domainRole) {
        this.code = domainRole.getCode();
        this.name = domainRole.getName();
        this.tenantId = domainRole.getTenantId();
    }

    public Role toDomain() {
        return Role.builder().code(this.code).name(this.name).tenantId(this.tenantId).build();
    }

    public static RoleRequestBuilder builder() {
        return new RoleRequestBuilder();
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public RoleRequest(String code, String name, String tenantId) {
        this.code = code;
        this.name = name;
        this.tenantId = tenantId;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public RoleRequest() {
    }

    public String toString() {
        return "RoleRequest(code=" + this.getCode() + ", name=" + this.getName() + ", tenantId=" + this.getTenantId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoleRequest)) {
            return false;
        }
        RoleRequest other = (RoleRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoleRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        return result;
    }

    public static class RoleRequestBuilder {
        private String code;
        private String name;
        private String tenantId;

        RoleRequestBuilder() {
        }

        public RoleRequestBuilder code(String code) {
            this.code = code;
            return this;
        }

        public RoleRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RoleRequestBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RoleRequest build() {
            return new RoleRequest(this.code, this.name, this.tenantId);
        }

        public String toString() {
            return "RoleRequest.RoleRequestBuilder(code=" + this.code + ", name=" + this.name + ", tenantId=" + this.tenantId + ")";
        }
    }
}

