/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.data.query.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.common.data.query.builder.GenericQueryBuilder;
import org.egov.common.data.query.builder.QueryFieldChecker;
import org.egov.common.data.query.exception.QueryBuilderException;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SelectQueryBuilder
implements GenericQueryBuilder {
    Map<String, Object> paramsMap = new HashMap<String, Object>();

    public Map<String, Object> getParamsMap() {
        return this.paramsMap;
    }

    @Override
    public String build(Object object) throws QueryBuilderException {
        String tableName = null;
        try {
            tableName = GenericQueryBuilder.getTableName(object.getClass());
        }
        catch (Exception exception) {
            throw new QueryBuilderException(exception.getMessage());
        }
        return this.build(object, tableName);
    }

    public String build(Object object, String tableName) throws QueryBuilderException {
        StringBuilder queryStringBuilder = null;
        try {
            List<String> whereClauses = GenericQueryBuilder.getFieldsWithCondition(object, QueryFieldChecker.isNotNull, this.paramsMap);
            queryStringBuilder = GenericQueryBuilder.generateQuery(GenericQueryBuilder.selectQueryTemplate(tableName), whereClauses);
        }
        catch (Exception exception) {
            throw new QueryBuilderException(exception.getMessage());
        }
        return queryStringBuilder.toString();
    }
}

