/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.data.query.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.egov.common.data.query.annotations.Table;
import org.egov.common.data.query.builder.QueryFieldChecker;
import org.egov.common.data.query.exception.QueryBuilderException;
import org.egov.common.utils.ObjectUtils;

public interface GenericQueryBuilder {
    public String build(Object var1) throws QueryBuilderException;

    public static String getTableName(Class reflectClass) {
        Table table = reflectClass.getAnnotation(Table.class);
        return table.name();
    }

    public static String selectQueryTemplate(String tableName) {
        return String.format("SELECT * FROM %s", tableName);
    }

    public static String updateQueryTemplate(String tableName) {
        return String.format("UPDATE %s", tableName);
    }

    public static String generateClause(String clauseName, String separator, List<String> queryParameters) {
        StringBuilder clauseBuilder = new StringBuilder();
        if (queryParameters.isEmpty()) {
            return " ";
        }
        clauseBuilder.append(String.format(" %s ", clauseName));
        clauseBuilder.append(String.format(queryParameters.get(0), new Object[0]));
        IntStream.range(1, queryParameters.size()).forEach(i -> clauseBuilder.append(String.format(" %s %s", separator, queryParameters.get(i))));
        return clauseBuilder.toString();
    }

    public static StringBuilder generateQuery(String queryTemplate, List<String> setClauseFields, List<String> whereClauseFields) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(queryTemplate);
        stringBuilder.append(GenericQueryBuilder.generateClause("SET", ",", setClauseFields));
        stringBuilder.append(GenericQueryBuilder.generateClause("WHERE", "AND", whereClauseFields));
        return stringBuilder;
    }

    public static StringBuilder generateQuery(String queryTemplate, List<String> whereClauseFields) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(queryTemplate);
        stringBuilder.append(GenericQueryBuilder.generateClause("WHERE", "AND", whereClauseFields));
        return stringBuilder;
    }

    public static List<String> getFieldsWithCondition(Object object, QueryFieldChecker checkCondition, Map<String, Object> paramsMap) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        Arrays.stream(object.getClass().getDeclaredFields()).forEach(field -> {
            if (!(field.getType().equals(LocalDate.class) || field.getType().isEnum() || Modifier.isStatic(field.getModifiers()))) {
                try {
                    field.setAccessible(true);
                }
                catch (Exception exception) {
                    return;
                }
                try {
                    if (!field.getType().isPrimitive() && checkCondition.check((Field)field, object) && QueryFieldChecker.isNotAnnotatedWithExclude.check((Field)field, object)) {
                        if (ObjectUtils.isWrapper(field)) {
                            String fieldName = field.getName();
                            paramsMap.put(fieldName, field.get(object));
                            whereClauses.add(String.format("%s=:%s", fieldName, fieldName));
                        } else if (field.getType().isAssignableFrom(ArrayList.class) && field.getGenericType() instanceof ParameterizedType && ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0].equals(String.class)) {
                            ArrayList arrayList = (ArrayList)field.get(object);
                            String fieldName = field.getName();
                            if (arrayList != null && !arrayList.isEmpty()) {
                                whereClauses.add(String.format("%s IN (:%s)", fieldName, fieldName));
                                paramsMap.put(fieldName, arrayList);
                            }
                        } else {
                            Object objectAtField = field.get(object);
                            if (objectAtField != null) {
                                whereClauses.addAll(GenericQueryBuilder.getFieldsWithCondition(objectAtField, checkCondition, paramsMap));
                            }
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return whereClauses;
    }
}

