/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.data.repository;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.egov.common.data.query.builder.SelectQueryBuilder;
import org.egov.common.data.query.exception.QueryBuilderException;
import org.egov.common.producer.Producer;
import org.egov.common.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.ReflectionUtils;

public abstract class GenericRepository<T> {
    private static final Logger log = LoggerFactory.getLogger(GenericRepository.class);
    protected final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    protected final Producer producer;
    protected final RedisTemplate<String, Object> redisTemplate;
    protected final SelectQueryBuilder selectQueryBuilder;
    protected final RowMapper<T> rowMapper;
    protected String tableName;
    @Value(value="${spring.cache.redis.time-to-live:60}")
    private String timeToLive;

    protected GenericRepository(Producer producer, NamedParameterJdbcTemplate namedParameterJdbcTemplate, RedisTemplate<String, Object> redisTemplate, SelectQueryBuilder selectQueryBuilder, RowMapper<T> rowMapper, Optional<String> tableName) {
        this.producer = producer;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.redisTemplate = redisTemplate;
        this.selectQueryBuilder = selectQueryBuilder;
        this.rowMapper = rowMapper;
        tableName.ifPresent(tb -> {
            this.tableName = tb;
        });
    }

    public List<T> findById(List<String> ids) {
        return this.findById(ids, false);
    }

    protected List<T> findInCache(List<String> ids) {
        ArrayList objFound = new ArrayList();
        Collection collection = ids.stream().filter(Objects::nonNull).collect(Collectors.toList());
        log.info("Searching in cache");
        List objFromCache = this.redisTemplate.opsForHash().multiGet((Object)this.tableName, collection).stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (!objFromCache.isEmpty()) {
            if (objFromCache.size() == 1 && objFromCache.contains(null)) {
                log.info("Cache miss");
            } else {
                log.info("Cache hit, {} items found", (Object)objFromCache.size());
                objFound = (ArrayList)objFromCache.stream().map(Object.class::cast).collect(Collectors.toList());
            }
        } else {
            log.info("Cache miss");
        }
        return objFound;
    }

    public List<T> findById(List<String> ids, Boolean includeDeleted) {
        return this.findById(ids, includeDeleted, "id");
    }

    public List<T> findById(List<String> ids, Boolean includeDeleted, String columnName) {
        List<T> objFound = this.findInCache(ids);
        if (!objFound.isEmpty()) {
            Method idMethod = CommonUtils.getIdMethod(objFound, columnName);
            Method isDeleted = CommonUtils.getMethod("getIsDeleted", CommonUtils.getObjClass(objFound));
            if (!includeDeleted.booleanValue()) {
                objFound = objFound.stream().filter(entity -> Objects.equals(ReflectionUtils.invokeMethod((Method)isDeleted, (Object)entity), false)).collect(Collectors.toList());
            }
            ids.removeAll(objFound.stream().map(obj -> (String)ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj)).collect(Collectors.toList()));
            if (ids.isEmpty()) {
                return objFound;
            }
        }
        String query = String.format("SELECT * FROM %s WHERE %s IN (:ids) AND isDeleted = false", this.tableName, columnName);
        if (null != includeDeleted && includeDeleted.booleanValue()) {
            query = String.format("SELECT * FROM %s WHERE %s IN (:ids)", this.tableName, columnName);
        }
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("ids", ids);
        objFound.addAll(this.namedParameterJdbcTemplate.query(query, paramMap, this.rowMapper));
        this.putInCache(objFound);
        return objFound;
    }

    public List<T> save(List<T> objects, String topic) {
        this.producer.push(topic, objects);
        log.info("Pushed to kafka");
        this.putInCache(objects);
        log.info("Saved to cache");
        return objects;
    }

    public List<T> save(List<T> objects, String topic, String cacheKey) {
        this.producer.push(topic, objects);
        log.info("Pushed to kafka");
        this.putInCache(objects, cacheKey);
        log.info("Saved to cache");
        return objects;
    }

    protected void cacheByKey(List<T> objects, String fieldName) {
        try {
            Method getIdMethod = CommonUtils.getIdMethod(objects, fieldName);
            if (ReflectionUtils.invokeMethod((Method)getIdMethod, objects.stream().findAny().get()) != null) {
                Map<String, Object> objMap = objects.stream().collect(Collectors.toMap(obj -> {
                    String str = (String)ReflectionUtils.invokeMethod((Method)getIdMethod, (Object)obj);
                    log.info("Caching the {}: {}", (Object)getIdMethod.getName(), (Object)str);
                    return str;
                }, obj -> obj, (obj1, obj2) -> obj2));
                this.redisTemplate.opsForHash().putAll((Object)this.tableName, objMap);
                this.redisTemplate.expire((Object)this.tableName, Long.parseLong(this.timeToLive), TimeUnit.SECONDS);
            }
        }
        catch (Exception exception) {
            log.warn("Error while saving to cache: {}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
        }
    }

    public void putInCache(List<T> objects) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        this.cacheByKey(objects, "clientReferenceId");
    }

    public void putInCache(List<T> objects, String key) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        this.cacheByKey(objects, key);
    }

    public List<T> find(Object searchObject, Integer limit, Integer offset, String tenantId, Long lastChangedSince, Boolean includeDeleted) throws QueryBuilderException {
        String query = this.selectQueryBuilder.build(searchObject);
        if ((query = query + " AND tenantId=:tenantId ").contains(this.tableName + " AND")) {
            query = query.replace(this.tableName + " AND", this.tableName + " WHERE");
        }
        if (Boolean.FALSE.equals(includeDeleted)) {
            query = query + "AND isDeleted=:isDeleted ";
        }
        if (lastChangedSince != null) {
            query = query + "AND lastModifiedTime>=:lastModifiedTime ";
        }
        query = query + "ORDER BY id ASC LIMIT :limit OFFSET :offset";
        Map<String, Object> paramsMap = this.selectQueryBuilder.getParamsMap();
        paramsMap.put("tenantId", tenantId);
        paramsMap.put("isDeleted", includeDeleted);
        paramsMap.put("lastModifiedTime", lastChangedSince);
        paramsMap.put("limit", limit);
        paramsMap.put("offset", offset);
        return this.namedParameterJdbcTemplate.query(query, paramsMap, this.rowMapper);
    }

    public List<String> validateIds(List<String> idsToValidate, String columnName) {
        List<T> validIds = this.findById(idsToValidate, false, columnName);
        if (validIds.isEmpty()) {
            return Collections.emptyList();
        }
        Method idMethod = CommonUtils.getIdMethod(validIds, columnName);
        return validIds.stream().map(obj -> (String)ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj)).collect(Collectors.toList());
    }
}

