/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.service;

import digit.models.coremodels.UserDetailResponse;
import digit.models.coremodels.UserSearchRequest;
import java.util.List;
import org.egov.common.contract.request.User;
import org.egov.common.http.client.ServiceRequestClient;
import org.egov.common.models.user.CreateUserRequest;
import org.egov.common.models.user.UserRequest;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnExpression(value="!'${egov.user.integration.enabled}'.isEmpty() && ${egov.user.integration.enabled:false} && !'${egov.user.host}'.isEmpty() && (!'${egov.search.user.url}'.isEmpty() || !'${egov.create.user.url}'.isEmpty() || !'${egov.update.user.url}'.isEmpty())")
public class UserService {
    private static final Logger log = LoggerFactory.getLogger(UserService.class);
    private final ServiceRequestClient restRepo;
    private final String host;
    private final String searchUrl;
    private final String createUrl;
    private final String updateUrl;

    @Autowired
    public UserService(ServiceRequestClient restRepo, @Value(value="${egov.user.host}") String host, @Value(value="${egov.search.user.url}") String searchUrl, @Value(value="${egov.create.user.url}") String createUrl, @Value(value="${egov.update.user.url}") String updateUrl) {
        this.restRepo = restRepo;
        this.host = host;
        this.searchUrl = searchUrl;
        this.createUrl = createUrl;
        this.updateUrl = updateUrl;
    }

    public List<User> search(UserSearchRequest userSearchRequest) {
        try {
            UserDetailResponse response = this.restRepo.fetchResult(new StringBuilder(this.host + this.searchUrl), userSearchRequest, UserDetailResponse.class);
            return response.getUser();
        }
        catch (Exception e) {
            log.error("Exception while searching users : ", (Throwable)e);
            throw new CustomException("USER_SEARCH_ERROR", e.getMessage());
        }
    }

    public List<UserRequest> create(CreateUserRequest createUserRequest) {
        try {
            org.egov.common.models.user.UserDetailResponse response = this.restRepo.fetchResult(new StringBuilder(this.host + this.createUrl), createUserRequest, org.egov.common.models.user.UserDetailResponse.class);
            return response.getUser();
        }
        catch (Exception e) {
            log.error("Exception while creating user : ", (Throwable)e);
            throw new CustomException("USER_CREATE_ERROR", e.getMessage());
        }
    }

    public List<UserRequest> update(CreateUserRequest createUserRequest) {
        try {
            org.egov.common.models.user.UserDetailResponse response = this.restRepo.fetchResult(new StringBuilder(this.host + this.updateUrl), createUserRequest, org.egov.common.models.user.UserDetailResponse.class);
            return response.getUser();
        }
        catch (Exception e) {
            log.error("Exception while updating user : ", (Throwable)e);
            throw new CustomException("USER_UPDATE_ERROR", e.getMessage());
        }
    }
}

