/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.user;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.egov.common.models.user.Address;
import org.egov.common.models.user.AddressType;
import org.egov.common.models.user.BloodGroup;
import org.egov.common.models.user.Gender;
import org.egov.common.models.user.GuardianRelation;
import org.egov.common.models.user.Role;
import org.egov.common.models.user.RoleRequest;
import org.egov.common.models.user.User;
import org.egov.common.models.user.UserType;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.SafeHtml;

public class UserRequest {
    private Long id;
    @SafeHtml
    @Size(max=64)
    private @SafeHtml @Size(max=64) String userName;
    @SafeHtml
    @Size(max=5)
    private @SafeHtml @Size(max=5) String salutation;
    @Pattern(regexp="^[^\\\\$\\\"<>?\\\\\\\\~`!@#$%^()+={}\\\\[\\\\]*,:;\u201c\u201d\u2018\u2019]*$")
    @Size(max=50)
    private @Pattern(regexp="^[^\\\\$\\\"<>?\\\\\\\\~`!@#$%^()+={}\\\\[\\\\]*,:;\u201c\u201d\u2018\u2019]*$") @Size(max=50) String name;
    @Pattern(regexp="^[a-zA-Z ]*$")
    @Size(max=15)
    private @Pattern(regexp="^[a-zA-Z ]*$") @Size(max=15) String gender;
    @Pattern(regexp="(^$|[0-9]{10})")
    private @Pattern(regexp="(^$|[0-9]{10})") String mobileNumber;
    @Pattern(regexp="(^$|[0-9]{10})")
    private @Pattern(regexp="(^$|[0-9]{10})") String alternatemobilenumber;
    @Email
    @Size(max=128)
    private @Email @Size(max=128) String emailId;
    @SafeHtml
    @Size(max=50)
    private @SafeHtml @Size(max=50) String altContactNumber;
    @SafeHtml
    @Size(max=10)
    private @SafeHtml @Size(max=10) String pan;
    @SafeHtml
    @Size(max=20)
    private @SafeHtml @Size(max=20) String aadhaarNumber;
    @SafeHtml
    @Size(max=300)
    private @SafeHtml @Size(max=300) String permanentAddress;
    @SafeHtml
    @Pattern(regexp="^[a-zA-Z. ]*$")
    @Size(max=50)
    private @SafeHtml @Pattern(regexp="^[a-zA-Z. ]*$") @Size(max=50) String permanentCity;
    @SafeHtml
    @Pattern(regexp="^[1-9][0-9]{5}$")
    @Size(max=10)
    private @SafeHtml @Pattern(regexp="^[1-9][0-9]{5}$") @Size(max=10) String permanentPinCode;
    @SafeHtml
    @Size(max=300)
    private @SafeHtml @Size(max=300) String correspondenceAddress;
    @Pattern(regexp="^[a-zA-Z. ]*$")
    @Size(max=50)
    private @Pattern(regexp="^[a-zA-Z. ]*$") @Size(max=50) String correspondenceCity;
    @Pattern(regexp="^[1-9][0-9]{5}$")
    @Size(max=10)
    private @Pattern(regexp="^[1-9][0-9]{5}$") @Size(max=10) String correspondencePinCode;
    private Boolean active;
    @SafeHtml
    @Size(max=16)
    private @SafeHtml @Size(max=16) String locale;
    private UserType type;
    private Boolean accountLocked;
    private Long accountLockedDate;
    @Pattern(regexp="^[^\\\\$\\\"<>?\\\\\\\\~`!@#$%^()+={}\\\\[\\\\]*,:;\u201c\u201d\u2018\u2019]*$")
    @Size(max=50)
    private @Pattern(regexp="^[^\\\\$\\\"<>?\\\\\\\\~`!@#$%^()+={}\\\\[\\\\]*,:;\u201c\u201d\u2018\u2019]*$") @Size(max=50) String fatherOrHusbandName;
    private GuardianRelation relationship;
    @SafeHtml
    @Size(max=36)
    private @SafeHtml @Size(max=36) String signature;
    @SafeHtml
    @Size(max=32)
    private @SafeHtml @Size(max=32) String bloodGroup;
    @SafeHtml
    @Size(max=36)
    private @SafeHtml @Size(max=36) String photo;
    @SafeHtml
    @Size(max=300)
    private @SafeHtml @Size(max=300) String identificationMark;
    private Long createdBy;
    @Size(max=64)
    private @Size(max=64) String password;
    @SafeHtml
    private String otpReference;
    private Long lastModifiedBy;
    @Pattern(regexp="^[a-zA-Z. ]*$")
    @Size(max=50)
    private @Pattern(regexp="^[a-zA-Z. ]*$") @Size(max=50) String tenantId;
    private Set<RoleRequest> roles;
    @SafeHtml
    @Size(max=36)
    private @SafeHtml @Size(max=36) String uuid;
    @JsonFormat(pattern="dd-MM-yyyy HH:mm:ss")
    private Date createdDate;
    @JsonFormat(pattern="dd-MM-yyyy HH:mm:ss")
    private Date lastModifiedDate;
    @JsonFormat(pattern="dd/MM/yyyy")
    private Date dob;
    @JsonFormat(pattern="dd-MM-yyyy HH:mm:ss")
    private Date pwdExpiryDate;

    public UserRequest(User user) {
        this.id = user.getId();
        this.userName = user.getUsername();
        this.salutation = user.getSalutation();
        this.name = user.getName();
        this.gender = user.getGender() != null ? user.getGender().toString() : null;
        this.mobileNumber = user.getMobileNumber();
        this.emailId = user.getEmailId();
        this.altContactNumber = user.getAltContactNumber();
        this.pan = user.getPan();
        this.aadhaarNumber = user.getAadhaarNumber();
        this.active = user.getActive();
        this.dob = user.getDob();
        this.pwdExpiryDate = user.getPasswordExpiryDate();
        this.locale = user.getLocale();
        this.type = user.getType();
        this.accountLocked = user.getAccountLocked();
        this.accountLockedDate = user.getAccountLockedDate();
        this.signature = user.getSignature();
        this.bloodGroup = user.getBloodGroup() != null ? user.getBloodGroup().getValue() : null;
        this.photo = user.getPhoto();
        this.identificationMark = user.getIdentificationMark();
        this.createdBy = user.getCreatedBy();
        this.createdDate = user.getCreatedDate();
        this.lastModifiedBy = user.getLastModifiedBy();
        this.lastModifiedDate = user.getLastModifiedDate();
        this.tenantId = user.getTenantId();
        this.roles = this.convertDomainRoleToContract(user.getRoles());
        this.fatherOrHusbandName = user.getGuardian();
        this.relationship = user.getGuardianRelation();
        this.uuid = user.getUuid();
        this.alternatemobilenumber = user.getAlternateMobileNumber();
        this.mapPermanentAddress(user);
        this.mapCorrespondenceAddress(user);
    }

    private void mapCorrespondenceAddress(User user) {
        if (user.getCorrespondenceAddress() != null) {
            this.correspondenceAddress = user.getCorrespondenceAddress().getAddress();
            this.correspondenceCity = user.getCorrespondenceAddress().getCity();
            this.correspondencePinCode = user.getCorrespondenceAddress().getPinCode();
        }
    }

    private void mapPermanentAddress(User user) {
        if (user.getPermanentAddress() != null) {
            this.permanentAddress = user.getPermanentAddress().getAddress();
            this.permanentCity = user.getPermanentAddress().getCity();
            this.permanentPinCode = user.getPermanentAddress().getPinCode();
        }
    }

    private Set<RoleRequest> convertDomainRoleToContract(Set<Role> roleEntities) {
        if (roleEntities == null) {
            return new HashSet<RoleRequest>();
        }
        return roleEntities.stream().map(RoleRequest::new).collect(Collectors.toSet());
    }

    @JsonIgnore
    public User toDomain(Long loggedInUserId, boolean isCreate) {
        BloodGroup bloodGroup = null;
        try {
            if (this.bloodGroup != null) {
                bloodGroup = BloodGroup.valueOf(this.bloodGroup.toUpperCase());
            }
        }
        catch (Exception e) {
            bloodGroup = BloodGroup.fromValue(this.bloodGroup);
        }
        return User.builder().uuid(this.uuid).id(this.id).name(this.name).username(this.userName).salutation(this.salutation).mobileNumber(this.mobileNumber).emailId(this.emailId).altContactNumber(this.altContactNumber).pan(this.pan).aadhaarNumber(this.aadhaarNumber).active(this.isActive(isCreate)).dob(this.dob).passwordExpiryDate(this.pwdExpiryDate).locale(this.locale).type(this.type).accountLocked(this.isAccountLocked(isCreate)).accountLockedDate(this.accountLockedDate).signature(this.signature).photo(this.photo).identificationMark(this.identificationMark).gender(this.gender != null ? Gender.valueOf(this.gender.toUpperCase()) : null).bloodGroup(bloodGroup).lastModifiedDate(new Date()).createdDate(new Date()).otpReference(this.otpReference).tenantId(this.tenantId).password(this.password).roles(this.toDomainRoles()).loggedInUserId(loggedInUserId).permanentAddress(this.toDomainPermanentAddress()).correspondenceAddress(this.toDomainCorrespondenceAddress()).guardian(this.fatherOrHusbandName).guardianRelation(this.relationship).alternateMobileNumber(this.alternatemobilenumber).build();
    }

    private Boolean isActive(boolean isCreate) {
        if (this.active == null && isCreate) {
            return false;
        }
        return this.active;
    }

    private Boolean isAccountLocked(boolean isCreate) {
        if (this.accountLocked == null && isCreate) {
            return false;
        }
        return this.accountLocked;
    }

    private Address toDomainPermanentAddress() {
        return Address.builder().type(AddressType.PERMANENT).city(this.permanentCity).pinCode(this.permanentPinCode).address(this.permanentAddress).build();
    }

    private Address toDomainCorrespondenceAddress() {
        return Address.builder().type(AddressType.CORRESPONDENCE).city(this.correspondenceCity).pinCode(this.correspondencePinCode).address(this.correspondenceAddress).build();
    }

    private Set<Role> toDomainRoles() {
        return this.roles != null ? this.roles.stream().map(RoleRequest::toDomain).distinct().collect(Collectors.toSet()) : null;
    }

    public static UserRequestBuilder builder() {
        return new UserRequestBuilder();
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setSalutation(String salutation) {
        this.salutation = salutation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public void setAlternatemobilenumber(String alternatemobilenumber) {
        this.alternatemobilenumber = alternatemobilenumber;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public void setAltContactNumber(String altContactNumber) {
        this.altContactNumber = altContactNumber;
    }

    public void setPan(String pan) {
        this.pan = pan;
    }

    public void setAadhaarNumber(String aadhaarNumber) {
        this.aadhaarNumber = aadhaarNumber;
    }

    public void setPermanentAddress(String permanentAddress) {
        this.permanentAddress = permanentAddress;
    }

    public void setPermanentCity(String permanentCity) {
        this.permanentCity = permanentCity;
    }

    public void setPermanentPinCode(String permanentPinCode) {
        this.permanentPinCode = permanentPinCode;
    }

    public void setCorrespondenceAddress(String correspondenceAddress) {
        this.correspondenceAddress = correspondenceAddress;
    }

    public void setCorrespondenceCity(String correspondenceCity) {
        this.correspondenceCity = correspondenceCity;
    }

    public void setCorrespondencePinCode(String correspondencePinCode) {
        this.correspondencePinCode = correspondencePinCode;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setType(UserType type) {
        this.type = type;
    }

    public void setAccountLocked(Boolean accountLocked) {
        this.accountLocked = accountLocked;
    }

    public void setAccountLockedDate(Long accountLockedDate) {
        this.accountLockedDate = accountLockedDate;
    }

    public void setFatherOrHusbandName(String fatherOrHusbandName) {
        this.fatherOrHusbandName = fatherOrHusbandName;
    }

    public void setRelationship(GuardianRelation relationship) {
        this.relationship = relationship;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setBloodGroup(String bloodGroup) {
        this.bloodGroup = bloodGroup;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }

    public void setIdentificationMark(String identificationMark) {
        this.identificationMark = identificationMark;
    }

    public void setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setOtpReference(String otpReference) {
        this.otpReference = otpReference;
    }

    public void setLastModifiedBy(Long lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setRoles(Set<RoleRequest> roles) {
        this.roles = roles;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setDob(Date dob) {
        this.dob = dob;
    }

    public void setPwdExpiryDate(Date pwdExpiryDate) {
        this.pwdExpiryDate = pwdExpiryDate;
    }

    public Long getId() {
        return this.id;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSalutation() {
        return this.salutation;
    }

    public String getName() {
        return this.name;
    }

    public String getGender() {
        return this.gender;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public String getAlternatemobilenumber() {
        return this.alternatemobilenumber;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public String getAltContactNumber() {
        return this.altContactNumber;
    }

    public String getPan() {
        return this.pan;
    }

    public String getAadhaarNumber() {
        return this.aadhaarNumber;
    }

    public String getPermanentAddress() {
        return this.permanentAddress;
    }

    public String getPermanentCity() {
        return this.permanentCity;
    }

    public String getPermanentPinCode() {
        return this.permanentPinCode;
    }

    public String getCorrespondenceAddress() {
        return this.correspondenceAddress;
    }

    public String getCorrespondenceCity() {
        return this.correspondenceCity;
    }

    public String getCorrespondencePinCode() {
        return this.correspondencePinCode;
    }

    public Boolean getActive() {
        return this.active;
    }

    public String getLocale() {
        return this.locale;
    }

    public UserType getType() {
        return this.type;
    }

    public Boolean getAccountLocked() {
        return this.accountLocked;
    }

    public Long getAccountLockedDate() {
        return this.accountLockedDate;
    }

    public String getFatherOrHusbandName() {
        return this.fatherOrHusbandName;
    }

    public GuardianRelation getRelationship() {
        return this.relationship;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getBloodGroup() {
        return this.bloodGroup;
    }

    public String getPhoto() {
        return this.photo;
    }

    public String getIdentificationMark() {
        return this.identificationMark;
    }

    public Long getCreatedBy() {
        return this.createdBy;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOtpReference() {
        return this.otpReference;
    }

    public Long getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Set<RoleRequest> getRoles() {
        return this.roles;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Date getDob() {
        return this.dob;
    }

    public Date getPwdExpiryDate() {
        return this.pwdExpiryDate;
    }

    public UserRequest() {
    }

    public UserRequest(Long id, String userName, String salutation, String name, String gender, String mobileNumber, String alternatemobilenumber, String emailId, String altContactNumber, String pan, String aadhaarNumber, String permanentAddress, String permanentCity, String permanentPinCode, String correspondenceAddress, String correspondenceCity, String correspondencePinCode, Boolean active, String locale, UserType type, Boolean accountLocked, Long accountLockedDate, String fatherOrHusbandName, GuardianRelation relationship, String signature, String bloodGroup, String photo, String identificationMark, Long createdBy, String password, String otpReference, Long lastModifiedBy, String tenantId, Set<RoleRequest> roles, String uuid, Date createdDate, Date lastModifiedDate, Date dob, Date pwdExpiryDate) {
        this.id = id;
        this.userName = userName;
        this.salutation = salutation;
        this.name = name;
        this.gender = gender;
        this.mobileNumber = mobileNumber;
        this.alternatemobilenumber = alternatemobilenumber;
        this.emailId = emailId;
        this.altContactNumber = altContactNumber;
        this.pan = pan;
        this.aadhaarNumber = aadhaarNumber;
        this.permanentAddress = permanentAddress;
        this.permanentCity = permanentCity;
        this.permanentPinCode = permanentPinCode;
        this.correspondenceAddress = correspondenceAddress;
        this.correspondenceCity = correspondenceCity;
        this.correspondencePinCode = correspondencePinCode;
        this.active = active;
        this.locale = locale;
        this.type = type;
        this.accountLocked = accountLocked;
        this.accountLockedDate = accountLockedDate;
        this.fatherOrHusbandName = fatherOrHusbandName;
        this.relationship = relationship;
        this.signature = signature;
        this.bloodGroup = bloodGroup;
        this.photo = photo;
        this.identificationMark = identificationMark;
        this.createdBy = createdBy;
        this.password = password;
        this.otpReference = otpReference;
        this.lastModifiedBy = lastModifiedBy;
        this.tenantId = tenantId;
        this.roles = roles;
        this.uuid = uuid;
        this.createdDate = createdDate;
        this.lastModifiedDate = lastModifiedDate;
        this.dob = dob;
        this.pwdExpiryDate = pwdExpiryDate;
    }

    public String toString() {
        return "UserRequest(id=" + this.getId() + ", userName=" + this.getUserName() + ", salutation=" + this.getSalutation() + ", name=" + this.getName() + ", gender=" + this.getGender() + ", mobileNumber=" + this.getMobileNumber() + ", alternatemobilenumber=" + this.getAlternatemobilenumber() + ", emailId=" + this.getEmailId() + ", altContactNumber=" + this.getAltContactNumber() + ", pan=" + this.getPan() + ", aadhaarNumber=" + this.getAadhaarNumber() + ", permanentAddress=" + this.getPermanentAddress() + ", permanentCity=" + this.getPermanentCity() + ", permanentPinCode=" + this.getPermanentPinCode() + ", correspondenceAddress=" + this.getCorrespondenceAddress() + ", correspondenceCity=" + this.getCorrespondenceCity() + ", correspondencePinCode=" + this.getCorrespondencePinCode() + ", active=" + this.getActive() + ", locale=" + this.getLocale() + ", type=" + (Object)((Object)this.getType()) + ", accountLocked=" + this.getAccountLocked() + ", accountLockedDate=" + this.getAccountLockedDate() + ", fatherOrHusbandName=" + this.getFatherOrHusbandName() + ", relationship=" + (Object)((Object)this.getRelationship()) + ", signature=" + this.getSignature() + ", bloodGroup=" + this.getBloodGroup() + ", photo=" + this.getPhoto() + ", identificationMark=" + this.getIdentificationMark() + ", createdBy=" + this.getCreatedBy() + ", password=" + this.getPassword() + ", otpReference=" + this.getOtpReference() + ", lastModifiedBy=" + this.getLastModifiedBy() + ", tenantId=" + this.getTenantId() + ", roles=" + this.getRoles() + ", uuid=" + this.getUuid() + ", createdDate=" + this.getCreatedDate() + ", lastModifiedDate=" + this.getLastModifiedDate() + ", dob=" + this.getDob() + ", pwdExpiryDate=" + this.getPwdExpiryDate() + ")";
    }

    public static class UserRequestBuilder {
        private Long id;
        private String userName;
        private String salutation;
        private String name;
        private String gender;
        private String mobileNumber;
        private String alternatemobilenumber;
        private String emailId;
        private String altContactNumber;
        private String pan;
        private String aadhaarNumber;
        private String permanentAddress;
        private String permanentCity;
        private String permanentPinCode;
        private String correspondenceAddress;
        private String correspondenceCity;
        private String correspondencePinCode;
        private Boolean active;
        private String locale;
        private UserType type;
        private Boolean accountLocked;
        private Long accountLockedDate;
        private String fatherOrHusbandName;
        private GuardianRelation relationship;
        private String signature;
        private String bloodGroup;
        private String photo;
        private String identificationMark;
        private Long createdBy;
        private String password;
        private String otpReference;
        private Long lastModifiedBy;
        private String tenantId;
        private Set<RoleRequest> roles;
        private String uuid;
        private Date createdDate;
        private Date lastModifiedDate;
        private Date dob;
        private Date pwdExpiryDate;

        UserRequestBuilder() {
        }

        public UserRequestBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public UserRequestBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public UserRequestBuilder salutation(String salutation) {
            this.salutation = salutation;
            return this;
        }

        public UserRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UserRequestBuilder gender(String gender) {
            this.gender = gender;
            return this;
        }

        public UserRequestBuilder mobileNumber(String mobileNumber) {
            this.mobileNumber = mobileNumber;
            return this;
        }

        public UserRequestBuilder alternatemobilenumber(String alternatemobilenumber) {
            this.alternatemobilenumber = alternatemobilenumber;
            return this;
        }

        public UserRequestBuilder emailId(String emailId) {
            this.emailId = emailId;
            return this;
        }

        public UserRequestBuilder altContactNumber(String altContactNumber) {
            this.altContactNumber = altContactNumber;
            return this;
        }

        public UserRequestBuilder pan(String pan) {
            this.pan = pan;
            return this;
        }

        public UserRequestBuilder aadhaarNumber(String aadhaarNumber) {
            this.aadhaarNumber = aadhaarNumber;
            return this;
        }

        public UserRequestBuilder permanentAddress(String permanentAddress) {
            this.permanentAddress = permanentAddress;
            return this;
        }

        public UserRequestBuilder permanentCity(String permanentCity) {
            this.permanentCity = permanentCity;
            return this;
        }

        public UserRequestBuilder permanentPinCode(String permanentPinCode) {
            this.permanentPinCode = permanentPinCode;
            return this;
        }

        public UserRequestBuilder correspondenceAddress(String correspondenceAddress) {
            this.correspondenceAddress = correspondenceAddress;
            return this;
        }

        public UserRequestBuilder correspondenceCity(String correspondenceCity) {
            this.correspondenceCity = correspondenceCity;
            return this;
        }

        public UserRequestBuilder correspondencePinCode(String correspondencePinCode) {
            this.correspondencePinCode = correspondencePinCode;
            return this;
        }

        public UserRequestBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public UserRequestBuilder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public UserRequestBuilder type(UserType type) {
            this.type = type;
            return this;
        }

        public UserRequestBuilder accountLocked(Boolean accountLocked) {
            this.accountLocked = accountLocked;
            return this;
        }

        public UserRequestBuilder accountLockedDate(Long accountLockedDate) {
            this.accountLockedDate = accountLockedDate;
            return this;
        }

        public UserRequestBuilder fatherOrHusbandName(String fatherOrHusbandName) {
            this.fatherOrHusbandName = fatherOrHusbandName;
            return this;
        }

        public UserRequestBuilder relationship(GuardianRelation relationship) {
            this.relationship = relationship;
            return this;
        }

        public UserRequestBuilder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public UserRequestBuilder bloodGroup(String bloodGroup) {
            this.bloodGroup = bloodGroup;
            return this;
        }

        public UserRequestBuilder photo(String photo) {
            this.photo = photo;
            return this;
        }

        public UserRequestBuilder identificationMark(String identificationMark) {
            this.identificationMark = identificationMark;
            return this;
        }

        public UserRequestBuilder createdBy(Long createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public UserRequestBuilder password(String password) {
            this.password = password;
            return this;
        }

        public UserRequestBuilder otpReference(String otpReference) {
            this.otpReference = otpReference;
            return this;
        }

        public UserRequestBuilder lastModifiedBy(Long lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public UserRequestBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public UserRequestBuilder roles(Set<RoleRequest> roles) {
            this.roles = roles;
            return this;
        }

        public UserRequestBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public UserRequestBuilder createdDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public UserRequestBuilder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public UserRequestBuilder dob(Date dob) {
            this.dob = dob;
            return this;
        }

        public UserRequestBuilder pwdExpiryDate(Date pwdExpiryDate) {
            this.pwdExpiryDate = pwdExpiryDate;
            return this;
        }

        public UserRequest build() {
            return new UserRequest(this.id, this.userName, this.salutation, this.name, this.gender, this.mobileNumber, this.alternatemobilenumber, this.emailId, this.altContactNumber, this.pan, this.aadhaarNumber, this.permanentAddress, this.permanentCity, this.permanentPinCode, this.correspondenceAddress, this.correspondenceCity, this.correspondencePinCode, this.active, this.locale, this.type, this.accountLocked, this.accountLockedDate, this.fatherOrHusbandName, this.relationship, this.signature, this.bloodGroup, this.photo, this.identificationMark, this.createdBy, this.password, this.otpReference, this.lastModifiedBy, this.tenantId, this.roles, this.uuid, this.createdDate, this.lastModifiedDate, this.dob, this.pwdExpiryDate);
        }

        public String toString() {
            return "UserRequest.UserRequestBuilder(id=" + this.id + ", userName=" + this.userName + ", salutation=" + this.salutation + ", name=" + this.name + ", gender=" + this.gender + ", mobileNumber=" + this.mobileNumber + ", alternatemobilenumber=" + this.alternatemobilenumber + ", emailId=" + this.emailId + ", altContactNumber=" + this.altContactNumber + ", pan=" + this.pan + ", aadhaarNumber=" + this.aadhaarNumber + ", permanentAddress=" + this.permanentAddress + ", permanentCity=" + this.permanentCity + ", permanentPinCode=" + this.permanentPinCode + ", correspondenceAddress=" + this.correspondenceAddress + ", correspondenceCity=" + this.correspondenceCity + ", correspondencePinCode=" + this.correspondencePinCode + ", active=" + this.active + ", locale=" + this.locale + ", type=" + (Object)((Object)this.type) + ", accountLocked=" + this.accountLocked + ", accountLockedDate=" + this.accountLockedDate + ", fatherOrHusbandName=" + this.fatherOrHusbandName + ", relationship=" + (Object)((Object)this.relationship) + ", signature=" + this.signature + ", bloodGroup=" + this.bloodGroup + ", photo=" + this.photo + ", identificationMark=" + this.identificationMark + ", createdBy=" + this.createdBy + ", password=" + this.password + ", otpReference=" + this.otpReference + ", lastModifiedBy=" + this.lastModifiedBy + ", tenantId=" + this.tenantId + ", roles=" + this.roles + ", uuid=" + this.uuid + ", createdDate=" + this.createdDate + ", lastModifiedDate=" + this.lastModifiedDate + ", dob=" + this.dob + ", pwdExpiryDate=" + this.pwdExpiryDate + ")";
        }
    }
}

