/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.data.mapper;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.egov.common.utils.ObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class GenericRowMapper<T>
implements RowMapper<T> {
    private Class<T> mappedClass;

    public GenericRowMapper(Class<T> mappedClass) {
        this.mappedClass = mappedClass;
    }

    private Object mapRow(Class<?> clazz, Map<String, Object> row) throws IllegalAccessException, IllegalArgumentException {
        Field[] fields;
        Object parentObject = BeanUtils.instantiateClass(clazz);
        for (Field f : fields = parentObject.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            if (!f.getType().isPrimitive() && !ObjectUtils.isWrapper(f)) {
                Object nestedObject = this.mapRow(f.getType(), row);
                f.set(parentObject, nestedObject);
                continue;
            }
            Object value = row.get(f.getName());
            f.set(parentObject, value);
        }
        return parentObject;
    }

    private Map<String, Object> getMap(ResultSet rs) throws SQLException, ClassNotFoundException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        HashMap<String, Object> row = new HashMap<String, Object>(columnCount);
        for (int index = 1; index <= columnCount; ++index) {
            String column = JdbcUtils.lookupColumnName((ResultSetMetaData)metaData, (int)index);
            Object value = JdbcUtils.getResultSetValue((ResultSet)rs, (int)index, Class.forName(metaData.getColumnClassName(index)));
            row.put(column, value);
        }
        return row;
    }

    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        Object instance;
        try {
            Map<String, Object> row = this.getMap(rs);
            instance = this.mapRow(this.mappedClass, row);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return (T)instance;
    }
}

