/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.user;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.egov.common.models.user.AddressType;

public class Address {
    private String pinCode;
    private String city;
    private String address;
    private AddressType type;
    private Long id;
    private String tenantId;
    private Long userId;
    private String addressType;
    private Long LastModifiedBy;
    private Date LastModifiedDate;

    boolean isInvalid() {
        return this.isPinCodeInvalid() || this.isCityInvalid() || this.isAddressInvalid();
    }

    boolean isNotEmpty() {
        return StringUtils.isNotEmpty((CharSequence)this.pinCode) || StringUtils.isNotEmpty((CharSequence)this.city) || StringUtils.isNotEmpty((CharSequence)this.address);
    }

    boolean isPinCodeInvalid() {
        return this.pinCode != null && this.pinCode.length() > 10;
    }

    boolean isCityInvalid() {
        return this.city != null && this.city.length() > 300;
    }

    boolean isAddressInvalid() {
        return this.address != null && this.address.length() > 300;
    }

    public static AddressBuilder builder() {
        return new AddressBuilder();
    }

    public String getPinCode() {
        return this.pinCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getAddress() {
        return this.address;
    }

    public AddressType getType() {
        return this.type;
    }

    public Long getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public Long getLastModifiedBy() {
        return this.LastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.LastModifiedDate;
    }

    public void setPinCode(String pinCode) {
        this.pinCode = pinCode;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setType(AddressType type) {
        this.type = type;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public void setLastModifiedBy(Long LastModifiedBy) {
        this.LastModifiedBy = LastModifiedBy;
    }

    public void setLastModifiedDate(Date LastModifiedDate) {
        this.LastModifiedDate = LastModifiedDate;
    }

    public Address(String pinCode, String city, String address, AddressType type, Long id, String tenantId, Long userId, String addressType, Long LastModifiedBy, Date LastModifiedDate) {
        this.pinCode = pinCode;
        this.city = city;
        this.address = address;
        this.type = type;
        this.id = id;
        this.tenantId = tenantId;
        this.userId = userId;
        this.addressType = addressType;
        this.LastModifiedBy = LastModifiedBy;
        this.LastModifiedDate = LastModifiedDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Address;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    public static class AddressBuilder {
        private String pinCode;
        private String city;
        private String address;
        private AddressType type;
        private Long id;
        private String tenantId;
        private Long userId;
        private String addressType;
        private Long LastModifiedBy;
        private Date LastModifiedDate;

        AddressBuilder() {
        }

        public AddressBuilder pinCode(String pinCode) {
            this.pinCode = pinCode;
            return this;
        }

        public AddressBuilder city(String city) {
            this.city = city;
            return this;
        }

        public AddressBuilder address(String address) {
            this.address = address;
            return this;
        }

        public AddressBuilder type(AddressType type) {
            this.type = type;
            return this;
        }

        public AddressBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AddressBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public AddressBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public AddressBuilder addressType(String addressType) {
            this.addressType = addressType;
            return this;
        }

        public AddressBuilder LastModifiedBy(Long LastModifiedBy) {
            this.LastModifiedBy = LastModifiedBy;
            return this;
        }

        public AddressBuilder LastModifiedDate(Date LastModifiedDate) {
            this.LastModifiedDate = LastModifiedDate;
            return this;
        }

        public Address build() {
            return new Address(this.pinCode, this.city, this.address, this.type, this.id, this.tenantId, this.userId, this.addressType, this.LastModifiedBy, this.LastModifiedDate);
        }

        public String toString() {
            return "Address.AddressBuilder(pinCode=" + this.pinCode + ", city=" + this.city + ", address=" + this.address + ", type=" + (Object)((Object)this.type) + ", id=" + this.id + ", tenantId=" + this.tenantId + ", userId=" + this.userId + ", addressType=" + this.addressType + ", LastModifiedBy=" + this.LastModifiedBy + ", LastModifiedDate=" + this.LastModifiedDate + ")";
        }
    }
}

