/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.hc.core5.net.URIBuilder;
import org.hisp.dhis.auth.Authentication;
import org.hisp.dhis.auth.BasicAuthentication;
import org.hisp.dhis.response.Dhis2ClientException;

public class Dhis2Config {
    private final String url;
    private final Authentication authentication;

    public Dhis2Config(String url, String username, String password) {
        Validate.notNull((Object)url);
        Validate.notNull((Object)username);
        Validate.notNull((Object)password);
        this.url = this.normalizeUrl(url);
        this.authentication = new BasicAuthentication(username, password);
    }

    public Dhis2Config(String url, Authentication authentication) {
        Validate.notNull((Object)url);
        Validate.notNull((Object)authentication);
        this.url = this.normalizeUrl(url);
        this.authentication = authentication;
    }

    private String normalizeUrl(String url) {
        return StringUtils.removeEnd((String)url, (String)"/");
    }

    public URI getResolvedUrl(String path) {
        Validate.notNull((Object)path);
        try {
            return new URIBuilder(this.url).appendPath("api").appendPath(path).build();
        }
        catch (URISyntaxException ex) {
            throw new Dhis2ClientException(String.format("Invalid URI syntax: '%s'", this.url), ex);
        }
    }

    public URIBuilder getResolvedUriBuilder() {
        try {
            return new URIBuilder(this.url).appendPath("api");
        }
        catch (URISyntaxException ex) {
            throw new Dhis2ClientException(String.format("Invalid URI syntax: '%s'", this.url), ex);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }
}

