/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.io.InputStreamReader;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class ExternalProcessRunner {
    public int run(String[] command, Consumer<String> onStdOut, Consumer<String> onStdErr) {
        Process process = new ProcessBuilder(command).start();
        try (InputStreamReader outStream = new InputStreamReader(process.getInputStream());
             InputStreamReader errStream = new InputStreamReader(process.getErrorStream());
             Scanner stdOut = new Scanner(outStream);
             Scanner stdErr = new Scanner(errStream);){
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Future<?> handleStdOut = executorService.submit(() -> {
                while (stdOut.hasNextLine()) {
                    onStdOut.accept(stdOut.nextLine());
                }
            });
            Future<?> handleStdErr = executorService.submit(() -> {
                while (stdErr.hasNextLine()) {
                    onStdErr.accept(stdErr.nextLine());
                }
            });
            handleStdOut.get();
            handleStdErr.get();
        }
        return process.waitFor();
    }
}

