/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.egov.tracer.config.TracerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;

@Aspect
public class KafkaListenerLoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(KafkaListenerLoggingAspect.class);
    private static final String RECEIVED_MESSAGE_WITH_BODY = "Received message from topics: {} with body {}";
    private static final String RECEIVED_MESSAGE = "Received message from topics: {}";
    private static final String PROCESSED_SUCCESS_MESSAGE = "Processed message successfully";
    private static final String EXCEPTION_MESSAGE = "Exception processing message";
    private static final String JOIN_DELIMITER = ", ";
    private ObjectMapper objectMapper;
    private TracerProperties tracerProperties;

    public KafkaListenerLoggingAspect(TracerProperties tracerProperties) {
        this.tracerProperties = tracerProperties;
        this.objectMapper = new ObjectMapper();
    }

    @Pointcut(value=" within(org.egov..*) && @annotation(org.springframework.kafka.annotation.KafkaListener)")
    public void anyKafkaConsumer() {
    }

    @Around(value="anyKafkaConsumer() ")
    public Object logAction(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        KafkaListener myAnnotation = method.getAnnotation(KafkaListener.class);
        try {
            String topics;
            if (this.tracerProperties.isDetailedTracingEnabled()) {
                topics = this.getListeningTopics(myAnnotation);
                String messageBodyAsString = this.getMessageBodyAsString(args);
                log.info(RECEIVED_MESSAGE_WITH_BODY, (Object)topics, (Object)messageBodyAsString);
            } else {
                topics = this.getListeningTopics(myAnnotation);
                log.info(RECEIVED_MESSAGE, (Object)topics);
            }
            Object result = joinPoint.proceed();
            log.info(PROCESSED_SUCCESS_MESSAGE);
            return result;
        }
        catch (Exception e) {
            log.error(EXCEPTION_MESSAGE, (Throwable)e);
            throw e;
        }
    }

    private String getMessageBodyAsString(Object[] args) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString(this.getMessageBody(args));
    }

    private Object getMessageBody(Object[] args) {
        return Stream.of(args).filter(parameterObject -> this.isNotAcknowledgmentParameter(parameterObject) && this.isNotString(parameterObject)).findFirst().map(parameterObject -> parameterObject).orElse(null);
    }

    private boolean isNotString(Object o) {
        return !(o instanceof String);
    }

    private boolean isNotAcknowledgmentParameter(Object o) {
        return !(o instanceof Acknowledgment);
    }

    private String getListeningTopics(KafkaListener myAnnotation) {
        return Stream.of(myAnnotation.topics()).map(topic -> this.tracerProperties.getResolvedPropertyValue((String)topic)).collect(Collectors.joining(JOIN_DELIMITER));
    }
}

