/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.egov.tracer.config.TracerProperties;
import org.egov.tracer.http.CacheableSimpleClientHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestTemplate;

public class LogAwareRestTemplate
extends RestTemplate {
    private static final Logger log = LoggerFactory.getLogger(LogAwareRestTemplate.class);
    private static final String REQUEST_MESSAGE_WITH_BODY = "Sending request to {} with verb {} with body {}";
    private static final String REQUEST_MESSAGE = "Sending request to {} with verb {}";
    private static final String RESPONSE_MESSAGE_WITH_BODY = "Received from {} response code {} and body {}: ";
    private static final String RESPONSE_MESSAGE = "Received response from {}";
    private static final String UTF_8 = "UTF-8";
    private static final String RESPONSE_BODY_ERROR_MESSAGE = "Error reading response body";
    private static final String RESPONSE_CODE_ERROR_MESSAGE = "Error reading response code";
    private static final String EMPTY_BODY = "<EMPTY BODY>";
    private TracerProperties tracerProperties;

    public LogAwareRestTemplate(TracerProperties tracerProperties) {
        this.tracerProperties = tracerProperties;
        this.setInterceptors(Collections.singletonList(this.logRequestAndResponse()));
    }

    private ClientHttpRequestInterceptor logRequestAndResponse() {
        return (httpRequest, body, clientHttpRequestExecution) -> {
            this.logRequest(httpRequest, body);
            ClientHttpResponse rawResponse = clientHttpRequestExecution.execute(httpRequest, body);
            if (this.tracerProperties.isDetailedTracingDisabled()) {
                log.info(RESPONSE_MESSAGE, (Object)httpRequest.getURI());
                return rawResponse;
            }
            CacheableSimpleClientHttpResponse response = new CacheableSimpleClientHttpResponse(rawResponse);
            this.logResponse((ClientHttpResponse)response, httpRequest.getURI());
            return response;
        };
    }

    private void logResponse(ClientHttpResponse response, URI uri) {
        try {
            String body = this.getBodyString(response);
            log.info(RESPONSE_MESSAGE_WITH_BODY, new Object[]{uri, response.getStatusCode(), body});
        }
        catch (IOException e) {
            log.error(RESPONSE_CODE_ERROR_MESSAGE, (Throwable)e);
        }
    }

    private String getBodyString(ClientHttpResponse response) {
        try {
            if (response != null && response.getBody() != null) {
                return IOUtils.toString((InputStream)response.getBody(), (String)UTF_8);
            }
            return EMPTY_BODY;
        }
        catch (IOException e) {
            log.error(RESPONSE_BODY_ERROR_MESSAGE, (Throwable)e);
            return EMPTY_BODY;
        }
    }

    private void logRequest(HttpRequest httpRequest, byte[] body) {
        if (this.tracerProperties.isDetailedTracingEnabled()) {
            log.info(REQUEST_MESSAGE_WITH_BODY, new Object[]{httpRequest.getURI(), httpRequest.getMethod().name(), this.getBody(body)});
        } else {
            log.info(REQUEST_MESSAGE, (Object)httpRequest.getURI(), (Object)httpRequest.getMethod().name());
        }
    }

    private String getBody(byte[] body) {
        return body == null ? EMPTY_BODY : new String(body);
    }
}

