/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.http;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.egov.tracer.http.MultiReadableRequestWrapper;
import org.egov.tracer.model.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrelationIdFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CorrelationIdFilter.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        RequestContext.clear();
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        MultiReadableRequestWrapper wrappedRequest = new MultiReadableRequestWrapper(httpRequest);
        this.setCorrelationId((HttpServletRequest)wrappedRequest);
        filterChain.doFilter((ServletRequest)wrappedRequest, servletResponse);
    }

    private void setCorrelationId(HttpServletRequest httpRequest) throws IOException {
        String correlationIdFromRequest;
        if ("GET".equals(httpRequest.getMethod())) {
            RequestContext.setId(this.getRandomCorrelationId());
        }
        if ((correlationIdFromRequest = this.getCorrelationIdFromRequest(httpRequest)) == null) {
            RequestContext.setId(this.getRandomCorrelationId());
        } else {
            RequestContext.setId(correlationIdFromRequest);
        }
    }

    private String getCorrelationIdFromRequest(HttpServletRequest httpRequest) throws IOException {
        try {
            HashMap hashMap = (HashMap)this.objectMapper.readValue((InputStream)httpRequest.getInputStream(), HashMap.class);
            HashMap<String, Object> requestInfo = this.getRequestInfo(hashMap);
            if (requestInfo != null) {
                return (String)requestInfo.get("correlationId");
            }
        }
        catch (JsonParseException | JsonMappingException e) {
            log.error("Failed to deserialize body", e);
            return null;
        }
        return null;
    }

    private HashMap<String, Object> getRequestInfo(HashMap hashMap) {
        Object requestInfo1 = hashMap.get("RequestInfo");
        if (requestInfo1 == null) {
            Object requestInfo2 = hashMap.get("requestInfo");
            return (HashMap)requestInfo2;
        }
        return (HashMap)requestInfo1;
    }

    public void destroy() {
    }

    private String getRandomCorrelationId() {
        return UUID.randomUUID().toString();
    }
}

