/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.config;

import javax.servlet.Filter;
import org.egov.tracer.config.LoggingListenerFactory;
import org.egov.tracer.config.TracerProperties;
import org.egov.tracer.http.CorrelationIdFilter;
import org.egov.tracer.http.LogAwareRestTemplate;
import org.egov.tracer.http.UnhandledExceptionControllerAdvice;
import org.egov.tracer.kafka.KafkaListenerLoggingAspect;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.env.Environment;

@Configuration
@EnableAspectJAutoProxy
@ComponentScan(basePackages={"org.egov.tracer"})
public class TracerConfiguration {
    @Bean
    public TracerProperties tracerProperties(Environment environment) {
        return new TracerProperties(environment);
    }

    @Bean
    public KafkaListenerLoggingAspect kafkaListenerLoggingAspect(TracerProperties tracerProperties) {
        return new KafkaListenerLoggingAspect(tracerProperties);
    }

    @Bean
    public LoggingListenerFactory loggingListenerFactory(TracerProperties tracerProperties) {
        return new LoggingListenerFactory(tracerProperties);
    }

    @Bean(name={"logAwareRestTemplate"})
    public LogAwareRestTemplate logAwareRestTemplate(TracerProperties tracerProperties) {
        return new LogAwareRestTemplate(tracerProperties);
    }

    @Bean
    public UnhandledExceptionControllerAdvice unhandledExceptionControllerAdvice() {
        return new UnhandledExceptionControllerAdvice();
    }

    @Bean
    public FilterRegistrationBean someFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new CorrelationIdFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("correlationIdFilter");
        registration.setOrder(1);
        return registration;
    }
}

