/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.egov.tracer.config.TracerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.util.ObjectUtils;

public class LogAwareProducerListener<K, V>
implements ProducerListener<K, V> {
    private static final Logger log = LoggerFactory.getLogger(LogAwareProducerListener.class);
    private static final String EMPTY_BODY = "<EMPTY BODY>";
    private final ObjectMapper objectMapper;
    private static final String SEND_SUCCESS_MESSAGE = "Sending of message to topic: {}, partition: {} with key: {} succeeded.";
    private static final String BODY_JSON_SERIALIZATION_ERROR = "Serialization of body failed";
    private static final String SEND_SUCCESS_MESSAGE_WITH_BODY = "Sending of message to topic: {}, partition: {}, body: {} with key: {} succeeded.";
    private static final String SEND_FAILURE_MESSAGE = "Sending of message to topic: %s, partition: %s with key: %s failed.";
    private static final String SEND_FAILURE_MESSAGE_WITH_BODY = "Sending of message to topic: %s, partition: %s, body: %s with key: %s failed.";
    private boolean isCustomTracingEnabled;

    public LogAwareProducerListener(TracerProperties tracerProperties) {
        this.isCustomTracingEnabled = tracerProperties.isDetailedTracingEnabled();
        this.objectMapper = new ObjectMapper();
    }

    public void onSuccess(String topic, Integer partition, K key, V value, RecordMetadata recordMetadata) {
        String keyAsString = ObjectUtils.nullSafeToString(key);
        if (this.isCustomTracingEnabled) {
            String bodyAsJsonString = this.getMessageBodyAsJsonString(value);
            log.info(SEND_SUCCESS_MESSAGE_WITH_BODY, new Object[]{topic, partition, bodyAsJsonString, keyAsString});
        } else {
            log.info(SEND_SUCCESS_MESSAGE, new Object[]{topic, partition, keyAsString});
        }
    }

    public void onError(String topic, Integer partition, K key, V value, Exception exception) {
        String keyAsString = ObjectUtils.nullSafeToString(key);
        if (this.isCustomTracingEnabled) {
            String bodyAsJsonString = this.getMessageBodyAsJsonString(value);
            String message = String.format(SEND_FAILURE_MESSAGE_WITH_BODY, topic, partition, bodyAsJsonString, keyAsString);
            log.error(message, (Throwable)exception);
        } else {
            String message = String.format(SEND_FAILURE_MESSAGE, topic, partition, keyAsString);
            log.error(message, (Throwable)exception);
        }
    }

    public boolean isInterestedInSuccess() {
        return true;
    }

    private String getMessageBodyAsJsonString(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            log.error(BODY_JSON_SERIALIZATION_ERROR);
            return EMPTY_BODY;
        }
    }
}

