/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.http;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.tracer.model.RequestContext;
import org.slf4j.MDC;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class CorrelationIdInterceptor
extends HandlerInterceptorAdapter {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String correlationId = this.getCorrelationId(request);
        MDC.put((String)RequestContext.CORRELATION_ID, (String)correlationId);
        RequestContext.setId(correlationId);
        return super.preHandle(request, response, handler);
    }

    private String getCorrelationId(HttpServletRequest request) {
        String incomingCorrelationId = request.getHeader(RequestContext.CORRELATION_ID);
        return incomingCorrelationId == null ? UUID.randomUUID().toString() : incomingCorrelationId;
    }
}

