/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.http.client.ClientHttpResponse;

public class CacheableSimpleClientHttpResponse
extends AbstractClientHttpResponse {
    private ClientHttpResponse clientHttpResponse;
    private String cachedInput;

    public CacheableSimpleClientHttpResponse(ClientHttpResponse clientHttpResponse) {
        this.clientHttpResponse = clientHttpResponse;
    }

    public int getRawStatusCode() throws IOException {
        return this.clientHttpResponse.getRawStatusCode();
    }

    public String getStatusText() throws IOException {
        return this.clientHttpResponse.getStatusText();
    }

    public void close() {
        this.clientHttpResponse.close();
    }

    public InputStream getBody() throws IOException {
        if (this.cachedInput != null) {
            return new ByteArrayInputStream(this.cachedInput.getBytes(StandardCharsets.UTF_8));
        }
        this.cachedInput = new String(IOUtils.toByteArray((InputStream)this.clientHttpResponse.getBody()));
        return new ByteArrayInputStream(this.cachedInput.getBytes(StandardCharsets.UTF_8));
    }

    public HttpHeaders getHeaders() {
        return this.clientHttpResponse.getHeaders();
    }
}

