/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.commons.web.contract;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.egov.tl.commons.web.contract.AuditDetails;
import org.egov.tl.commons.web.contract.LicenseApplicationContract;
import org.egov.tl.commons.web.contract.LicenseFeeDetailContract;
import org.egov.tl.commons.web.contract.SupportDocumentContract;
import org.egov.tl.commons.web.contract.TradePartnerContract;
import org.egov.tl.commons.web.contract.TradeShiftContract;
import org.egov.tl.commons.web.contract.enums.ApplicationTypeEnum;
import org.egov.tl.commons.web.contract.enums.BusinessNatureEnum;
import org.egov.tl.commons.web.contract.enums.EstablishmentTypeEnum;
import org.egov.tl.commons.web.contract.enums.Gender;
import org.egov.tl.commons.web.contract.enums.OwnerShipTypeEnum;
import org.egov.tl.commons.web.contract.enums.OwnerTypeEnum;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TradeLicenseContract {
    private Long id;
    @JsonProperty(value="tenantId")
    @Pattern(regexp=".*[^ ].*", message="{error.license.tenantId.emptyspaces}")
    @NotEmpty(message="{error.license.tenantId.empty}")
    @Length(min=4, max=128, message="{error.license.tenantId.empty}")
    private String tenantId;
    private ApplicationTypeEnum applicationType;
    @Length(min=4, max=20, message="{error.license.applicationnumber}")
    @JsonProperty(value="applicationNumber")
    private String applicationNumber;
    @JsonProperty(value="oldLicenseNumber")
    @Pattern(regexp=".*[^ ].*", message="{error.oldLicenseNumber.emptyspaces}")
    @Length(min=1, max=20, message="{error.oldLicenseNumber.empty}")
    private String oldLicenseNumber;
    @Length(min=4, max=20, message="{error.license.licensenumber}")
    @JsonProperty(value="licenseNumber")
    private String licenseNumber;
    @JsonProperty(value="applicationDate")
    private Long applicationDate;
    @JsonProperty(value="ownerAadhaarNumber")
    @Pattern(regexp="[0-9]{12}", message="{error.license.owneraadhaarnumber}")
    @Length(min=12, max=12, message="{error.license.owneraadhaarnumber}")
    private String ownerAadhaarNumber;
    @NotEmpty(message="{error.license.mobilenumber}")
    @JsonProperty(value="ownerMobileNumber")
    @Length(min=10, max=10, message="{error.license.ownermobilenumber}")
    @Pattern(regexp="[0-9]{10}", message="{error.license.ownermobilenumber}")
    private String ownerMobileNumber;
    @NotEmpty(message="{error.license.ownername}")
    @Pattern(regexp=".*[^ ].*", message="{error.license.ownername}")
    @Length(min=3, max=100, message="{error.license.ownername}")
    @JsonProperty(value="ownerName")
    private String ownerName;
    @NotNull(message="{error.license.ownertype}")
    @JsonProperty(value="ownerType")
    private OwnerTypeEnum ownerType;
    @NotNull(message="{error.license.ownerGenderempty}")
    @JsonProperty(value="ownerGender")
    private Gender ownerGender;
    @Length(min=4, max=4, message="{error.license.ownerbirthyear}")
    @JsonProperty(value="ownerBirthYear")
    private String ownerBirthYear;
    @Length(min=3, max=250, message="{error.license.ownercorrespondenceaddress}")
    @JsonProperty(value="ownerCorrAddress")
    private String ownerCorrAddress;
    @Length(min=3, max=50, message="{error.license.ownercity}")
    @JsonProperty(value="ownerCity")
    private String ownerCity;
    @Length(min=6, max=6, message="{error.license.ownerpincode}")
    @JsonProperty(value="ownerPinCode")
    private String ownerPinCode;
    @NotEmpty(message="{error.license.owneremailid}")
    @Length(min=6, max=50, message="{error.license.owneremailid}")
    @Email(message="{error.license.owneremailid}")
    @JsonProperty(value="ownerEmailId")
    private String ownerEmailId;
    @Length(min=10, max=10, message="{error.license.ownerphonenumber}")
    @JsonProperty(value="ownerPhoneNumber")
    private String ownerPhoneNumber;
    @JsonProperty(value="ownerPhoto")
    private String ownerPhoto;
    @NotEmpty(message="{error.license.fatherspousename}")
    @Pattern(regexp=".*[^ ].*", message="{error.license.fatherspousename.empty}")
    @Length(min=3, max=100, message="{error.license.fatherspousename}")
    @JsonProperty(value="fatherSpouseName")
    private String fatherSpouseName;
    @NotEmpty(message="{error.license.owneraddress.empty}")
    @Pattern(regexp=".*[^ ].*", message="{error.license.owneraddress.emptyspaces}")
    @Length(min=3, max=250, message="{error.license.owneraddress}")
    @JsonProperty(value="ownerAddress")
    private String ownerAddress;
    @JsonProperty(value="establishmentType")
    private EstablishmentTypeEnum establishmentType;
    @NotEmpty(message="{error.license.establishmentname.empty}")
    @Pattern(regexp=".*[^ ].*", message="{error.license.establishmentname.emptyspaces}")
    @Length(min=3, max=100, message="{error.license.establishmentname}")
    @JsonProperty(value="establishmentName")
    private String establishmentName;
    @NotEmpty(message="{error.license.establishmentregno.empty}")
    @Pattern(regexp=".*[^ ].*", message="{error.license.establishmentregno.emptyspace}")
    @Length(min=3, max=100, message="{error.license.establishmentregno}")
    @JsonProperty(value="establishmentRegNo")
    private String establishmentRegNo;
    @NotEmpty(message="{error.license.establishmentscorrespondenceaddress.empty}")
    @Length(min=3, max=250, message="{error.license.establishmentscorrespondenceaddress}")
    @Pattern(regexp=".*[^ ].*", message="{error.license.establishmentscorrespondenceaddress.emptyspace}")
    @JsonProperty(value="establishmentCorrAddress")
    private String establishmentCorrAddress;
    @Length(min=3, max=50, message="{error.license.establishmentcity}")
    @JsonProperty(value="establishmentCity")
    private String establishmentCity;
    @NotEmpty(message="{error.license.establishmentpincode.empty}")
    @Length(min=6, max=6, message="{error.license.establishmentpincode}")
    @Pattern(regexp=".*[^ ].*", message="{error.license.establishmentpincode.emptyspace}")
    @JsonProperty(value="establishmentPinCode")
    private String establishmentPinCode;
    @NotEmpty(message="{error.license.establishmentphonenumber.empty}")
    @Length(min=10, max=10, message="{error.license.establishmentphonenumber}")
    @Pattern(regexp=".*[^ ].*", message="{error.license.establishmentphonenumber.emptyspace}")
    @JsonProperty(value="establishmentPhoneNo")
    private String establishmentPhoneNo;
    @NotEmpty(message="{error.license.establishmentmobilenumber.empty}")
    @Length(min=10, max=10, message="{error.license.establishmentmobilenumber}")
    @Pattern(regexp=".*[^ ].*", message="{error.license.establishmentmobilenumber.emptyspace}")
    @JsonProperty(value="establishmentMobNo")
    private String establishmentMobNo;
    @NotEmpty(message="{error.license.establishmentemailid.empty}")
    @Length(min=6, max=50, message="{error.license.establishmentemailid}")
    @Pattern(regexp=".*[^ ].*", message="{error.license.establishmentemailid.emptyspace}")
    @JsonProperty(value="establishmentEmailId")
    private String establishmentEmailId;
    @JsonProperty(value="surveyOrGatNo")
    private String surveyOrGatNo;
    @JsonProperty(value="ctsOrFinalPlotNo")
    private String ctsOrFinalPlotNo;
    @JsonProperty(value="plotNo")
    private String plotNo;
    @JsonProperty(value="waterConnectionNo")
    private String waterConnectionNo;
    @Length(min=3, max=100, message="{error.license.landownername}")
    @JsonProperty(value="landOwnerName")
    private String landOwnerName;
    @JsonProperty(value="isConsentLetterTaken")
    private Boolean isConsentLetterTaken;
    @NotEmpty(message="{error.license.businessdescription.empty}")
    @JsonProperty(value="businessDescription")
    private String businessDescription;
    @JsonProperty(value="prevLicenseNo")
    private String prevLicenseNo;
    @JsonProperty(value="prevLicenseDate")
    private Long prevLicenseDate;
    @NotNull(message="{error.license.totalEmployees.empty}")
    @JsonProperty(value="totalEmployees")
    private Integer totalEmployees;
    @JsonProperty(value="totalMachines")
    private Integer totalMachines;
    @NotNull(message="{error.license.LRBFSP.empty}")
    @JsonProperty(value="licenseRejBefrForSamePremise")
    private Boolean licenseRejBefrForSamePremise;
    @JsonProperty(value="explLicenseNo")
    private String explLicenseNo;
    @JsonProperty(value="totalShifts")
    private Integer totalShifts;
    @Length(min=4, max=20, message="{error.license.propertyassesmentno}")
    @JsonProperty(value="propertyAssesmentNo")
    private String propertyAssesmentNo;
    @JsonProperty(value="locality")
    private String locality;
    @NotEmpty(message="{error.license.adminward}")
    @JsonProperty(value="adminWard")
    private String adminWard;
    @NotEmpty(message="{error.license.revenueward}")
    @JsonProperty(value="revenueWard")
    private String revenueWard;
    @NotEmpty(message="{error.license.tradeaddress}")
    @Pattern(regexp=".*[^ ].*", message="{error.license.tradeaddress}")
    @JsonProperty(value="tradeAddress")
    @Length(min=3, max=250, message="{error.license.tradeaddress}")
    private String tradeAddress;
    @NotNull(message="{error.license.ownershiptype}")
    @JsonProperty(value="ownerShipType")
    private OwnerShipTypeEnum ownerShipType;
    @NotNull(message="{error.license.tradetype}")
    @JsonProperty(value="tradeType")
    private BusinessNatureEnum tradeType;
    @NotEmpty(message="{error.license.tradetitle}")
    @Pattern(regexp=".*[^ ].*", message="{error.license.tradetitle.emptyspaces}")
    @JsonProperty(value="tradeTitle")
    @Length(min=3, max=250, message="{error.license.tradetitle}")
    private String tradeTitle;
    @NotNull(message="{error.license.category}")
    @JsonProperty(value="category")
    private String category;
    @NotNull(message="{error.license.subcategory}")
    @JsonProperty(value="subCategory")
    private String subCategory;
    @NotNull(message="{error.license.uom}")
    @JsonProperty(value="uom")
    private String uom;
    @NotNull(message="{error.license.quantity}")
    @Digits(integer=10, fraction=2, message="{error.license.quantity}")
    @JsonProperty(value="quantity")
    private Double quantity;
    @NotNull(message="{error.license.validityyears}")
    @Min(value=1L)
    @Max(value=10L)
    @JsonProperty(value="validityYears")
    private Long validityYears;
    @JsonProperty(value="remarks")
    @Length(max=250, message="{error.license.remarks}")
    private String remarks;
    @NotNull(message="{error.license.tradecommencementdate}")
    @JsonProperty(value="tradeCommencementDate")
    private Long tradeCommencementDate;
    @JsonProperty(value="licenseValidFromDate")
    private Long licenseValidFromDate;
    @JsonProperty(value="issuedDate")
    private Long issuedDate;
    @JsonProperty(value="agreementDate")
    private Long agreementDate;
    @JsonProperty(value="agreementNo")
    private String agreementNo;
    @JsonProperty(value="isLegacy")
    @NotNull(message="{error.license.islegacy}")
    private Boolean isLegacy = false;
    @JsonProperty(value="isPropertyOwner")
    @NotNull(message="{error.license.ispropertyowner}")
    private Boolean isPropertyOwner = false;
    @JsonProperty(value="active")
    @NotNull(message="{error.license.active}")
    private Boolean active = true;
    @JsonProperty(value="expiryDate")
    private Long expiryDate;
    @JsonProperty(value="userId")
    private Long userId;
    @JsonProperty(value="isDataPorting")
    private Boolean isDataPorting = false;
    @JsonProperty(value="status")
    private String status;
    private String billId;
    @JsonProperty(value="application")
    private LicenseApplicationContract application;
    @JsonProperty(value="feeDetails")
    @Valid
    private List<LicenseFeeDetailContract> feeDetails;
    @JsonProperty(value="supportDocuments")
    @Valid
    private List<SupportDocumentContract> supportDocuments;
    @JsonProperty(value="partners")
    @Valid
    private List<TradePartnerContract> partners;
    @JsonProperty(value="shifts")
    @Valid
    private List<TradeShiftContract> shifts;
    @JsonIgnore
    @JsonProperty(value="licenseData")
    private Map<String, Object> licenseData;
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails;

    public static TradeLicenseContractBuilder builder() {
        return new TradeLicenseContractBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TradeLicenseContract)) {
            return false;
        }
        TradeLicenseContract other = (TradeLicenseContract)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        ApplicationTypeEnum this$applicationType = this.getApplicationType();
        ApplicationTypeEnum other$applicationType = other.getApplicationType();
        if (this$applicationType == null ? other$applicationType != null : !((Object)((Object)this$applicationType)).equals((Object)other$applicationType)) {
            return false;
        }
        String this$applicationNumber = this.getApplicationNumber();
        String other$applicationNumber = other.getApplicationNumber();
        if (this$applicationNumber == null ? other$applicationNumber != null : !this$applicationNumber.equals(other$applicationNumber)) {
            return false;
        }
        String this$oldLicenseNumber = this.getOldLicenseNumber();
        String other$oldLicenseNumber = other.getOldLicenseNumber();
        if (this$oldLicenseNumber == null ? other$oldLicenseNumber != null : !this$oldLicenseNumber.equals(other$oldLicenseNumber)) {
            return false;
        }
        String this$licenseNumber = this.getLicenseNumber();
        String other$licenseNumber = other.getLicenseNumber();
        if (this$licenseNumber == null ? other$licenseNumber != null : !this$licenseNumber.equals(other$licenseNumber)) {
            return false;
        }
        Long this$applicationDate = this.getApplicationDate();
        Long other$applicationDate = other.getApplicationDate();
        if (this$applicationDate == null ? other$applicationDate != null : !((Object)this$applicationDate).equals(other$applicationDate)) {
            return false;
        }
        String this$ownerAadhaarNumber = this.getOwnerAadhaarNumber();
        String other$ownerAadhaarNumber = other.getOwnerAadhaarNumber();
        if (this$ownerAadhaarNumber == null ? other$ownerAadhaarNumber != null : !this$ownerAadhaarNumber.equals(other$ownerAadhaarNumber)) {
            return false;
        }
        String this$ownerMobileNumber = this.getOwnerMobileNumber();
        String other$ownerMobileNumber = other.getOwnerMobileNumber();
        if (this$ownerMobileNumber == null ? other$ownerMobileNumber != null : !this$ownerMobileNumber.equals(other$ownerMobileNumber)) {
            return false;
        }
        String this$ownerName = this.getOwnerName();
        String other$ownerName = other.getOwnerName();
        if (this$ownerName == null ? other$ownerName != null : !this$ownerName.equals(other$ownerName)) {
            return false;
        }
        OwnerTypeEnum this$ownerType = this.getOwnerType();
        OwnerTypeEnum other$ownerType = other.getOwnerType();
        if (this$ownerType == null ? other$ownerType != null : !((Object)((Object)this$ownerType)).equals((Object)other$ownerType)) {
            return false;
        }
        Gender this$ownerGender = this.getOwnerGender();
        Gender other$ownerGender = other.getOwnerGender();
        if (this$ownerGender == null ? other$ownerGender != null : !((Object)((Object)this$ownerGender)).equals((Object)other$ownerGender)) {
            return false;
        }
        String this$ownerBirthYear = this.getOwnerBirthYear();
        String other$ownerBirthYear = other.getOwnerBirthYear();
        if (this$ownerBirthYear == null ? other$ownerBirthYear != null : !this$ownerBirthYear.equals(other$ownerBirthYear)) {
            return false;
        }
        String this$ownerCorrAddress = this.getOwnerCorrAddress();
        String other$ownerCorrAddress = other.getOwnerCorrAddress();
        if (this$ownerCorrAddress == null ? other$ownerCorrAddress != null : !this$ownerCorrAddress.equals(other$ownerCorrAddress)) {
            return false;
        }
        String this$ownerCity = this.getOwnerCity();
        String other$ownerCity = other.getOwnerCity();
        if (this$ownerCity == null ? other$ownerCity != null : !this$ownerCity.equals(other$ownerCity)) {
            return false;
        }
        String this$ownerPinCode = this.getOwnerPinCode();
        String other$ownerPinCode = other.getOwnerPinCode();
        if (this$ownerPinCode == null ? other$ownerPinCode != null : !this$ownerPinCode.equals(other$ownerPinCode)) {
            return false;
        }
        String this$ownerEmailId = this.getOwnerEmailId();
        String other$ownerEmailId = other.getOwnerEmailId();
        if (this$ownerEmailId == null ? other$ownerEmailId != null : !this$ownerEmailId.equals(other$ownerEmailId)) {
            return false;
        }
        String this$ownerPhoneNumber = this.getOwnerPhoneNumber();
        String other$ownerPhoneNumber = other.getOwnerPhoneNumber();
        if (this$ownerPhoneNumber == null ? other$ownerPhoneNumber != null : !this$ownerPhoneNumber.equals(other$ownerPhoneNumber)) {
            return false;
        }
        String this$ownerPhoto = this.getOwnerPhoto();
        String other$ownerPhoto = other.getOwnerPhoto();
        if (this$ownerPhoto == null ? other$ownerPhoto != null : !this$ownerPhoto.equals(other$ownerPhoto)) {
            return false;
        }
        String this$fatherSpouseName = this.getFatherSpouseName();
        String other$fatherSpouseName = other.getFatherSpouseName();
        if (this$fatherSpouseName == null ? other$fatherSpouseName != null : !this$fatherSpouseName.equals(other$fatherSpouseName)) {
            return false;
        }
        String this$ownerAddress = this.getOwnerAddress();
        String other$ownerAddress = other.getOwnerAddress();
        if (this$ownerAddress == null ? other$ownerAddress != null : !this$ownerAddress.equals(other$ownerAddress)) {
            return false;
        }
        EstablishmentTypeEnum this$establishmentType = this.getEstablishmentType();
        EstablishmentTypeEnum other$establishmentType = other.getEstablishmentType();
        if (this$establishmentType == null ? other$establishmentType != null : !((Object)((Object)this$establishmentType)).equals((Object)other$establishmentType)) {
            return false;
        }
        String this$establishmentName = this.getEstablishmentName();
        String other$establishmentName = other.getEstablishmentName();
        if (this$establishmentName == null ? other$establishmentName != null : !this$establishmentName.equals(other$establishmentName)) {
            return false;
        }
        String this$establishmentRegNo = this.getEstablishmentRegNo();
        String other$establishmentRegNo = other.getEstablishmentRegNo();
        if (this$establishmentRegNo == null ? other$establishmentRegNo != null : !this$establishmentRegNo.equals(other$establishmentRegNo)) {
            return false;
        }
        String this$establishmentCorrAddress = this.getEstablishmentCorrAddress();
        String other$establishmentCorrAddress = other.getEstablishmentCorrAddress();
        if (this$establishmentCorrAddress == null ? other$establishmentCorrAddress != null : !this$establishmentCorrAddress.equals(other$establishmentCorrAddress)) {
            return false;
        }
        String this$establishmentCity = this.getEstablishmentCity();
        String other$establishmentCity = other.getEstablishmentCity();
        if (this$establishmentCity == null ? other$establishmentCity != null : !this$establishmentCity.equals(other$establishmentCity)) {
            return false;
        }
        String this$establishmentPinCode = this.getEstablishmentPinCode();
        String other$establishmentPinCode = other.getEstablishmentPinCode();
        if (this$establishmentPinCode == null ? other$establishmentPinCode != null : !this$establishmentPinCode.equals(other$establishmentPinCode)) {
            return false;
        }
        String this$establishmentPhoneNo = this.getEstablishmentPhoneNo();
        String other$establishmentPhoneNo = other.getEstablishmentPhoneNo();
        if (this$establishmentPhoneNo == null ? other$establishmentPhoneNo != null : !this$establishmentPhoneNo.equals(other$establishmentPhoneNo)) {
            return false;
        }
        String this$establishmentMobNo = this.getEstablishmentMobNo();
        String other$establishmentMobNo = other.getEstablishmentMobNo();
        if (this$establishmentMobNo == null ? other$establishmentMobNo != null : !this$establishmentMobNo.equals(other$establishmentMobNo)) {
            return false;
        }
        String this$establishmentEmailId = this.getEstablishmentEmailId();
        String other$establishmentEmailId = other.getEstablishmentEmailId();
        if (this$establishmentEmailId == null ? other$establishmentEmailId != null : !this$establishmentEmailId.equals(other$establishmentEmailId)) {
            return false;
        }
        String this$surveyOrGatNo = this.getSurveyOrGatNo();
        String other$surveyOrGatNo = other.getSurveyOrGatNo();
        if (this$surveyOrGatNo == null ? other$surveyOrGatNo != null : !this$surveyOrGatNo.equals(other$surveyOrGatNo)) {
            return false;
        }
        String this$ctsOrFinalPlotNo = this.getCtsOrFinalPlotNo();
        String other$ctsOrFinalPlotNo = other.getCtsOrFinalPlotNo();
        if (this$ctsOrFinalPlotNo == null ? other$ctsOrFinalPlotNo != null : !this$ctsOrFinalPlotNo.equals(other$ctsOrFinalPlotNo)) {
            return false;
        }
        String this$plotNo = this.getPlotNo();
        String other$plotNo = other.getPlotNo();
        if (this$plotNo == null ? other$plotNo != null : !this$plotNo.equals(other$plotNo)) {
            return false;
        }
        String this$waterConnectionNo = this.getWaterConnectionNo();
        String other$waterConnectionNo = other.getWaterConnectionNo();
        if (this$waterConnectionNo == null ? other$waterConnectionNo != null : !this$waterConnectionNo.equals(other$waterConnectionNo)) {
            return false;
        }
        String this$landOwnerName = this.getLandOwnerName();
        String other$landOwnerName = other.getLandOwnerName();
        if (this$landOwnerName == null ? other$landOwnerName != null : !this$landOwnerName.equals(other$landOwnerName)) {
            return false;
        }
        Boolean this$isConsentLetterTaken = this.getIsConsentLetterTaken();
        Boolean other$isConsentLetterTaken = other.getIsConsentLetterTaken();
        if (this$isConsentLetterTaken == null ? other$isConsentLetterTaken != null : !((Object)this$isConsentLetterTaken).equals(other$isConsentLetterTaken)) {
            return false;
        }
        String this$businessDescription = this.getBusinessDescription();
        String other$businessDescription = other.getBusinessDescription();
        if (this$businessDescription == null ? other$businessDescription != null : !this$businessDescription.equals(other$businessDescription)) {
            return false;
        }
        String this$prevLicenseNo = this.getPrevLicenseNo();
        String other$prevLicenseNo = other.getPrevLicenseNo();
        if (this$prevLicenseNo == null ? other$prevLicenseNo != null : !this$prevLicenseNo.equals(other$prevLicenseNo)) {
            return false;
        }
        Long this$prevLicenseDate = this.getPrevLicenseDate();
        Long other$prevLicenseDate = other.getPrevLicenseDate();
        if (this$prevLicenseDate == null ? other$prevLicenseDate != null : !((Object)this$prevLicenseDate).equals(other$prevLicenseDate)) {
            return false;
        }
        Integer this$totalEmployees = this.getTotalEmployees();
        Integer other$totalEmployees = other.getTotalEmployees();
        if (this$totalEmployees == null ? other$totalEmployees != null : !((Object)this$totalEmployees).equals(other$totalEmployees)) {
            return false;
        }
        Integer this$totalMachines = this.getTotalMachines();
        Integer other$totalMachines = other.getTotalMachines();
        if (this$totalMachines == null ? other$totalMachines != null : !((Object)this$totalMachines).equals(other$totalMachines)) {
            return false;
        }
        Boolean this$licenseRejBefrForSamePremise = this.getLicenseRejBefrForSamePremise();
        Boolean other$licenseRejBefrForSamePremise = other.getLicenseRejBefrForSamePremise();
        if (this$licenseRejBefrForSamePremise == null ? other$licenseRejBefrForSamePremise != null : !((Object)this$licenseRejBefrForSamePremise).equals(other$licenseRejBefrForSamePremise)) {
            return false;
        }
        String this$explLicenseNo = this.getExplLicenseNo();
        String other$explLicenseNo = other.getExplLicenseNo();
        if (this$explLicenseNo == null ? other$explLicenseNo != null : !this$explLicenseNo.equals(other$explLicenseNo)) {
            return false;
        }
        Integer this$totalShifts = this.getTotalShifts();
        Integer other$totalShifts = other.getTotalShifts();
        if (this$totalShifts == null ? other$totalShifts != null : !((Object)this$totalShifts).equals(other$totalShifts)) {
            return false;
        }
        String this$propertyAssesmentNo = this.getPropertyAssesmentNo();
        String other$propertyAssesmentNo = other.getPropertyAssesmentNo();
        if (this$propertyAssesmentNo == null ? other$propertyAssesmentNo != null : !this$propertyAssesmentNo.equals(other$propertyAssesmentNo)) {
            return false;
        }
        String this$locality = this.getLocality();
        String other$locality = other.getLocality();
        if (this$locality == null ? other$locality != null : !this$locality.equals(other$locality)) {
            return false;
        }
        String this$adminWard = this.getAdminWard();
        String other$adminWard = other.getAdminWard();
        if (this$adminWard == null ? other$adminWard != null : !this$adminWard.equals(other$adminWard)) {
            return false;
        }
        String this$revenueWard = this.getRevenueWard();
        String other$revenueWard = other.getRevenueWard();
        if (this$revenueWard == null ? other$revenueWard != null : !this$revenueWard.equals(other$revenueWard)) {
            return false;
        }
        String this$tradeAddress = this.getTradeAddress();
        String other$tradeAddress = other.getTradeAddress();
        if (this$tradeAddress == null ? other$tradeAddress != null : !this$tradeAddress.equals(other$tradeAddress)) {
            return false;
        }
        OwnerShipTypeEnum this$ownerShipType = this.getOwnerShipType();
        OwnerShipTypeEnum other$ownerShipType = other.getOwnerShipType();
        if (this$ownerShipType == null ? other$ownerShipType != null : !((Object)((Object)this$ownerShipType)).equals((Object)other$ownerShipType)) {
            return false;
        }
        BusinessNatureEnum this$tradeType = this.getTradeType();
        BusinessNatureEnum other$tradeType = other.getTradeType();
        if (this$tradeType == null ? other$tradeType != null : !((Object)((Object)this$tradeType)).equals((Object)other$tradeType)) {
            return false;
        }
        String this$tradeTitle = this.getTradeTitle();
        String other$tradeTitle = other.getTradeTitle();
        if (this$tradeTitle == null ? other$tradeTitle != null : !this$tradeTitle.equals(other$tradeTitle)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$subCategory = this.getSubCategory();
        String other$subCategory = other.getSubCategory();
        if (this$subCategory == null ? other$subCategory != null : !this$subCategory.equals(other$subCategory)) {
            return false;
        }
        String this$uom = this.getUom();
        String other$uom = other.getUom();
        if (this$uom == null ? other$uom != null : !this$uom.equals(other$uom)) {
            return false;
        }
        Double this$quantity = this.getQuantity();
        Double other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        Long this$validityYears = this.getValidityYears();
        Long other$validityYears = other.getValidityYears();
        if (this$validityYears == null ? other$validityYears != null : !((Object)this$validityYears).equals(other$validityYears)) {
            return false;
        }
        String this$remarks = this.getRemarks();
        String other$remarks = other.getRemarks();
        if (this$remarks == null ? other$remarks != null : !this$remarks.equals(other$remarks)) {
            return false;
        }
        Long this$tradeCommencementDate = this.getTradeCommencementDate();
        Long other$tradeCommencementDate = other.getTradeCommencementDate();
        if (this$tradeCommencementDate == null ? other$tradeCommencementDate != null : !((Object)this$tradeCommencementDate).equals(other$tradeCommencementDate)) {
            return false;
        }
        Long this$licenseValidFromDate = this.getLicenseValidFromDate();
        Long other$licenseValidFromDate = other.getLicenseValidFromDate();
        if (this$licenseValidFromDate == null ? other$licenseValidFromDate != null : !((Object)this$licenseValidFromDate).equals(other$licenseValidFromDate)) {
            return false;
        }
        Long this$issuedDate = this.getIssuedDate();
        Long other$issuedDate = other.getIssuedDate();
        if (this$issuedDate == null ? other$issuedDate != null : !((Object)this$issuedDate).equals(other$issuedDate)) {
            return false;
        }
        Long this$agreementDate = this.getAgreementDate();
        Long other$agreementDate = other.getAgreementDate();
        if (this$agreementDate == null ? other$agreementDate != null : !((Object)this$agreementDate).equals(other$agreementDate)) {
            return false;
        }
        String this$agreementNo = this.getAgreementNo();
        String other$agreementNo = other.getAgreementNo();
        if (this$agreementNo == null ? other$agreementNo != null : !this$agreementNo.equals(other$agreementNo)) {
            return false;
        }
        Boolean this$isLegacy = this.getIsLegacy();
        Boolean other$isLegacy = other.getIsLegacy();
        if (this$isLegacy == null ? other$isLegacy != null : !((Object)this$isLegacy).equals(other$isLegacy)) {
            return false;
        }
        Boolean this$isPropertyOwner = this.getIsPropertyOwner();
        Boolean other$isPropertyOwner = other.getIsPropertyOwner();
        if (this$isPropertyOwner == null ? other$isPropertyOwner != null : !((Object)this$isPropertyOwner).equals(other$isPropertyOwner)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Long this$expiryDate = this.getExpiryDate();
        Long other$expiryDate = other.getExpiryDate();
        if (this$expiryDate == null ? other$expiryDate != null : !((Object)this$expiryDate).equals(other$expiryDate)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Boolean this$isDataPorting = this.getIsDataPorting();
        Boolean other$isDataPorting = other.getIsDataPorting();
        if (this$isDataPorting == null ? other$isDataPorting != null : !((Object)this$isDataPorting).equals(other$isDataPorting)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$billId = this.getBillId();
        String other$billId = other.getBillId();
        if (this$billId == null ? other$billId != null : !this$billId.equals(other$billId)) {
            return false;
        }
        LicenseApplicationContract this$application = this.getApplication();
        LicenseApplicationContract other$application = other.getApplication();
        if (this$application == null ? other$application != null : !((Object)this$application).equals(other$application)) {
            return false;
        }
        List<LicenseFeeDetailContract> this$feeDetails = this.getFeeDetails();
        List<LicenseFeeDetailContract> other$feeDetails = other.getFeeDetails();
        if (this$feeDetails == null ? other$feeDetails != null : !((Object)this$feeDetails).equals(other$feeDetails)) {
            return false;
        }
        List<SupportDocumentContract> this$supportDocuments = this.getSupportDocuments();
        List<SupportDocumentContract> other$supportDocuments = other.getSupportDocuments();
        if (this$supportDocuments == null ? other$supportDocuments != null : !((Object)this$supportDocuments).equals(other$supportDocuments)) {
            return false;
        }
        List<TradePartnerContract> this$partners = this.getPartners();
        List<TradePartnerContract> other$partners = other.getPartners();
        if (this$partners == null ? other$partners != null : !((Object)this$partners).equals(other$partners)) {
            return false;
        }
        List<TradeShiftContract> this$shifts = this.getShifts();
        List<TradeShiftContract> other$shifts = other.getShifts();
        if (this$shifts == null ? other$shifts != null : !((Object)this$shifts).equals(other$shifts)) {
            return false;
        }
        Map<String, Object> this$licenseData = this.getLicenseData();
        Map<String, Object> other$licenseData = other.getLicenseData();
        if (this$licenseData == null ? other$licenseData != null : !((Object)this$licenseData).equals(other$licenseData)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        return !(this$auditDetails == null ? other$auditDetails != null : !((Object)this$auditDetails).equals(other$auditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TradeLicenseContract;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        ApplicationTypeEnum $applicationType = this.getApplicationType();
        result = result * 59 + ($applicationType == null ? 43 : ((Object)((Object)$applicationType)).hashCode());
        String $applicationNumber = this.getApplicationNumber();
        result = result * 59 + ($applicationNumber == null ? 43 : $applicationNumber.hashCode());
        String $oldLicenseNumber = this.getOldLicenseNumber();
        result = result * 59 + ($oldLicenseNumber == null ? 43 : $oldLicenseNumber.hashCode());
        String $licenseNumber = this.getLicenseNumber();
        result = result * 59 + ($licenseNumber == null ? 43 : $licenseNumber.hashCode());
        Long $applicationDate = this.getApplicationDate();
        result = result * 59 + ($applicationDate == null ? 43 : ((Object)$applicationDate).hashCode());
        String $ownerAadhaarNumber = this.getOwnerAadhaarNumber();
        result = result * 59 + ($ownerAadhaarNumber == null ? 43 : $ownerAadhaarNumber.hashCode());
        String $ownerMobileNumber = this.getOwnerMobileNumber();
        result = result * 59 + ($ownerMobileNumber == null ? 43 : $ownerMobileNumber.hashCode());
        String $ownerName = this.getOwnerName();
        result = result * 59 + ($ownerName == null ? 43 : $ownerName.hashCode());
        OwnerTypeEnum $ownerType = this.getOwnerType();
        result = result * 59 + ($ownerType == null ? 43 : ((Object)((Object)$ownerType)).hashCode());
        Gender $ownerGender = this.getOwnerGender();
        result = result * 59 + ($ownerGender == null ? 43 : ((Object)((Object)$ownerGender)).hashCode());
        String $ownerBirthYear = this.getOwnerBirthYear();
        result = result * 59 + ($ownerBirthYear == null ? 43 : $ownerBirthYear.hashCode());
        String $ownerCorrAddress = this.getOwnerCorrAddress();
        result = result * 59 + ($ownerCorrAddress == null ? 43 : $ownerCorrAddress.hashCode());
        String $ownerCity = this.getOwnerCity();
        result = result * 59 + ($ownerCity == null ? 43 : $ownerCity.hashCode());
        String $ownerPinCode = this.getOwnerPinCode();
        result = result * 59 + ($ownerPinCode == null ? 43 : $ownerPinCode.hashCode());
        String $ownerEmailId = this.getOwnerEmailId();
        result = result * 59 + ($ownerEmailId == null ? 43 : $ownerEmailId.hashCode());
        String $ownerPhoneNumber = this.getOwnerPhoneNumber();
        result = result * 59 + ($ownerPhoneNumber == null ? 43 : $ownerPhoneNumber.hashCode());
        String $ownerPhoto = this.getOwnerPhoto();
        result = result * 59 + ($ownerPhoto == null ? 43 : $ownerPhoto.hashCode());
        String $fatherSpouseName = this.getFatherSpouseName();
        result = result * 59 + ($fatherSpouseName == null ? 43 : $fatherSpouseName.hashCode());
        String $ownerAddress = this.getOwnerAddress();
        result = result * 59 + ($ownerAddress == null ? 43 : $ownerAddress.hashCode());
        EstablishmentTypeEnum $establishmentType = this.getEstablishmentType();
        result = result * 59 + ($establishmentType == null ? 43 : ((Object)((Object)$establishmentType)).hashCode());
        String $establishmentName = this.getEstablishmentName();
        result = result * 59 + ($establishmentName == null ? 43 : $establishmentName.hashCode());
        String $establishmentRegNo = this.getEstablishmentRegNo();
        result = result * 59 + ($establishmentRegNo == null ? 43 : $establishmentRegNo.hashCode());
        String $establishmentCorrAddress = this.getEstablishmentCorrAddress();
        result = result * 59 + ($establishmentCorrAddress == null ? 43 : $establishmentCorrAddress.hashCode());
        String $establishmentCity = this.getEstablishmentCity();
        result = result * 59 + ($establishmentCity == null ? 43 : $establishmentCity.hashCode());
        String $establishmentPinCode = this.getEstablishmentPinCode();
        result = result * 59 + ($establishmentPinCode == null ? 43 : $establishmentPinCode.hashCode());
        String $establishmentPhoneNo = this.getEstablishmentPhoneNo();
        result = result * 59 + ($establishmentPhoneNo == null ? 43 : $establishmentPhoneNo.hashCode());
        String $establishmentMobNo = this.getEstablishmentMobNo();
        result = result * 59 + ($establishmentMobNo == null ? 43 : $establishmentMobNo.hashCode());
        String $establishmentEmailId = this.getEstablishmentEmailId();
        result = result * 59 + ($establishmentEmailId == null ? 43 : $establishmentEmailId.hashCode());
        String $surveyOrGatNo = this.getSurveyOrGatNo();
        result = result * 59 + ($surveyOrGatNo == null ? 43 : $surveyOrGatNo.hashCode());
        String $ctsOrFinalPlotNo = this.getCtsOrFinalPlotNo();
        result = result * 59 + ($ctsOrFinalPlotNo == null ? 43 : $ctsOrFinalPlotNo.hashCode());
        String $plotNo = this.getPlotNo();
        result = result * 59 + ($plotNo == null ? 43 : $plotNo.hashCode());
        String $waterConnectionNo = this.getWaterConnectionNo();
        result = result * 59 + ($waterConnectionNo == null ? 43 : $waterConnectionNo.hashCode());
        String $landOwnerName = this.getLandOwnerName();
        result = result * 59 + ($landOwnerName == null ? 43 : $landOwnerName.hashCode());
        Boolean $isConsentLetterTaken = this.getIsConsentLetterTaken();
        result = result * 59 + ($isConsentLetterTaken == null ? 43 : ((Object)$isConsentLetterTaken).hashCode());
        String $businessDescription = this.getBusinessDescription();
        result = result * 59 + ($businessDescription == null ? 43 : $businessDescription.hashCode());
        String $prevLicenseNo = this.getPrevLicenseNo();
        result = result * 59 + ($prevLicenseNo == null ? 43 : $prevLicenseNo.hashCode());
        Long $prevLicenseDate = this.getPrevLicenseDate();
        result = result * 59 + ($prevLicenseDate == null ? 43 : ((Object)$prevLicenseDate).hashCode());
        Integer $totalEmployees = this.getTotalEmployees();
        result = result * 59 + ($totalEmployees == null ? 43 : ((Object)$totalEmployees).hashCode());
        Integer $totalMachines = this.getTotalMachines();
        result = result * 59 + ($totalMachines == null ? 43 : ((Object)$totalMachines).hashCode());
        Boolean $licenseRejBefrForSamePremise = this.getLicenseRejBefrForSamePremise();
        result = result * 59 + ($licenseRejBefrForSamePremise == null ? 43 : ((Object)$licenseRejBefrForSamePremise).hashCode());
        String $explLicenseNo = this.getExplLicenseNo();
        result = result * 59 + ($explLicenseNo == null ? 43 : $explLicenseNo.hashCode());
        Integer $totalShifts = this.getTotalShifts();
        result = result * 59 + ($totalShifts == null ? 43 : ((Object)$totalShifts).hashCode());
        String $propertyAssesmentNo = this.getPropertyAssesmentNo();
        result = result * 59 + ($propertyAssesmentNo == null ? 43 : $propertyAssesmentNo.hashCode());
        String $locality = this.getLocality();
        result = result * 59 + ($locality == null ? 43 : $locality.hashCode());
        String $adminWard = this.getAdminWard();
        result = result * 59 + ($adminWard == null ? 43 : $adminWard.hashCode());
        String $revenueWard = this.getRevenueWard();
        result = result * 59 + ($revenueWard == null ? 43 : $revenueWard.hashCode());
        String $tradeAddress = this.getTradeAddress();
        result = result * 59 + ($tradeAddress == null ? 43 : $tradeAddress.hashCode());
        OwnerShipTypeEnum $ownerShipType = this.getOwnerShipType();
        result = result * 59 + ($ownerShipType == null ? 43 : ((Object)((Object)$ownerShipType)).hashCode());
        BusinessNatureEnum $tradeType = this.getTradeType();
        result = result * 59 + ($tradeType == null ? 43 : ((Object)((Object)$tradeType)).hashCode());
        String $tradeTitle = this.getTradeTitle();
        result = result * 59 + ($tradeTitle == null ? 43 : $tradeTitle.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $subCategory = this.getSubCategory();
        result = result * 59 + ($subCategory == null ? 43 : $subCategory.hashCode());
        String $uom = this.getUom();
        result = result * 59 + ($uom == null ? 43 : $uom.hashCode());
        Double $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        Long $validityYears = this.getValidityYears();
        result = result * 59 + ($validityYears == null ? 43 : ((Object)$validityYears).hashCode());
        String $remarks = this.getRemarks();
        result = result * 59 + ($remarks == null ? 43 : $remarks.hashCode());
        Long $tradeCommencementDate = this.getTradeCommencementDate();
        result = result * 59 + ($tradeCommencementDate == null ? 43 : ((Object)$tradeCommencementDate).hashCode());
        Long $licenseValidFromDate = this.getLicenseValidFromDate();
        result = result * 59 + ($licenseValidFromDate == null ? 43 : ((Object)$licenseValidFromDate).hashCode());
        Long $issuedDate = this.getIssuedDate();
        result = result * 59 + ($issuedDate == null ? 43 : ((Object)$issuedDate).hashCode());
        Long $agreementDate = this.getAgreementDate();
        result = result * 59 + ($agreementDate == null ? 43 : ((Object)$agreementDate).hashCode());
        String $agreementNo = this.getAgreementNo();
        result = result * 59 + ($agreementNo == null ? 43 : $agreementNo.hashCode());
        Boolean $isLegacy = this.getIsLegacy();
        result = result * 59 + ($isLegacy == null ? 43 : ((Object)$isLegacy).hashCode());
        Boolean $isPropertyOwner = this.getIsPropertyOwner();
        result = result * 59 + ($isPropertyOwner == null ? 43 : ((Object)$isPropertyOwner).hashCode());
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Long $expiryDate = this.getExpiryDate();
        result = result * 59 + ($expiryDate == null ? 43 : ((Object)$expiryDate).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Boolean $isDataPorting = this.getIsDataPorting();
        result = result * 59 + ($isDataPorting == null ? 43 : ((Object)$isDataPorting).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $billId = this.getBillId();
        result = result * 59 + ($billId == null ? 43 : $billId.hashCode());
        LicenseApplicationContract $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : ((Object)$application).hashCode());
        List<LicenseFeeDetailContract> $feeDetails = this.getFeeDetails();
        result = result * 59 + ($feeDetails == null ? 43 : ((Object)$feeDetails).hashCode());
        List<SupportDocumentContract> $supportDocuments = this.getSupportDocuments();
        result = result * 59 + ($supportDocuments == null ? 43 : ((Object)$supportDocuments).hashCode());
        List<TradePartnerContract> $partners = this.getPartners();
        result = result * 59 + ($partners == null ? 43 : ((Object)$partners).hashCode());
        List<TradeShiftContract> $shifts = this.getShifts();
        result = result * 59 + ($shifts == null ? 43 : ((Object)$shifts).hashCode());
        Map<String, Object> $licenseData = this.getLicenseData();
        result = result * 59 + ($licenseData == null ? 43 : ((Object)$licenseData).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : ((Object)$auditDetails).hashCode());
        return result;
    }

    public String toString() {
        return "TradeLicenseContract(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", applicationType=" + (Object)((Object)this.getApplicationType()) + ", applicationNumber=" + this.getApplicationNumber() + ", oldLicenseNumber=" + this.getOldLicenseNumber() + ", licenseNumber=" + this.getLicenseNumber() + ", applicationDate=" + this.getApplicationDate() + ", ownerAadhaarNumber=" + this.getOwnerAadhaarNumber() + ", ownerMobileNumber=" + this.getOwnerMobileNumber() + ", ownerName=" + this.getOwnerName() + ", ownerType=" + (Object)((Object)this.getOwnerType()) + ", ownerGender=" + (Object)((Object)this.getOwnerGender()) + ", ownerBirthYear=" + this.getOwnerBirthYear() + ", ownerCorrAddress=" + this.getOwnerCorrAddress() + ", ownerCity=" + this.getOwnerCity() + ", ownerPinCode=" + this.getOwnerPinCode() + ", ownerEmailId=" + this.getOwnerEmailId() + ", ownerPhoneNumber=" + this.getOwnerPhoneNumber() + ", ownerPhoto=" + this.getOwnerPhoto() + ", fatherSpouseName=" + this.getFatherSpouseName() + ", ownerAddress=" + this.getOwnerAddress() + ", establishmentType=" + (Object)((Object)this.getEstablishmentType()) + ", establishmentName=" + this.getEstablishmentName() + ", establishmentRegNo=" + this.getEstablishmentRegNo() + ", establishmentCorrAddress=" + this.getEstablishmentCorrAddress() + ", establishmentCity=" + this.getEstablishmentCity() + ", establishmentPinCode=" + this.getEstablishmentPinCode() + ", establishmentPhoneNo=" + this.getEstablishmentPhoneNo() + ", establishmentMobNo=" + this.getEstablishmentMobNo() + ", establishmentEmailId=" + this.getEstablishmentEmailId() + ", surveyOrGatNo=" + this.getSurveyOrGatNo() + ", ctsOrFinalPlotNo=" + this.getCtsOrFinalPlotNo() + ", plotNo=" + this.getPlotNo() + ", waterConnectionNo=" + this.getWaterConnectionNo() + ", landOwnerName=" + this.getLandOwnerName() + ", isConsentLetterTaken=" + this.getIsConsentLetterTaken() + ", businessDescription=" + this.getBusinessDescription() + ", prevLicenseNo=" + this.getPrevLicenseNo() + ", prevLicenseDate=" + this.getPrevLicenseDate() + ", totalEmployees=" + this.getTotalEmployees() + ", totalMachines=" + this.getTotalMachines() + ", licenseRejBefrForSamePremise=" + this.getLicenseRejBefrForSamePremise() + ", explLicenseNo=" + this.getExplLicenseNo() + ", totalShifts=" + this.getTotalShifts() + ", propertyAssesmentNo=" + this.getPropertyAssesmentNo() + ", locality=" + this.getLocality() + ", adminWard=" + this.getAdminWard() + ", revenueWard=" + this.getRevenueWard() + ", tradeAddress=" + this.getTradeAddress() + ", ownerShipType=" + (Object)((Object)this.getOwnerShipType()) + ", tradeType=" + (Object)((Object)this.getTradeType()) + ", tradeTitle=" + this.getTradeTitle() + ", category=" + this.getCategory() + ", subCategory=" + this.getSubCategory() + ", uom=" + this.getUom() + ", quantity=" + this.getQuantity() + ", validityYears=" + this.getValidityYears() + ", remarks=" + this.getRemarks() + ", tradeCommencementDate=" + this.getTradeCommencementDate() + ", licenseValidFromDate=" + this.getLicenseValidFromDate() + ", issuedDate=" + this.getIssuedDate() + ", agreementDate=" + this.getAgreementDate() + ", agreementNo=" + this.getAgreementNo() + ", isLegacy=" + this.getIsLegacy() + ", isPropertyOwner=" + this.getIsPropertyOwner() + ", active=" + this.getActive() + ", expiryDate=" + this.getExpiryDate() + ", userId=" + this.getUserId() + ", isDataPorting=" + this.getIsDataPorting() + ", status=" + this.getStatus() + ", billId=" + this.getBillId() + ", application=" + this.getApplication() + ", feeDetails=" + this.getFeeDetails() + ", supportDocuments=" + this.getSupportDocuments() + ", partners=" + this.getPartners() + ", shifts=" + this.getShifts() + ", licenseData=" + this.getLicenseData() + ", auditDetails=" + this.getAuditDetails() + ")";
    }

    public TradeLicenseContract() {
    }

    @ConstructorProperties(value={"id", "tenantId", "applicationType", "applicationNumber", "oldLicenseNumber", "licenseNumber", "applicationDate", "ownerAadhaarNumber", "ownerMobileNumber", "ownerName", "ownerType", "ownerGender", "ownerBirthYear", "ownerCorrAddress", "ownerCity", "ownerPinCode", "ownerEmailId", "ownerPhoneNumber", "ownerPhoto", "fatherSpouseName", "ownerAddress", "establishmentType", "establishmentName", "establishmentRegNo", "establishmentCorrAddress", "establishmentCity", "establishmentPinCode", "establishmentPhoneNo", "establishmentMobNo", "establishmentEmailId", "surveyOrGatNo", "ctsOrFinalPlotNo", "plotNo", "waterConnectionNo", "landOwnerName", "isConsentLetterTaken", "businessDescription", "prevLicenseNo", "prevLicenseDate", "totalEmployees", "totalMachines", "licenseRejBefrForSamePremise", "explLicenseNo", "totalShifts", "propertyAssesmentNo", "locality", "adminWard", "revenueWard", "tradeAddress", "ownerShipType", "tradeType", "tradeTitle", "category", "subCategory", "uom", "quantity", "validityYears", "remarks", "tradeCommencementDate", "licenseValidFromDate", "issuedDate", "agreementDate", "agreementNo", "isLegacy", "isPropertyOwner", "active", "expiryDate", "userId", "isDataPorting", "status", "billId", "application", "feeDetails", "supportDocuments", "partners", "shifts", "licenseData", "auditDetails"})
    public TradeLicenseContract(Long id, String tenantId, ApplicationTypeEnum applicationType, String applicationNumber, String oldLicenseNumber, String licenseNumber, Long applicationDate, String ownerAadhaarNumber, String ownerMobileNumber, String ownerName, OwnerTypeEnum ownerType, Gender ownerGender, String ownerBirthYear, String ownerCorrAddress, String ownerCity, String ownerPinCode, String ownerEmailId, String ownerPhoneNumber, String ownerPhoto, String fatherSpouseName, String ownerAddress, EstablishmentTypeEnum establishmentType, String establishmentName, String establishmentRegNo, String establishmentCorrAddress, String establishmentCity, String establishmentPinCode, String establishmentPhoneNo, String establishmentMobNo, String establishmentEmailId, String surveyOrGatNo, String ctsOrFinalPlotNo, String plotNo, String waterConnectionNo, String landOwnerName, Boolean isConsentLetterTaken, String businessDescription, String prevLicenseNo, Long prevLicenseDate, Integer totalEmployees, Integer totalMachines, Boolean licenseRejBefrForSamePremise, String explLicenseNo, Integer totalShifts, String propertyAssesmentNo, String locality, String adminWard, String revenueWard, String tradeAddress, OwnerShipTypeEnum ownerShipType, BusinessNatureEnum tradeType, String tradeTitle, String category, String subCategory, String uom, Double quantity, Long validityYears, String remarks, Long tradeCommencementDate, Long licenseValidFromDate, Long issuedDate, Long agreementDate, String agreementNo, Boolean isLegacy, Boolean isPropertyOwner, Boolean active, Long expiryDate, Long userId, Boolean isDataPorting, String status, String billId, LicenseApplicationContract application, List<LicenseFeeDetailContract> feeDetails, List<SupportDocumentContract> supportDocuments, List<TradePartnerContract> partners, List<TradeShiftContract> shifts, Map<String, Object> licenseData, AuditDetails auditDetails) {
        this.id = id;
        this.tenantId = tenantId;
        this.applicationType = applicationType;
        this.applicationNumber = applicationNumber;
        this.oldLicenseNumber = oldLicenseNumber;
        this.licenseNumber = licenseNumber;
        this.applicationDate = applicationDate;
        this.ownerAadhaarNumber = ownerAadhaarNumber;
        this.ownerMobileNumber = ownerMobileNumber;
        this.ownerName = ownerName;
        this.ownerType = ownerType;
        this.ownerGender = ownerGender;
        this.ownerBirthYear = ownerBirthYear;
        this.ownerCorrAddress = ownerCorrAddress;
        this.ownerCity = ownerCity;
        this.ownerPinCode = ownerPinCode;
        this.ownerEmailId = ownerEmailId;
        this.ownerPhoneNumber = ownerPhoneNumber;
        this.ownerPhoto = ownerPhoto;
        this.fatherSpouseName = fatherSpouseName;
        this.ownerAddress = ownerAddress;
        this.establishmentType = establishmentType;
        this.establishmentName = establishmentName;
        this.establishmentRegNo = establishmentRegNo;
        this.establishmentCorrAddress = establishmentCorrAddress;
        this.establishmentCity = establishmentCity;
        this.establishmentPinCode = establishmentPinCode;
        this.establishmentPhoneNo = establishmentPhoneNo;
        this.establishmentMobNo = establishmentMobNo;
        this.establishmentEmailId = establishmentEmailId;
        this.surveyOrGatNo = surveyOrGatNo;
        this.ctsOrFinalPlotNo = ctsOrFinalPlotNo;
        this.plotNo = plotNo;
        this.waterConnectionNo = waterConnectionNo;
        this.landOwnerName = landOwnerName;
        this.isConsentLetterTaken = isConsentLetterTaken;
        this.businessDescription = businessDescription;
        this.prevLicenseNo = prevLicenseNo;
        this.prevLicenseDate = prevLicenseDate;
        this.totalEmployees = totalEmployees;
        this.totalMachines = totalMachines;
        this.licenseRejBefrForSamePremise = licenseRejBefrForSamePremise;
        this.explLicenseNo = explLicenseNo;
        this.totalShifts = totalShifts;
        this.propertyAssesmentNo = propertyAssesmentNo;
        this.locality = locality;
        this.adminWard = adminWard;
        this.revenueWard = revenueWard;
        this.tradeAddress = tradeAddress;
        this.ownerShipType = ownerShipType;
        this.tradeType = tradeType;
        this.tradeTitle = tradeTitle;
        this.category = category;
        this.subCategory = subCategory;
        this.uom = uom;
        this.quantity = quantity;
        this.validityYears = validityYears;
        this.remarks = remarks;
        this.tradeCommencementDate = tradeCommencementDate;
        this.licenseValidFromDate = licenseValidFromDate;
        this.issuedDate = issuedDate;
        this.agreementDate = agreementDate;
        this.agreementNo = agreementNo;
        this.isLegacy = isLegacy;
        this.isPropertyOwner = isPropertyOwner;
        this.active = active;
        this.expiryDate = expiryDate;
        this.userId = userId;
        this.isDataPorting = isDataPorting;
        this.status = status;
        this.billId = billId;
        this.application = application;
        this.feeDetails = feeDetails;
        this.supportDocuments = supportDocuments;
        this.partners = partners;
        this.shifts = shifts;
        this.licenseData = licenseData;
        this.auditDetails = auditDetails;
    }

    public Long getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public ApplicationTypeEnum getApplicationType() {
        return this.applicationType;
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public String getOldLicenseNumber() {
        return this.oldLicenseNumber;
    }

    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    public Long getApplicationDate() {
        return this.applicationDate;
    }

    public String getOwnerAadhaarNumber() {
        return this.ownerAadhaarNumber;
    }

    public String getOwnerMobileNumber() {
        return this.ownerMobileNumber;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    public Gender getOwnerGender() {
        return this.ownerGender;
    }

    public String getOwnerBirthYear() {
        return this.ownerBirthYear;
    }

    public String getOwnerCorrAddress() {
        return this.ownerCorrAddress;
    }

    public String getOwnerCity() {
        return this.ownerCity;
    }

    public String getOwnerPinCode() {
        return this.ownerPinCode;
    }

    public String getOwnerEmailId() {
        return this.ownerEmailId;
    }

    public String getOwnerPhoneNumber() {
        return this.ownerPhoneNumber;
    }

    public String getOwnerPhoto() {
        return this.ownerPhoto;
    }

    public String getFatherSpouseName() {
        return this.fatherSpouseName;
    }

    public String getOwnerAddress() {
        return this.ownerAddress;
    }

    public EstablishmentTypeEnum getEstablishmentType() {
        return this.establishmentType;
    }

    public String getEstablishmentName() {
        return this.establishmentName;
    }

    public String getEstablishmentRegNo() {
        return this.establishmentRegNo;
    }

    public String getEstablishmentCorrAddress() {
        return this.establishmentCorrAddress;
    }

    public String getEstablishmentCity() {
        return this.establishmentCity;
    }

    public String getEstablishmentPinCode() {
        return this.establishmentPinCode;
    }

    public String getEstablishmentPhoneNo() {
        return this.establishmentPhoneNo;
    }

    public String getEstablishmentMobNo() {
        return this.establishmentMobNo;
    }

    public String getEstablishmentEmailId() {
        return this.establishmentEmailId;
    }

    public String getSurveyOrGatNo() {
        return this.surveyOrGatNo;
    }

    public String getCtsOrFinalPlotNo() {
        return this.ctsOrFinalPlotNo;
    }

    public String getPlotNo() {
        return this.plotNo;
    }

    public String getWaterConnectionNo() {
        return this.waterConnectionNo;
    }

    public String getLandOwnerName() {
        return this.landOwnerName;
    }

    public Boolean getIsConsentLetterTaken() {
        return this.isConsentLetterTaken;
    }

    public String getBusinessDescription() {
        return this.businessDescription;
    }

    public String getPrevLicenseNo() {
        return this.prevLicenseNo;
    }

    public Long getPrevLicenseDate() {
        return this.prevLicenseDate;
    }

    public Integer getTotalEmployees() {
        return this.totalEmployees;
    }

    public Integer getTotalMachines() {
        return this.totalMachines;
    }

    public Boolean getLicenseRejBefrForSamePremise() {
        return this.licenseRejBefrForSamePremise;
    }

    public String getExplLicenseNo() {
        return this.explLicenseNo;
    }

    public Integer getTotalShifts() {
        return this.totalShifts;
    }

    public String getPropertyAssesmentNo() {
        return this.propertyAssesmentNo;
    }

    public String getLocality() {
        return this.locality;
    }

    public String getAdminWard() {
        return this.adminWard;
    }

    public String getRevenueWard() {
        return this.revenueWard;
    }

    public String getTradeAddress() {
        return this.tradeAddress;
    }

    public OwnerShipTypeEnum getOwnerShipType() {
        return this.ownerShipType;
    }

    public BusinessNatureEnum getTradeType() {
        return this.tradeType;
    }

    public String getTradeTitle() {
        return this.tradeTitle;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public String getUom() {
        return this.uom;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public Long getValidityYears() {
        return this.validityYears;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public Long getTradeCommencementDate() {
        return this.tradeCommencementDate;
    }

    public Long getLicenseValidFromDate() {
        return this.licenseValidFromDate;
    }

    public Long getIssuedDate() {
        return this.issuedDate;
    }

    public Long getAgreementDate() {
        return this.agreementDate;
    }

    public String getAgreementNo() {
        return this.agreementNo;
    }

    public Boolean getIsLegacy() {
        return this.isLegacy;
    }

    public Boolean getIsPropertyOwner() {
        return this.isPropertyOwner;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Long getExpiryDate() {
        return this.expiryDate;
    }

    public Long getUserId() {
        return this.userId;
    }

    public Boolean getIsDataPorting() {
        return this.isDataPorting;
    }

    public String getStatus() {
        return this.status;
    }

    public String getBillId() {
        return this.billId;
    }

    public LicenseApplicationContract getApplication() {
        return this.application;
    }

    public List<LicenseFeeDetailContract> getFeeDetails() {
        return this.feeDetails;
    }

    public List<SupportDocumentContract> getSupportDocuments() {
        return this.supportDocuments;
    }

    public List<TradePartnerContract> getPartners() {
        return this.partners;
    }

    public List<TradeShiftContract> getShifts() {
        return this.shifts;
    }

    public Map<String, Object> getLicenseData() {
        return this.licenseData;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setApplicationType(ApplicationTypeEnum applicationType) {
        this.applicationType = applicationType;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public void setOldLicenseNumber(String oldLicenseNumber) {
        this.oldLicenseNumber = oldLicenseNumber;
    }

    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    public void setApplicationDate(Long applicationDate) {
        this.applicationDate = applicationDate;
    }

    public void setOwnerAadhaarNumber(String ownerAadhaarNumber) {
        this.ownerAadhaarNumber = ownerAadhaarNumber;
    }

    public void setOwnerMobileNumber(String ownerMobileNumber) {
        this.ownerMobileNumber = ownerMobileNumber;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void setOwnerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    public void setOwnerGender(Gender ownerGender) {
        this.ownerGender = ownerGender;
    }

    public void setOwnerBirthYear(String ownerBirthYear) {
        this.ownerBirthYear = ownerBirthYear;
    }

    public void setOwnerCorrAddress(String ownerCorrAddress) {
        this.ownerCorrAddress = ownerCorrAddress;
    }

    public void setOwnerCity(String ownerCity) {
        this.ownerCity = ownerCity;
    }

    public void setOwnerPinCode(String ownerPinCode) {
        this.ownerPinCode = ownerPinCode;
    }

    public void setOwnerEmailId(String ownerEmailId) {
        this.ownerEmailId = ownerEmailId;
    }

    public void setOwnerPhoneNumber(String ownerPhoneNumber) {
        this.ownerPhoneNumber = ownerPhoneNumber;
    }

    public void setOwnerPhoto(String ownerPhoto) {
        this.ownerPhoto = ownerPhoto;
    }

    public void setFatherSpouseName(String fatherSpouseName) {
        this.fatherSpouseName = fatherSpouseName;
    }

    public void setOwnerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
    }

    public void setEstablishmentType(EstablishmentTypeEnum establishmentType) {
        this.establishmentType = establishmentType;
    }

    public void setEstablishmentName(String establishmentName) {
        this.establishmentName = establishmentName;
    }

    public void setEstablishmentRegNo(String establishmentRegNo) {
        this.establishmentRegNo = establishmentRegNo;
    }

    public void setEstablishmentCorrAddress(String establishmentCorrAddress) {
        this.establishmentCorrAddress = establishmentCorrAddress;
    }

    public void setEstablishmentCity(String establishmentCity) {
        this.establishmentCity = establishmentCity;
    }

    public void setEstablishmentPinCode(String establishmentPinCode) {
        this.establishmentPinCode = establishmentPinCode;
    }

    public void setEstablishmentPhoneNo(String establishmentPhoneNo) {
        this.establishmentPhoneNo = establishmentPhoneNo;
    }

    public void setEstablishmentMobNo(String establishmentMobNo) {
        this.establishmentMobNo = establishmentMobNo;
    }

    public void setEstablishmentEmailId(String establishmentEmailId) {
        this.establishmentEmailId = establishmentEmailId;
    }

    public void setSurveyOrGatNo(String surveyOrGatNo) {
        this.surveyOrGatNo = surveyOrGatNo;
    }

    public void setCtsOrFinalPlotNo(String ctsOrFinalPlotNo) {
        this.ctsOrFinalPlotNo = ctsOrFinalPlotNo;
    }

    public void setPlotNo(String plotNo) {
        this.plotNo = plotNo;
    }

    public void setWaterConnectionNo(String waterConnectionNo) {
        this.waterConnectionNo = waterConnectionNo;
    }

    public void setLandOwnerName(String landOwnerName) {
        this.landOwnerName = landOwnerName;
    }

    public void setIsConsentLetterTaken(Boolean isConsentLetterTaken) {
        this.isConsentLetterTaken = isConsentLetterTaken;
    }

    public void setBusinessDescription(String businessDescription) {
        this.businessDescription = businessDescription;
    }

    public void setPrevLicenseNo(String prevLicenseNo) {
        this.prevLicenseNo = prevLicenseNo;
    }

    public void setPrevLicenseDate(Long prevLicenseDate) {
        this.prevLicenseDate = prevLicenseDate;
    }

    public void setTotalEmployees(Integer totalEmployees) {
        this.totalEmployees = totalEmployees;
    }

    public void setTotalMachines(Integer totalMachines) {
        this.totalMachines = totalMachines;
    }

    public void setLicenseRejBefrForSamePremise(Boolean licenseRejBefrForSamePremise) {
        this.licenseRejBefrForSamePremise = licenseRejBefrForSamePremise;
    }

    public void setExplLicenseNo(String explLicenseNo) {
        this.explLicenseNo = explLicenseNo;
    }

    public void setTotalShifts(Integer totalShifts) {
        this.totalShifts = totalShifts;
    }

    public void setPropertyAssesmentNo(String propertyAssesmentNo) {
        this.propertyAssesmentNo = propertyAssesmentNo;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public void setAdminWard(String adminWard) {
        this.adminWard = adminWard;
    }

    public void setRevenueWard(String revenueWard) {
        this.revenueWard = revenueWard;
    }

    public void setTradeAddress(String tradeAddress) {
        this.tradeAddress = tradeAddress;
    }

    public void setOwnerShipType(OwnerShipTypeEnum ownerShipType) {
        this.ownerShipType = ownerShipType;
    }

    public void setTradeType(BusinessNatureEnum tradeType) {
        this.tradeType = tradeType;
    }

    public void setTradeTitle(String tradeTitle) {
        this.tradeTitle = tradeTitle;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setSubCategory(String subCategory) {
        this.subCategory = subCategory;
    }

    public void setUom(String uom) {
        this.uom = uom;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public void setValidityYears(Long validityYears) {
        this.validityYears = validityYears;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setTradeCommencementDate(Long tradeCommencementDate) {
        this.tradeCommencementDate = tradeCommencementDate;
    }

    public void setLicenseValidFromDate(Long licenseValidFromDate) {
        this.licenseValidFromDate = licenseValidFromDate;
    }

    public void setIssuedDate(Long issuedDate) {
        this.issuedDate = issuedDate;
    }

    public void setAgreementDate(Long agreementDate) {
        this.agreementDate = agreementDate;
    }

    public void setAgreementNo(String agreementNo) {
        this.agreementNo = agreementNo;
    }

    public void setIsLegacy(Boolean isLegacy) {
        this.isLegacy = isLegacy;
    }

    public void setIsPropertyOwner(Boolean isPropertyOwner) {
        this.isPropertyOwner = isPropertyOwner;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setExpiryDate(Long expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setIsDataPorting(Boolean isDataPorting) {
        this.isDataPorting = isDataPorting;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setBillId(String billId) {
        this.billId = billId;
    }

    public void setApplication(LicenseApplicationContract application) {
        this.application = application;
    }

    public void setFeeDetails(List<LicenseFeeDetailContract> feeDetails) {
        this.feeDetails = feeDetails;
    }

    public void setSupportDocuments(List<SupportDocumentContract> supportDocuments) {
        this.supportDocuments = supportDocuments;
    }

    public void setPartners(List<TradePartnerContract> partners) {
        this.partners = partners;
    }

    public void setShifts(List<TradeShiftContract> shifts) {
        this.shifts = shifts;
    }

    public void setLicenseData(Map<String, Object> licenseData) {
        this.licenseData = licenseData;
    }

    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TradeLicenseContractBuilder {
        private Long id;
        private String tenantId;
        private ApplicationTypeEnum applicationType;
        private String applicationNumber;
        private String oldLicenseNumber;
        private String licenseNumber;
        private Long applicationDate;
        private String ownerAadhaarNumber;
        private String ownerMobileNumber;
        private String ownerName;
        private OwnerTypeEnum ownerType;
        private Gender ownerGender;
        private String ownerBirthYear;
        private String ownerCorrAddress;
        private String ownerCity;
        private String ownerPinCode;
        private String ownerEmailId;
        private String ownerPhoneNumber;
        private String ownerPhoto;
        private String fatherSpouseName;
        private String ownerAddress;
        private EstablishmentTypeEnum establishmentType;
        private String establishmentName;
        private String establishmentRegNo;
        private String establishmentCorrAddress;
        private String establishmentCity;
        private String establishmentPinCode;
        private String establishmentPhoneNo;
        private String establishmentMobNo;
        private String establishmentEmailId;
        private String surveyOrGatNo;
        private String ctsOrFinalPlotNo;
        private String plotNo;
        private String waterConnectionNo;
        private String landOwnerName;
        private Boolean isConsentLetterTaken;
        private String businessDescription;
        private String prevLicenseNo;
        private Long prevLicenseDate;
        private Integer totalEmployees;
        private Integer totalMachines;
        private Boolean licenseRejBefrForSamePremise;
        private String explLicenseNo;
        private Integer totalShifts;
        private String propertyAssesmentNo;
        private String locality;
        private String adminWard;
        private String revenueWard;
        private String tradeAddress;
        private OwnerShipTypeEnum ownerShipType;
        private BusinessNatureEnum tradeType;
        private String tradeTitle;
        private String category;
        private String subCategory;
        private String uom;
        private Double quantity;
        private Long validityYears;
        private String remarks;
        private Long tradeCommencementDate;
        private Long licenseValidFromDate;
        private Long issuedDate;
        private Long agreementDate;
        private String agreementNo;
        private Boolean isLegacy;
        private Boolean isPropertyOwner;
        private Boolean active;
        private Long expiryDate;
        private Long userId;
        private Boolean isDataPorting;
        private String status;
        private String billId;
        private LicenseApplicationContract application;
        private List<LicenseFeeDetailContract> feeDetails;
        private List<SupportDocumentContract> supportDocuments;
        private List<TradePartnerContract> partners;
        private List<TradeShiftContract> shifts;
        private Map<String, Object> licenseData;
        private AuditDetails auditDetails;

        TradeLicenseContractBuilder() {
        }

        public TradeLicenseContractBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TradeLicenseContractBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public TradeLicenseContractBuilder applicationType(ApplicationTypeEnum applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        public TradeLicenseContractBuilder applicationNumber(String applicationNumber) {
            this.applicationNumber = applicationNumber;
            return this;
        }

        public TradeLicenseContractBuilder oldLicenseNumber(String oldLicenseNumber) {
            this.oldLicenseNumber = oldLicenseNumber;
            return this;
        }

        public TradeLicenseContractBuilder licenseNumber(String licenseNumber) {
            this.licenseNumber = licenseNumber;
            return this;
        }

        public TradeLicenseContractBuilder applicationDate(Long applicationDate) {
            this.applicationDate = applicationDate;
            return this;
        }

        public TradeLicenseContractBuilder ownerAadhaarNumber(String ownerAadhaarNumber) {
            this.ownerAadhaarNumber = ownerAadhaarNumber;
            return this;
        }

        public TradeLicenseContractBuilder ownerMobileNumber(String ownerMobileNumber) {
            this.ownerMobileNumber = ownerMobileNumber;
            return this;
        }

        public TradeLicenseContractBuilder ownerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public TradeLicenseContractBuilder ownerType(OwnerTypeEnum ownerType) {
            this.ownerType = ownerType;
            return this;
        }

        public TradeLicenseContractBuilder ownerGender(Gender ownerGender) {
            this.ownerGender = ownerGender;
            return this;
        }

        public TradeLicenseContractBuilder ownerBirthYear(String ownerBirthYear) {
            this.ownerBirthYear = ownerBirthYear;
            return this;
        }

        public TradeLicenseContractBuilder ownerCorrAddress(String ownerCorrAddress) {
            this.ownerCorrAddress = ownerCorrAddress;
            return this;
        }

        public TradeLicenseContractBuilder ownerCity(String ownerCity) {
            this.ownerCity = ownerCity;
            return this;
        }

        public TradeLicenseContractBuilder ownerPinCode(String ownerPinCode) {
            this.ownerPinCode = ownerPinCode;
            return this;
        }

        public TradeLicenseContractBuilder ownerEmailId(String ownerEmailId) {
            this.ownerEmailId = ownerEmailId;
            return this;
        }

        public TradeLicenseContractBuilder ownerPhoneNumber(String ownerPhoneNumber) {
            this.ownerPhoneNumber = ownerPhoneNumber;
            return this;
        }

        public TradeLicenseContractBuilder ownerPhoto(String ownerPhoto) {
            this.ownerPhoto = ownerPhoto;
            return this;
        }

        public TradeLicenseContractBuilder fatherSpouseName(String fatherSpouseName) {
            this.fatherSpouseName = fatherSpouseName;
            return this;
        }

        public TradeLicenseContractBuilder ownerAddress(String ownerAddress) {
            this.ownerAddress = ownerAddress;
            return this;
        }

        public TradeLicenseContractBuilder establishmentType(EstablishmentTypeEnum establishmentType) {
            this.establishmentType = establishmentType;
            return this;
        }

        public TradeLicenseContractBuilder establishmentName(String establishmentName) {
            this.establishmentName = establishmentName;
            return this;
        }

        public TradeLicenseContractBuilder establishmentRegNo(String establishmentRegNo) {
            this.establishmentRegNo = establishmentRegNo;
            return this;
        }

        public TradeLicenseContractBuilder establishmentCorrAddress(String establishmentCorrAddress) {
            this.establishmentCorrAddress = establishmentCorrAddress;
            return this;
        }

        public TradeLicenseContractBuilder establishmentCity(String establishmentCity) {
            this.establishmentCity = establishmentCity;
            return this;
        }

        public TradeLicenseContractBuilder establishmentPinCode(String establishmentPinCode) {
            this.establishmentPinCode = establishmentPinCode;
            return this;
        }

        public TradeLicenseContractBuilder establishmentPhoneNo(String establishmentPhoneNo) {
            this.establishmentPhoneNo = establishmentPhoneNo;
            return this;
        }

        public TradeLicenseContractBuilder establishmentMobNo(String establishmentMobNo) {
            this.establishmentMobNo = establishmentMobNo;
            return this;
        }

        public TradeLicenseContractBuilder establishmentEmailId(String establishmentEmailId) {
            this.establishmentEmailId = establishmentEmailId;
            return this;
        }

        public TradeLicenseContractBuilder surveyOrGatNo(String surveyOrGatNo) {
            this.surveyOrGatNo = surveyOrGatNo;
            return this;
        }

        public TradeLicenseContractBuilder ctsOrFinalPlotNo(String ctsOrFinalPlotNo) {
            this.ctsOrFinalPlotNo = ctsOrFinalPlotNo;
            return this;
        }

        public TradeLicenseContractBuilder plotNo(String plotNo) {
            this.plotNo = plotNo;
            return this;
        }

        public TradeLicenseContractBuilder waterConnectionNo(String waterConnectionNo) {
            this.waterConnectionNo = waterConnectionNo;
            return this;
        }

        public TradeLicenseContractBuilder landOwnerName(String landOwnerName) {
            this.landOwnerName = landOwnerName;
            return this;
        }

        public TradeLicenseContractBuilder isConsentLetterTaken(Boolean isConsentLetterTaken) {
            this.isConsentLetterTaken = isConsentLetterTaken;
            return this;
        }

        public TradeLicenseContractBuilder businessDescription(String businessDescription) {
            this.businessDescription = businessDescription;
            return this;
        }

        public TradeLicenseContractBuilder prevLicenseNo(String prevLicenseNo) {
            this.prevLicenseNo = prevLicenseNo;
            return this;
        }

        public TradeLicenseContractBuilder prevLicenseDate(Long prevLicenseDate) {
            this.prevLicenseDate = prevLicenseDate;
            return this;
        }

        public TradeLicenseContractBuilder totalEmployees(Integer totalEmployees) {
            this.totalEmployees = totalEmployees;
            return this;
        }

        public TradeLicenseContractBuilder totalMachines(Integer totalMachines) {
            this.totalMachines = totalMachines;
            return this;
        }

        public TradeLicenseContractBuilder licenseRejBefrForSamePremise(Boolean licenseRejBefrForSamePremise) {
            this.licenseRejBefrForSamePremise = licenseRejBefrForSamePremise;
            return this;
        }

        public TradeLicenseContractBuilder explLicenseNo(String explLicenseNo) {
            this.explLicenseNo = explLicenseNo;
            return this;
        }

        public TradeLicenseContractBuilder totalShifts(Integer totalShifts) {
            this.totalShifts = totalShifts;
            return this;
        }

        public TradeLicenseContractBuilder propertyAssesmentNo(String propertyAssesmentNo) {
            this.propertyAssesmentNo = propertyAssesmentNo;
            return this;
        }

        public TradeLicenseContractBuilder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public TradeLicenseContractBuilder adminWard(String adminWard) {
            this.adminWard = adminWard;
            return this;
        }

        public TradeLicenseContractBuilder revenueWard(String revenueWard) {
            this.revenueWard = revenueWard;
            return this;
        }

        public TradeLicenseContractBuilder tradeAddress(String tradeAddress) {
            this.tradeAddress = tradeAddress;
            return this;
        }

        public TradeLicenseContractBuilder ownerShipType(OwnerShipTypeEnum ownerShipType) {
            this.ownerShipType = ownerShipType;
            return this;
        }

        public TradeLicenseContractBuilder tradeType(BusinessNatureEnum tradeType) {
            this.tradeType = tradeType;
            return this;
        }

        public TradeLicenseContractBuilder tradeTitle(String tradeTitle) {
            this.tradeTitle = tradeTitle;
            return this;
        }

        public TradeLicenseContractBuilder category(String category) {
            this.category = category;
            return this;
        }

        public TradeLicenseContractBuilder subCategory(String subCategory) {
            this.subCategory = subCategory;
            return this;
        }

        public TradeLicenseContractBuilder uom(String uom) {
            this.uom = uom;
            return this;
        }

        public TradeLicenseContractBuilder quantity(Double quantity) {
            this.quantity = quantity;
            return this;
        }

        public TradeLicenseContractBuilder validityYears(Long validityYears) {
            this.validityYears = validityYears;
            return this;
        }

        public TradeLicenseContractBuilder remarks(String remarks) {
            this.remarks = remarks;
            return this;
        }

        public TradeLicenseContractBuilder tradeCommencementDate(Long tradeCommencementDate) {
            this.tradeCommencementDate = tradeCommencementDate;
            return this;
        }

        public TradeLicenseContractBuilder licenseValidFromDate(Long licenseValidFromDate) {
            this.licenseValidFromDate = licenseValidFromDate;
            return this;
        }

        public TradeLicenseContractBuilder issuedDate(Long issuedDate) {
            this.issuedDate = issuedDate;
            return this;
        }

        public TradeLicenseContractBuilder agreementDate(Long agreementDate) {
            this.agreementDate = agreementDate;
            return this;
        }

        public TradeLicenseContractBuilder agreementNo(String agreementNo) {
            this.agreementNo = agreementNo;
            return this;
        }

        public TradeLicenseContractBuilder isLegacy(Boolean isLegacy) {
            this.isLegacy = isLegacy;
            return this;
        }

        public TradeLicenseContractBuilder isPropertyOwner(Boolean isPropertyOwner) {
            this.isPropertyOwner = isPropertyOwner;
            return this;
        }

        public TradeLicenseContractBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public TradeLicenseContractBuilder expiryDate(Long expiryDate) {
            this.expiryDate = expiryDate;
            return this;
        }

        public TradeLicenseContractBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public TradeLicenseContractBuilder isDataPorting(Boolean isDataPorting) {
            this.isDataPorting = isDataPorting;
            return this;
        }

        public TradeLicenseContractBuilder status(String status) {
            this.status = status;
            return this;
        }

        public TradeLicenseContractBuilder billId(String billId) {
            this.billId = billId;
            return this;
        }

        public TradeLicenseContractBuilder application(LicenseApplicationContract application) {
            this.application = application;
            return this;
        }

        public TradeLicenseContractBuilder feeDetails(List<LicenseFeeDetailContract> feeDetails) {
            this.feeDetails = feeDetails;
            return this;
        }

        public TradeLicenseContractBuilder supportDocuments(List<SupportDocumentContract> supportDocuments) {
            this.supportDocuments = supportDocuments;
            return this;
        }

        public TradeLicenseContractBuilder partners(List<TradePartnerContract> partners) {
            this.partners = partners;
            return this;
        }

        public TradeLicenseContractBuilder shifts(List<TradeShiftContract> shifts) {
            this.shifts = shifts;
            return this;
        }

        public TradeLicenseContractBuilder licenseData(Map<String, Object> licenseData) {
            this.licenseData = licenseData;
            return this;
        }

        public TradeLicenseContractBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public TradeLicenseContract build() {
            return new TradeLicenseContract(this.id, this.tenantId, this.applicationType, this.applicationNumber, this.oldLicenseNumber, this.licenseNumber, this.applicationDate, this.ownerAadhaarNumber, this.ownerMobileNumber, this.ownerName, this.ownerType, this.ownerGender, this.ownerBirthYear, this.ownerCorrAddress, this.ownerCity, this.ownerPinCode, this.ownerEmailId, this.ownerPhoneNumber, this.ownerPhoto, this.fatherSpouseName, this.ownerAddress, this.establishmentType, this.establishmentName, this.establishmentRegNo, this.establishmentCorrAddress, this.establishmentCity, this.establishmentPinCode, this.establishmentPhoneNo, this.establishmentMobNo, this.establishmentEmailId, this.surveyOrGatNo, this.ctsOrFinalPlotNo, this.plotNo, this.waterConnectionNo, this.landOwnerName, this.isConsentLetterTaken, this.businessDescription, this.prevLicenseNo, this.prevLicenseDate, this.totalEmployees, this.totalMachines, this.licenseRejBefrForSamePremise, this.explLicenseNo, this.totalShifts, this.propertyAssesmentNo, this.locality, this.adminWard, this.revenueWard, this.tradeAddress, this.ownerShipType, this.tradeType, this.tradeTitle, this.category, this.subCategory, this.uom, this.quantity, this.validityYears, this.remarks, this.tradeCommencementDate, this.licenseValidFromDate, this.issuedDate, this.agreementDate, this.agreementNo, this.isLegacy, this.isPropertyOwner, this.active, this.expiryDate, this.userId, this.isDataPorting, this.status, this.billId, this.application, this.feeDetails, this.supportDocuments, this.partners, this.shifts, this.licenseData, this.auditDetails);
        }

        public String toString() {
            return "TradeLicenseContract.TradeLicenseContractBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", applicationType=" + (Object)((Object)this.applicationType) + ", applicationNumber=" + this.applicationNumber + ", oldLicenseNumber=" + this.oldLicenseNumber + ", licenseNumber=" + this.licenseNumber + ", applicationDate=" + this.applicationDate + ", ownerAadhaarNumber=" + this.ownerAadhaarNumber + ", ownerMobileNumber=" + this.ownerMobileNumber + ", ownerName=" + this.ownerName + ", ownerType=" + (Object)((Object)this.ownerType) + ", ownerGender=" + (Object)((Object)this.ownerGender) + ", ownerBirthYear=" + this.ownerBirthYear + ", ownerCorrAddress=" + this.ownerCorrAddress + ", ownerCity=" + this.ownerCity + ", ownerPinCode=" + this.ownerPinCode + ", ownerEmailId=" + this.ownerEmailId + ", ownerPhoneNumber=" + this.ownerPhoneNumber + ", ownerPhoto=" + this.ownerPhoto + ", fatherSpouseName=" + this.fatherSpouseName + ", ownerAddress=" + this.ownerAddress + ", establishmentType=" + (Object)((Object)this.establishmentType) + ", establishmentName=" + this.establishmentName + ", establishmentRegNo=" + this.establishmentRegNo + ", establishmentCorrAddress=" + this.establishmentCorrAddress + ", establishmentCity=" + this.establishmentCity + ", establishmentPinCode=" + this.establishmentPinCode + ", establishmentPhoneNo=" + this.establishmentPhoneNo + ", establishmentMobNo=" + this.establishmentMobNo + ", establishmentEmailId=" + this.establishmentEmailId + ", surveyOrGatNo=" + this.surveyOrGatNo + ", ctsOrFinalPlotNo=" + this.ctsOrFinalPlotNo + ", plotNo=" + this.plotNo + ", waterConnectionNo=" + this.waterConnectionNo + ", landOwnerName=" + this.landOwnerName + ", isConsentLetterTaken=" + this.isConsentLetterTaken + ", businessDescription=" + this.businessDescription + ", prevLicenseNo=" + this.prevLicenseNo + ", prevLicenseDate=" + this.prevLicenseDate + ", totalEmployees=" + this.totalEmployees + ", totalMachines=" + this.totalMachines + ", licenseRejBefrForSamePremise=" + this.licenseRejBefrForSamePremise + ", explLicenseNo=" + this.explLicenseNo + ", totalShifts=" + this.totalShifts + ", propertyAssesmentNo=" + this.propertyAssesmentNo + ", locality=" + this.locality + ", adminWard=" + this.adminWard + ", revenueWard=" + this.revenueWard + ", tradeAddress=" + this.tradeAddress + ", ownerShipType=" + (Object)((Object)this.ownerShipType) + ", tradeType=" + (Object)((Object)this.tradeType) + ", tradeTitle=" + this.tradeTitle + ", category=" + this.category + ", subCategory=" + this.subCategory + ", uom=" + this.uom + ", quantity=" + this.quantity + ", validityYears=" + this.validityYears + ", remarks=" + this.remarks + ", tradeCommencementDate=" + this.tradeCommencementDate + ", licenseValidFromDate=" + this.licenseValidFromDate + ", issuedDate=" + this.issuedDate + ", agreementDate=" + this.agreementDate + ", agreementNo=" + this.agreementNo + ", isLegacy=" + this.isLegacy + ", isPropertyOwner=" + this.isPropertyOwner + ", active=" + this.active + ", expiryDate=" + this.expiryDate + ", userId=" + this.userId + ", isDataPorting=" + this.isDataPorting + ", status=" + this.status + ", billId=" + this.billId + ", application=" + this.application + ", feeDetails=" + this.feeDetails + ", supportDocuments=" + this.supportDocuments + ", partners=" + this.partners + ", shifts=" + this.shifts + ", licenseData=" + this.licenseData + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

