/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.commons.web.contract;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.egov.tl.commons.web.contract.AuditDetails;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

public class LicenseFeeDetailContract {
    @JsonProperty(value="id")
    private Long id;
    @NotEmpty(message="{error.financialYear.empty}")
    @Length(min=1, max=128, message="{error.financialYear.empty}")
    @Pattern(regexp=".*[^ ].*", message="{error.financialYear.emptyspaces}")
    @JsonProperty(value="financialYear")
    private String financialYear;
    @JsonProperty(value="tenantId")
    private String tenantId;
    @JsonProperty(value="applicationId")
    private Long applicationId;
    @NotNull(message="{error.license.amount}")
    @DecimalMin(value="0", inclusive=false, message="{error.license.min.amount}")
    @Digits(integer=10, fraction=2, message="{error.license.amount.decimal}")
    @JsonProperty(value="amount")
    private Double amount;
    @JsonProperty(value="paid")
    private Boolean paid = false;
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails;

    public static LicenseFeeDetailContractBuilder builder() {
        return new LicenseFeeDetailContractBuilder();
    }

    @ConstructorProperties(value={"id", "financialYear", "tenantId", "applicationId", "amount", "paid", "auditDetails"})
    public LicenseFeeDetailContract(Long id, String financialYear, String tenantId, Long applicationId, Double amount, Boolean paid, AuditDetails auditDetails) {
        this.id = id;
        this.financialYear = financialYear;
        this.tenantId = tenantId;
        this.applicationId = applicationId;
        this.amount = amount;
        this.paid = paid;
        this.auditDetails = auditDetails;
    }

    public LicenseFeeDetailContract() {
    }

    public Long getId() {
        return this.id;
    }

    public String getFinancialYear() {
        return this.financialYear;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Long getApplicationId() {
        return this.applicationId;
    }

    public Double getAmount() {
        return this.amount;
    }

    public Boolean getPaid() {
        return this.paid;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFinancialYear(String financialYear) {
        this.financialYear = financialYear;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setApplicationId(Long applicationId) {
        this.applicationId = applicationId;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public static class LicenseFeeDetailContractBuilder {
        private Long id;
        private String financialYear;
        private String tenantId;
        private Long applicationId;
        private Double amount;
        private Boolean paid;
        private AuditDetails auditDetails;

        LicenseFeeDetailContractBuilder() {
        }

        public LicenseFeeDetailContractBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public LicenseFeeDetailContractBuilder financialYear(String financialYear) {
            this.financialYear = financialYear;
            return this;
        }

        public LicenseFeeDetailContractBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public LicenseFeeDetailContractBuilder applicationId(Long applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public LicenseFeeDetailContractBuilder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public LicenseFeeDetailContractBuilder paid(Boolean paid) {
            this.paid = paid;
            return this;
        }

        public LicenseFeeDetailContractBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public LicenseFeeDetailContract build() {
            return new LicenseFeeDetailContract(this.id, this.financialYear, this.tenantId, this.applicationId, this.amount, this.paid, this.auditDetails);
        }

        public String toString() {
            return "LicenseFeeDetailContract.LicenseFeeDetailContractBuilder(id=" + this.id + ", financialYear=" + this.financialYear + ", tenantId=" + this.tenantId + ", applicationId=" + this.applicationId + ", amount=" + this.amount + ", paid=" + this.paid + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

