/*
 * Decompiled with CFR 0.152.
 */
package org.egov.report.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.domain.model.ReportDefinitions;
import org.egov.domain.model.Response;
import org.egov.report.repository.ReportRepository;
import org.egov.swagger.model.ColumnDetail;
import org.egov.swagger.model.MetadataResponse;
import org.egov.swagger.model.ReportDefinition;
import org.egov.swagger.model.ReportMetadata;
import org.egov.swagger.model.ReportRequest;
import org.egov.swagger.model.ReportResponse;
import org.egov.swagger.model.SourceColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ReportService {
    @Autowired
    public ReportDefinitions reportDefinitions;
    @Autowired
    private ReportRepository reportRepository;
    @Autowired
    private Response responseInfoFactory;
    public static final Logger LOGGER = LoggerFactory.getLogger(ReportService.class);

    public MetadataResponse getMetaData(String reportName) {
        ColumnDetail.TypeEnum te;
        MetadataResponse metadataResponse = new MetadataResponse();
        ReportDefinition reportDefinition = new ReportDefinition();
        System.out.println("Report Definition is" + this.reportDefinitions.getReportDefinitions());
        for (ReportDefinition rDefinition : this.reportDefinitions.getReportDefinitions()) {
            if (!rDefinition.getReportName().equals(reportName)) continue;
            reportDefinition = rDefinition;
        }
        ReportMetadata rmt = new ReportMetadata();
        rmt.setReportName(reportDefinition.getReportName());
        ArrayList<ColumnDetail> reportHeaders = new ArrayList<ColumnDetail>();
        ArrayList<ColumnDetail> searchParams2 = new ArrayList<ColumnDetail>();
        for (SourceColumn cd : reportDefinition.getSourceColumns()) {
            ColumnDetail reportheader = new ColumnDetail();
            reportheader.setLabel(cd.getLabel());
            reportheader.setName(cd.getName());
            if (cd.getPattern() != null) {
                reportheader.setPattern(cd.getPattern());
            }
            te = this.getType(cd.getType().toString());
            reportheader.setType(te);
            reportHeaders.add(reportheader);
        }
        for (SourceColumn cd : reportDefinition.getSearchParams()) {
            ColumnDetail searchParam = new ColumnDetail();
            searchParam.setLabel(cd.getLabel());
            searchParam.setName(cd.getName());
            te = this.getType(cd.getType().toString());
            if (cd.getPattern() != null) {
                searchParam.setPattern(cd.getPattern());
            }
            searchParam.setType(te);
            searchParams2.add(searchParam);
        }
        rmt.setReportHeader(reportHeaders);
        rmt.setSearchParams(searchParams2);
        metadataResponse.setReportDetails(rmt);
        return metadataResponse;
    }

    public ColumnDetail.TypeEnum getType(String type) {
        if (type.equals("string")) {
            return ColumnDetail.TypeEnum.STRING;
        }
        if (type.equals("number")) {
            return ColumnDetail.TypeEnum.NUMBER;
        }
        if (type.equals("epoch")) {
            return ColumnDetail.TypeEnum.EPOCH;
        }
        if (type.equals("singlevaluelist")) {
            return ColumnDetail.TypeEnum.SINGLEVALUELIST;
        }
        return null;
    }

    public ResponseEntity<?> getSuccessResponse(MetadataResponse metadataResponse, RequestInfo requestInfo, String tenantID) {
        MetadataResponse metadataResponses = new MetadataResponse();
        ResponseInfo responseInfo = this.responseInfoFactory.createResponseInfoFromRequestInfo(requestInfo, Boolean.valueOf(true));
        responseInfo.setStatus(HttpStatus.OK.toString());
        metadataResponses.setRequestInfo(responseInfo);
        metadataResponses.setTenantId(tenantID);
        metadataResponses.setReportDetails(metadataResponse.getReportDetails());
        return new ResponseEntity((Object)metadataResponses, HttpStatus.OK);
    }

    public ReportResponse getReportData(ReportRequest reportRequest) {
        List listReportDefinitions = this.reportDefinitions.getReportDefinitions();
        ReportDefinition reportDefinition = listReportDefinitions.stream().filter(t -> t.getReportName().equals(reportRequest.getReportName())).findFirst().orElse(null);
        LOGGER.info("reportYamlMetaData::" + reportDefinition);
        List maps = this.reportRepository.getData(reportRequest, reportDefinition);
        List columns = reportDefinition.getSourceColumns();
        LOGGER.info("columns::" + columns);
        LOGGER.info("maps::" + maps);
        ReportResponse reportResponse = new ReportResponse();
        this.populateData(columns, maps, reportResponse);
        this.populateReportHeader(reportDefinition, reportResponse);
        return reportResponse;
    }

    private void populateData(List<SourceColumn> columns, List<Map<String, Object>> maps, ReportResponse reportResponse) {
        ArrayList lists = new ArrayList();
        for (int i = 0; i < maps.size(); ++i) {
            ArrayList<Object> objects = new ArrayList<Object>();
            Map<String, Object> map = maps.get(i);
            for (SourceColumn sourceColm : columns) {
                objects.add(map.get(sourceColm.getName()));
            }
            lists.add(objects);
        }
        reportResponse.setReportData(lists);
    }

    private void populateReportHeader(ReportDefinition reportDefinition, ReportResponse reportResponse) {
        List columns = reportDefinition.getSourceColumns();
        List columnDetails = columns.stream().map(p -> new ColumnDetail(p.getLabel(), p.getPattern(), p.getType(), p.getName())).collect(Collectors.toList());
        reportResponse.setReportHeader(columnDetails);
    }
}

