/*
 * Decompiled with CFR 0.152.
 */
package org.egov;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import org.egov.domain.model.ReportDefinitions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@SpringBootApplication
public class ReportApp {
    public static final Logger LOGGER = LoggerFactory.getLogger(ReportApp.class);
    @Autowired
    public static ResourceLoader resourceLoader;
    @Autowired
    private Environment env;

    public ReportApp(ResourceLoader resourceLoader) {
        ReportApp.resourceLoader = resourceLoader;
    }

    public static void main(String[] args) throws Exception {
        SpringApplication.run(ReportApp.class, (String[])args);
    }

    @Bean
    public MappingJackson2HttpMessageConverter jacksonConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        converter.setObjectMapper(mapper);
        return converter;
    }

    @Bean(value={"reportDefinitions"})
    public ReportDefinitions loadYaml() {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            Resource resource = resourceLoader.getResource("file:" + this.env.getProperty("report.yaml.path"));
            File yamlFile = resource.getFile();
            ReportDefinitions reportDefinitions = (ReportDefinitions)mapper.readValue(yamlFile, ReportDefinitions.class);
            LOGGER.info(reportDefinitions.toString());
            return reportDefinitions;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

