/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.common.contract;

import java.util.List;
import java.util.stream.Collectors;
import org.egov.pgr.common.contract.AttributeEntry;

public class AttributeValues {
    public static String getAttributeSingleValue(List<AttributeEntry> attributeValues, String expectedKey) {
        if (attributeValues == null) {
            return null;
        }
        return attributeValues.stream().filter(a -> expectedKey.equals(a.getKey())).findFirst().map(AttributeEntry::getName).orElse(null);
    }

    public static List<String> getAttributeMultipleValue(List<AttributeEntry> attributeValues, String expectedKey) {
        if (attributeValues == null) {
            return null;
        }
        return attributeValues.stream().filter(a -> expectedKey.equals(a.getKey())).map(AttributeEntry::getName).collect(Collectors.toList());
    }

    public static void createOrUpdateAttributeEntry(List<AttributeEntry> attributeValues, String key, String name) {
        if (AttributeValues.isAttributeKeyPresent(attributeValues, key)) {
            AttributeValues.updateAttributeEntry(attributeValues, key, name);
        } else {
            AttributeValues.createAttributeEntry(attributeValues, key, name);
        }
    }

    private static boolean isAttributeKeyPresent(List<AttributeEntry> attributeValues, String key) {
        return attributeValues.stream().anyMatch(attribute -> key.equals(attribute.getKey()));
    }

    private static void createAttributeEntry(List<AttributeEntry> attributeValues, String key, String name) {
        attributeValues.add(new AttributeEntry(key, name));
    }

    private static void updateAttributeEntry(List<AttributeEntry> attributeValues, String key, String name) {
        AttributeEntry matchingEntry = attributeValues.stream().filter(attribute -> key.equals(attribute.getKey())).findFirst().orElse(null);
        matchingEntry.setName(name);
    }
}

