/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.common.repository;

import org.egov.pgr.common.model.OtpRequest;
import org.egov.pgr.common.repository.SMSRequest;
import org.egov.tracer.kafka.LogAwareKafkaTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OtpSMSRepository {
    private static final String SMS_REGISTER_OTP_MESSAGE = "Dear Citizen, to register the complaint, the OTP is %s.";
    private LogAwareKafkaTemplate<String, Object> kafkaTemplate;
    private String smsTopic;

    @Autowired
    public OtpSMSRepository(LogAwareKafkaTemplate<String, Object> kafkaTemplate, @Value(value="${sms.topic}") String smsTopic) {
        this.kafkaTemplate = kafkaTemplate;
        this.smsTopic = smsTopic;
    }

    public void send(OtpRequest otpRequest, String otpNumber) {
        String message = this.getMessage(otpNumber);
        this.kafkaTemplate.send(this.smsTopic, (Object)new SMSRequest(otpRequest.getMobileNumber(), message));
    }

    private String getMessage(String otpNumber) {
        return String.format(SMS_REGISTER_OTP_MESSAGE, otpNumber);
    }
}

