/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.common.repository;

import org.egov.pgr.common.model.OtpValidationRequest;
import org.egov.pgr.common.repository.Otp;
import org.egov.pgr.common.repository.OtpRequest;
import org.egov.pgr.common.repository.OtpResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class OtpRepository {
    private static final String OTP_CREATE = "otp/v1/_create";
    private static final String OTP_SEARCH = "otp/v1/_search";
    private final String otpCreateUrl;
    private final String otpSearchUrl;
    private RestTemplate restTemplate;

    public OtpRepository(RestTemplate restTemplate, @Value(value="${otp.host}") String otpHost) {
        this.restTemplate = restTemplate;
        this.otpCreateUrl = otpHost + OTP_CREATE;
        this.otpSearchUrl = otpHost + OTP_SEARCH;
    }

    public String fetchOtp(org.egov.pgr.common.model.OtpRequest otpRequest) {
        OtpRequest request = new OtpRequest(otpRequest);
        OtpResponse otpResponse = (OtpResponse)this.restTemplate.postForObject(this.otpCreateUrl, (Object)request, OtpResponse.class, new Object[0]);
        return otpResponse.getOtpNumber();
    }

    public boolean isOtpValidationComplete(OtpValidationRequest request) {
        Otp otp = Otp.builder().tenantId(request.getTenantId()).uuid(request.getOtpReference()).build();
        OtpRequest otpRequest = new OtpRequest(otp);
        OtpResponse otpResponse = (OtpResponse)this.restTemplate.postForObject(this.otpSearchUrl, (Object)otpRequest, OtpResponse.class, new Object[0]);
        return otpResponse.isValidationComplete(request.getMobileNumber());
    }
}

