/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.common.repository;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
class Otp {
    private String otp;
    private String identity;
    private String tenantId;
    @JsonProperty(value="isValidationSuccessful")
    private boolean validationSuccessful;
    @JsonProperty(value="UUID")
    private String uuid;

    public boolean isValidationComplete(String mobileNumber) {
        return this.validationSuccessful && this.identity.equals(mobileNumber);
    }

    public static OtpBuilder builder() {
        return new OtpBuilder();
    }

    public String getOtp() {
        return this.otp;
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isValidationSuccessful() {
        return this.validationSuccessful;
    }

    public String getUuid() {
        return this.uuid;
    }

    @ConstructorProperties(value={"otp", "identity", "tenantId", "validationSuccessful", "uuid"})
    public Otp(String otp, String identity, String tenantId, boolean validationSuccessful, String uuid) {
        this.otp = otp;
        this.identity = identity;
        this.tenantId = tenantId;
        this.validationSuccessful = validationSuccessful;
        this.uuid = uuid;
    }

    public static class OtpBuilder {
        private String otp;
        private String identity;
        private String tenantId;
        private boolean validationSuccessful;
        private String uuid;

        OtpBuilder() {
        }

        public OtpBuilder otp(String otp) {
            this.otp = otp;
            return this;
        }

        public OtpBuilder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public OtpBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public OtpBuilder validationSuccessful(boolean validationSuccessful) {
            this.validationSuccessful = validationSuccessful;
            return this;
        }

        public OtpBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Otp build() {
            return new Otp(this.otp, this.identity, this.tenantId, this.validationSuccessful, this.uuid);
        }

        public String toString() {
            return "Otp.OtpBuilder(otp=" + this.otp + ", identity=" + this.identity + ", tenantId=" + this.tenantId + ", validationSuccessful=" + this.validationSuccessful + ", uuid=" + this.uuid + ")";
        }
    }
}

