/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.common.repository;

import org.egov.pgr.common.model.Location;
import org.egov.pgr.common.repository.BoundaryResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class LocationRepository {
    private final RestTemplate restTemplate;
    private final String url;
    private static final String BOUNDARY_BY_ID = "egov-location/boundarys?Boundary.id={id}&Boundary.tenantId={tenantId}";

    public LocationRepository(RestTemplate restTemplate, @Value(value="${location.host}") String locationServiceHostname) {
        this.restTemplate = restTemplate;
        this.url = locationServiceHostname + BOUNDARY_BY_ID;
    }

    public Location getLocationById(String id, String tenantId) {
        BoundaryResponse boundaryResponse = (BoundaryResponse)this.restTemplate.getForObject(this.url, BoundaryResponse.class, new Object[]{id, tenantId});
        return boundaryResponse.toDomain();
    }
}

