/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.common.repository;

import org.egov.common.contract.request.RequestInfo;
import org.egov.pgr.common.model.Employee;
import org.egov.pgr.common.repository.EmployeeRes;
import org.egov.pgr.common.repository.RequestInfoWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class EmployeeRepository {
    private final RestTemplate restTemplate;
    private final String findEmployeeByPositionUrl;
    private final String findEmployeeByIdUrl;
    private static final String EMPLOYEE_BY_POSITION = "hr-employee/employees/_search?positionId={positionId}&tenantId={tenantId}";
    private static final String EMPLOYEE_BY_ID = "hr-employee/employees/_search?id={id}&tenantId={tenantId}";

    @Autowired
    public EmployeeRepository(RestTemplate restTemplate, @Value(value="${hremployee.host}") String employeeServiceHostname) {
        this.restTemplate = restTemplate;
        this.findEmployeeByPositionUrl = employeeServiceHostname + EMPLOYEE_BY_POSITION;
        this.findEmployeeByIdUrl = employeeServiceHostname + EMPLOYEE_BY_ID;
    }

    public Employee getEmployeeByPosition(Long positionId, String tenantId) {
        RequestInfoWrapper requestBody = this.buildRequestInfo();
        EmployeeRes response = (EmployeeRes)this.restTemplate.postForObject(this.findEmployeeByPositionUrl, (Object)requestBody, EmployeeRes.class, new Object[]{positionId, tenantId});
        return response != null ? response.toDomain() : null;
    }

    public Employee getEmployeeById(Long id, String tenantId) {
        RequestInfoWrapper requestBody = this.buildRequestInfo();
        EmployeeRes response = (EmployeeRes)this.restTemplate.postForObject(this.findEmployeeByIdUrl, (Object)requestBody, EmployeeRes.class, new Object[]{id, tenantId});
        return response != null ? response.toDomain() : null;
    }

    private RequestInfoWrapper buildRequestInfo() {
        RequestInfo requestInfo = RequestInfo.builder().build();
        return RequestInfoWrapper.builder().RequestInfo(requestInfo).build();
    }
}

