/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.common.repository;

import org.egov.common.contract.request.RequestInfo;
import org.egov.pgr.common.repository.OtpConfigResponse;
import org.egov.pgr.common.repository.RequestInfoWrapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class ComplaintConfigurationRepository {
    private static final String ANONYMOUS_COMPLAINT_OTP_CONFIG_URL = "pgr/OTPConfig/_search?tenantId={tenantId}";
    private final String url;
    private RestTemplate restTemplate;

    public ComplaintConfigurationRepository(RestTemplate restTemplate, @Value(value="${pgrmaster.host}") String pgrMasterHost) {
        this.restTemplate = restTemplate;
        this.url = pgrMasterHost + ANONYMOUS_COMPLAINT_OTP_CONFIG_URL;
    }

    public boolean isOtpEnabledForAnonymousComplaint(String tenantId) {
        RequestInfoWrapper request = this.buildRequestInfo();
        OtpConfigResponse response = (OtpConfigResponse)this.restTemplate.postForObject(this.url, (Object)request, OtpConfigResponse.class, new Object[]{tenantId});
        return response.isOtpEnabledForAnonymousComplaint();
    }

    private RequestInfoWrapper buildRequestInfo() {
        RequestInfo requestInfo = RequestInfo.builder().build();
        return RequestInfoWrapper.builder().RequestInfo(requestInfo).build();
    }
}

