/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.common.model;

import java.beans.ConstructorProperties;
import org.egov.pgr.common.model.exception.InvalidOtpValidationRequestException;
import org.springframework.util.StringUtils;

public class OtpValidationRequest {
    private String otpReference;
    private String mobileNumber;
    private String tenantId;

    public void validate() {
        if (this.isOtpReferenceAbsent() || this.isMobileNumberAbsent() || this.isTenantIdAbsent()) {
            throw new InvalidOtpValidationRequestException(this);
        }
    }

    public boolean isTenantIdAbsent() {
        return StringUtils.isEmpty((Object)this.tenantId);
    }

    public boolean isMobileNumberAbsent() {
        return StringUtils.isEmpty((Object)this.mobileNumber);
    }

    public boolean isOtpReferenceAbsent() {
        return StringUtils.isEmpty((Object)this.otpReference);
    }

    public static OtpValidationRequestBuilder builder() {
        return new OtpValidationRequestBuilder();
    }

    @ConstructorProperties(value={"otpReference", "mobileNumber", "tenantId"})
    public OtpValidationRequest(String otpReference, String mobileNumber, String tenantId) {
        this.otpReference = otpReference;
        this.mobileNumber = mobileNumber;
        this.tenantId = tenantId;
    }

    public String getOtpReference() {
        return this.otpReference;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OtpValidationRequest)) {
            return false;
        }
        OtpValidationRequest other = (OtpValidationRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$otpReference = this.getOtpReference();
        String other$otpReference = other.getOtpReference();
        if (this$otpReference == null ? other$otpReference != null : !this$otpReference.equals(other$otpReference)) {
            return false;
        }
        String this$mobileNumber = this.getMobileNumber();
        String other$mobileNumber = other.getMobileNumber();
        if (this$mobileNumber == null ? other$mobileNumber != null : !this$mobileNumber.equals(other$mobileNumber)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OtpValidationRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $otpReference = this.getOtpReference();
        result = result * 59 + ($otpReference == null ? 43 : $otpReference.hashCode());
        String $mobileNumber = this.getMobileNumber();
        result = result * 59 + ($mobileNumber == null ? 43 : $mobileNumber.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        return result;
    }

    public static class OtpValidationRequestBuilder {
        private String otpReference;
        private String mobileNumber;
        private String tenantId;

        OtpValidationRequestBuilder() {
        }

        public OtpValidationRequestBuilder otpReference(String otpReference) {
            this.otpReference = otpReference;
            return this;
        }

        public OtpValidationRequestBuilder mobileNumber(String mobileNumber) {
            this.mobileNumber = mobileNumber;
            return this;
        }

        public OtpValidationRequestBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public OtpValidationRequest build() {
            return new OtpValidationRequest(this.otpReference, this.mobileNumber, this.tenantId);
        }

        public String toString() {
            return "OtpValidationRequest.OtpValidationRequestBuilder(otpReference=" + this.otpReference + ", mobileNumber=" + this.mobileNumber + ", tenantId=" + this.tenantId + ")";
        }
    }
}

