/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.common.model;

import java.beans.ConstructorProperties;
import org.egov.pgr.common.model.exception.InvalidOtpRequestException;
import org.springframework.util.StringUtils;

public class OtpRequest {
    private String mobileNumber;
    private String tenantId;

    public void validate() {
        if (this.isTenantIdAbsent() || this.isMobileNumberAbsent()) {
            throw new InvalidOtpRequestException(this);
        }
    }

    public boolean isTenantIdAbsent() {
        return StringUtils.isEmpty((Object)this.tenantId);
    }

    public boolean isMobileNumberAbsent() {
        return StringUtils.isEmpty((Object)this.mobileNumber);
    }

    public static OtpRequestBuilder builder() {
        return new OtpRequestBuilder();
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @ConstructorProperties(value={"mobileNumber", "tenantId"})
    public OtpRequest(String mobileNumber, String tenantId) {
        this.mobileNumber = mobileNumber;
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OtpRequest)) {
            return false;
        }
        OtpRequest other = (OtpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mobileNumber = this.getMobileNumber();
        String other$mobileNumber = other.getMobileNumber();
        if (this$mobileNumber == null ? other$mobileNumber != null : !this$mobileNumber.equals(other$mobileNumber)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OtpRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mobileNumber = this.getMobileNumber();
        result = result * 59 + ($mobileNumber == null ? 43 : $mobileNumber.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        return result;
    }

    public static class OtpRequestBuilder {
        private String mobileNumber;
        private String tenantId;

        OtpRequestBuilder() {
        }

        public OtpRequestBuilder mobileNumber(String mobileNumber) {
            this.mobileNumber = mobileNumber;
            return this;
        }

        public OtpRequestBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public OtpRequest build() {
            return new OtpRequest(this.mobileNumber, this.tenantId);
        }

        public String toString() {
            return "OtpRequest.OtpRequestBuilder(mobileNumber=" + this.mobileNumber + ", tenantId=" + this.tenantId + ")";
        }
    }
}

