/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.common.repository.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.pgr.common.repository.dto.Assignment;
import org.egov.pgr.common.repository.dto.Employee;
import org.springframework.util.CollectionUtils;

public class EmployeeRes {
    @JsonProperty(value="ResponseInfo")
    private ResponseInfo responseInfo;
    @JsonProperty(value="Employee")
    private List<Employee> employees;

    public org.egov.pgr.common.model.Employee toDomain() {
        if (CollectionUtils.isEmpty(this.employees)) {
            return null;
        }
        Employee firstEmployee = this.getFirstEmployee();
        return org.egov.pgr.common.model.Employee.builder().email(firstEmployee.getEmailId()).mobileNumber(firstEmployee.getMobileNumber()).name(firstEmployee.getName()).primaryDesignation(this.getPrimaryDesignation()).primaryPosition(this.getPrimaryPosition()).build();
    }

    private Employee getFirstEmployee() {
        return this.employees.get(0);
    }

    private Long getPrimaryPosition() {
        List<Assignment> assignments = this.getAssignments();
        if (CollectionUtils.isEmpty(this.employees) || CollectionUtils.isEmpty(assignments)) {
            return null;
        }
        return assignments.stream().filter(Assignment::getIsPrimary).findFirst().map(Assignment::getPosition).orElse(null);
    }

    private List<Assignment> getAssignments() {
        return this.getFirstEmployee().getAssignments();
    }

    private Long getPrimaryDesignation() {
        List<Assignment> assignments = this.getAssignments();
        if (CollectionUtils.isEmpty(this.employees) || CollectionUtils.isEmpty(assignments)) {
            return null;
        }
        return assignments.stream().filter(Assignment::getIsPrimary).findFirst().map(Assignment::getDesignation).orElse(null);
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Employee> getEmployees() {
        return this.employees;
    }

    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    public void setEmployees(List<Employee> employees) {
        this.employees = employees;
    }

    public EmployeeRes() {
    }

    @ConstructorProperties(value={"responseInfo", "employees"})
    public EmployeeRes(ResponseInfo responseInfo, List<Employee> employees) {
        this.responseInfo = responseInfo;
        this.employees = employees;
    }
}

