/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.common.repository;

import org.egov.common.contract.request.RequestInfo;
import org.egov.pgr.common.model.Position;
import org.egov.pgr.common.repository.dto.PositionResponse;
import org.egov.pgr.common.repository.dto.RequestInfoWrapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class PositionRepository {
    private final RestTemplate restTemplate;
    private final String url;
    private static final String POSITION_BY_ID = "hr-masters/positions/_search?id={id}&tenantId={tenantId}";

    public PositionRepository(RestTemplate restTemplate, @Value(value="${hrmaster.host}") String hrMasterServiceHostname) {
        this.restTemplate = restTemplate;
        this.url = hrMasterServiceHostname + POSITION_BY_ID;
    }

    public Position getPositionById(Long id, String tenantId) {
        PositionResponse positionResponse = (PositionResponse)this.restTemplate.postForObject(this.url, (Object)this.buildRequestInfo(), PositionResponse.class, new Object[]{id, tenantId});
        return positionResponse != null ? positionResponse.toDomain() : null;
    }

    private RequestInfoWrapper buildRequestInfo() {
        RequestInfo requestInfo = RequestInfo.builder().build();
        return RequestInfoWrapper.builder().RequestInfo(requestInfo).build();
    }
}

