/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.common.repository;

import org.egov.common.contract.request.RequestInfo;
import org.egov.pgr.common.model.Employee;
import org.egov.pgr.common.repository.dto.EmployeeRes;
import org.egov.pgr.common.repository.dto.RequestInfoWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class EmployeeRepository {
    private final RestTemplate restTemplate;
    private final String url;
    private static final String EMPLOYEE_BY_POSITION = "hr-employee/employees/_search?positionId={positionId}&tenantId={tenantId}";

    @Autowired
    public EmployeeRepository(RestTemplate restTemplate, @Value(value="${hremployee.host}") String employeeServiceHostname) {
        this.restTemplate = restTemplate;
        this.url = employeeServiceHostname + EMPLOYEE_BY_POSITION;
    }

    public Employee getEmployeeByPosition(Long positionId, String tenantId) {
        RequestInfoWrapper requestBody = this.buildRequestInfo();
        EmployeeRes response = (EmployeeRes)this.restTemplate.postForObject(this.url, (Object)requestBody, EmployeeRes.class, new Object[]{positionId, tenantId});
        return response != null ? response.toDomain() : null;
    }

    private RequestInfoWrapper buildRequestInfo() {
        RequestInfo requestInfo = RequestInfo.builder().build();
        return RequestInfoWrapper.builder().RequestInfo(requestInfo).build();
    }
}

