/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.common.repository;

import org.egov.common.contract.request.RequestInfo;
import org.egov.pgr.common.model.Designation;
import org.egov.pgr.common.repository.dto.DesignationResponse;
import org.egov.pgr.common.repository.dto.RequestInfoWrapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class DesignationRepository {
    private final RestTemplate restTemplate;
    private final String url;
    private static final String DESIGNATION_BY_ID = "hr-masters/designations/_search?id={id}&tenantId={tenantId}";

    public DesignationRepository(RestTemplate restTemplate, @Value(value="${hrmaster.host}") String hrMasterServiceHostname) {
        this.restTemplate = restTemplate;
        this.url = hrMasterServiceHostname + DESIGNATION_BY_ID;
    }

    public Designation getDesignationById(Long id, String tenantId) {
        DesignationResponse designationResponse = (DesignationResponse)this.restTemplate.postForObject(this.url, (Object)this.buildRequestInfo(), DesignationResponse.class, new Object[]{id, tenantId});
        return designationResponse != null ? designationResponse.toDomain() : null;
    }

    private RequestInfoWrapper buildRequestInfo() {
        RequestInfo requestInfo = RequestInfo.builder().build();
        return RequestInfoWrapper.builder().RequestInfo(requestInfo).build();
    }
}

