/*
 * Decompiled with CFR 0.152.
 */
package com.digit.services.account;

import com.digit.config.ApiProperties;
import com.digit.exception.DigitClientException;
import com.digit.services.account.model.Tenant;
import com.digit.services.account.model.TenantConfig;
import com.digit.services.account.model.TenantConfigRequest;
import com.digit.services.account.model.TenantConfigResponse;
import com.digit.services.account.model.TenantRequest;
import com.digit.services.account.model.TenantResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class AccountClient {
    private static final Logger log = LoggerFactory.getLogger(AccountClient.class);
    private final RestTemplate restTemplate;
    private final ApiProperties apiProperties;

    public AccountClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        this.restTemplate = restTemplate;
        this.apiProperties = apiProperties;
    }

    public Tenant createTenant(Tenant tenant) {
        if (tenant == null) {
            throw new DigitClientException("Tenant cannot be null");
        }
        try {
            log.debug("Creating tenant: {}", (Object)tenant.getName());
            String url = this.apiProperties.getAccountServiceUrl() + "/account/v1";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            TenantRequest request = TenantRequest.builder().tenant(tenant).build();
            HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)entity, TenantRequest.class, new Object[0]);
            Tenant createdTenant = response.getBody() != null ? ((TenantRequest)response.getBody()).getTenant() : null;
            log.debug("Successfully created tenant: {}", (Object)(createdTenant != null ? createdTenant.getId() : "null"));
            return createdTenant;
        }
        catch (Exception e) {
            log.error("Failed to create tenant: {}", (Object)tenant.getName(), (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to create tenant: " + e.getMessage(), e);
        }
    }

    public Tenant searchTenantByCode(String code) {
        if (code == null || code.trim().isEmpty()) {
            throw new DigitClientException("Tenant code cannot be null or empty");
        }
        try {
            log.debug("Searching tenant with code: {}", (Object)code);
            String url = this.apiProperties.getAccountServiceUrl() + "/account/v1?code=" + code;
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, TenantResponse.class, new Object[0]);
            Tenant tenant = null;
            if (response.getBody() != null && ((TenantResponse)response.getBody()).getTenants() != null && !((TenantResponse)response.getBody()).getTenants().isEmpty()) {
                tenant = ((TenantResponse)response.getBody()).getTenants().get(0);
            }
            log.debug("Successfully retrieved tenant by code: {}", (Object)code);
            return tenant;
        }
        catch (Exception e) {
            log.error("Failed to retrieve tenant with code: {}", (Object)code, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to retrieve tenant by code: " + e.getMessage(), e);
        }
    }

    public Tenant updateTenant(String tenantId, Tenant tenant) {
        if (tenantId == null || tenantId.trim().isEmpty()) {
            throw new DigitClientException("Tenant ID cannot be null or empty");
        }
        if (tenant == null) {
            throw new DigitClientException("Tenant cannot be null");
        }
        try {
            log.debug("Updating tenant with ID: {}", (Object)tenantId);
            String url = this.apiProperties.getAccountServiceUrl() + "/account/v1/" + tenantId;
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            TenantRequest request = TenantRequest.builder().tenant(tenant).build();
            HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PUT, entity, TenantRequest.class, new Object[0]);
            Tenant updatedTenant = response.getBody() != null ? ((TenantRequest)response.getBody()).getTenant() : null;
            log.debug("Successfully updated tenant: {}", (Object)tenantId);
            return updatedTenant;
        }
        catch (Exception e) {
            log.error("Failed to update tenant with ID: {}", (Object)tenantId, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to update tenant: " + e.getMessage(), e);
        }
    }

    public TenantConfig createTenantConfig(TenantConfig tenantConfig) {
        if (tenantConfig == null) {
            throw new DigitClientException("TenantConfig cannot be null");
        }
        try {
            log.debug("Creating tenant config: {}", (Object)tenantConfig.getName());
            String url = this.apiProperties.getAccountServiceUrl() + "/account/v1/config";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            TenantConfigRequest request = TenantConfigRequest.builder().tenantConfig(tenantConfig).build();
            HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)entity, TenantConfigRequest.class, new Object[0]);
            TenantConfig createdConfig = response.getBody() != null ? ((TenantConfigRequest)response.getBody()).getTenantConfig() : null;
            log.debug("Successfully created tenant config: {}", (Object)(createdConfig != null ? createdConfig.getId() : "null"));
            return createdConfig;
        }
        catch (Exception e) {
            log.error("Failed to create tenant config: {}", (Object)tenantConfig.getName(), (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to create tenant config: " + e.getMessage(), e);
        }
    }

    public TenantConfig searchTenantConfigByCode(String code) {
        if (code == null || code.trim().isEmpty()) {
            throw new DigitClientException("Tenant code cannot be null or empty");
        }
        try {
            log.debug("Searching tenant config with code: {}", (Object)code);
            String url = this.apiProperties.getAccountServiceUrl() + "/account/v1/config?code=" + code;
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, TenantConfigResponse.class, new Object[0]);
            TenantConfig tenantConfig = null;
            if (response.getBody() != null && ((TenantConfigResponse)response.getBody()).getTenantConfigs() != null && !((TenantConfigResponse)response.getBody()).getTenantConfigs().isEmpty()) {
                tenantConfig = ((TenantConfigResponse)response.getBody()).getTenantConfigs().get(0);
            }
            log.debug("Successfully retrieved tenant config by code: {}", (Object)code);
            return tenantConfig;
        }
        catch (Exception e) {
            log.error("Failed to retrieve tenant config with code: {}", (Object)code, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to retrieve tenant config by code: " + e.getMessage(), e);
        }
    }

    public TenantConfig updateTenantConfig(String configId, TenantConfig tenantConfig) {
        if (configId == null || configId.trim().isEmpty()) {
            throw new DigitClientException("Config ID cannot be null or empty");
        }
        if (tenantConfig == null) {
            throw new DigitClientException("TenantConfig cannot be null");
        }
        try {
            log.debug("Updating tenant config with ID: {}", (Object)configId);
            String url = this.apiProperties.getAccountServiceUrl() + "/account/v1/config/" + configId;
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            TenantConfigRequest request = TenantConfigRequest.builder().tenantConfig(tenantConfig).build();
            HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PUT, entity, TenantConfigRequest.class, new Object[0]);
            TenantConfig updatedConfig = response.getBody() != null ? ((TenantConfigRequest)response.getBody()).getTenantConfig() : null;
            log.debug("Successfully updated tenant config: {}", (Object)configId);
            return updatedConfig;
        }
        catch (Exception e) {
            log.error("Failed to update tenant config with ID: {}", (Object)configId, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to update tenant config: " + e.getMessage(), e);
        }
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ApiProperties getApiProperties() {
        return this.apiProperties;
    }
}

