/*
 * Decompiled with CFR 0.152.
 */
package com.digit.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="digit.opentelemetry")
public class OpenTelemetryProperties {
    private boolean enabled = false;
    private String serviceName = "digit-client";
    private String endpoint = "http://localhost:4317";
    private double samplingRatio = 1.0;
    private boolean detailedLogging = false;
    private long exportTimeout = 30000L;
    private int batchSize = 512;

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public double getSamplingRatio() {
        return this.samplingRatio;
    }

    public boolean isDetailedLogging() {
        return this.detailedLogging;
    }

    public long getExportTimeout() {
        return this.exportTimeout;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setSamplingRatio(double samplingRatio) {
        this.samplingRatio = samplingRatio;
    }

    public void setDetailedLogging(boolean detailedLogging) {
        this.detailedLogging = detailedLogging;
    }

    public void setExportTimeout(long exportTimeout) {
        this.exportTimeout = exportTimeout;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenTelemetryProperties)) {
            return false;
        }
        OpenTelemetryProperties other = (OpenTelemetryProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (Double.compare(this.getSamplingRatio(), other.getSamplingRatio()) != 0) {
            return false;
        }
        if (this.isDetailedLogging() != other.isDetailedLogging()) {
            return false;
        }
        if (this.getExportTimeout() != other.getExportTimeout()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        return !(this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenTelemetryProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $samplingRatio = Double.doubleToLongBits(this.getSamplingRatio());
        result = result * 59 + (int)($samplingRatio >>> 32 ^ $samplingRatio);
        result = result * 59 + (this.isDetailedLogging() ? 79 : 97);
        long $exportTimeout = this.getExportTimeout();
        result = result * 59 + (int)($exportTimeout >>> 32 ^ $exportTimeout);
        result = result * 59 + this.getBatchSize();
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        return result;
    }

    public String toString() {
        return "OpenTelemetryProperties(enabled=" + this.isEnabled() + ", serviceName=" + this.getServiceName() + ", endpoint=" + this.getEndpoint() + ", samplingRatio=" + this.getSamplingRatio() + ", detailedLogging=" + this.isDetailedLogging() + ", exportTimeout=" + this.getExportTimeout() + ", batchSize=" + this.getBatchSize() + ")";
    }
}

