/*
 * Decompiled with CFR 0.152.
 */
package org.digit.services.registry;

import java.util.List;
import java.util.Map;
import org.digit.config.ApiProperties;
import org.digit.exception.DigitClientException;
import org.digit.services.registry.model.RegistryData;
import org.digit.services.registry.model.RegistryDataResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RegistryClient {
    private static final Logger log = LoggerFactory.getLogger(RegistryClient.class);
    private final RestTemplate restTemplate;
    private final ApiProperties apiProperties;

    public RegistryClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        this.restTemplate = restTemplate;
        this.apiProperties = apiProperties;
    }

    public RegistryDataResponse createRegistryData(String schemaCode, RegistryData registryData) {
        if (registryData == null) {
            throw new DigitClientException("Registry data cannot be null");
        }
        if (schemaCode == null || schemaCode.trim().isEmpty()) {
            throw new DigitClientException("Schema code cannot be null or empty");
        }
        if (registryData.getData() == null) {
            throw new DigitClientException("Data cannot be null");
        }
        try {
            log.debug("Creating registry data with schema code: {}", (Object)schemaCode);
            String url = this.apiProperties.getRegistryServiceUrl() + "/registry/v1/schema/" + schemaCode + "/data";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            HttpEntity entity = new HttpEntity((Object)registryData, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)entity, RegistryDataResponse.class, new Object[0]);
            log.debug("Successfully created registry data with schema code: {}", (Object)schemaCode);
            return (RegistryDataResponse)response.getBody();
        }
        catch (Exception e) {
            log.error("Failed to create registry data with schema code: {}", (Object)schemaCode, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to create registry data: " + e.getMessage(), e);
        }
    }

    public RegistryDataResponse searchRegistryData(String schemaCode, String registryId, boolean history) {
        if (schemaCode == null || schemaCode.trim().isEmpty()) {
            throw new DigitClientException("Schema code cannot be null or empty");
        }
        if (registryId == null || registryId.trim().isEmpty()) {
            throw new DigitClientException("Registry ID cannot be null or empty");
        }
        try {
            log.debug("Searching registry data with schema code: {}, registry ID: {}, and history: {}", new Object[]{schemaCode, registryId, history});
            String url = this.apiProperties.getRegistryServiceUrl() + "/registry/v1/schema/" + schemaCode + "/data/_registry?registryId=" + registryId + "&history=" + history;
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, RegistryDataResponse.class, new Object[0]);
            log.debug("Successfully retrieved registry data with schema code: {}, registry ID: {}, and history: {}", new Object[]{schemaCode, registryId, history});
            return (RegistryDataResponse)response.getBody();
        }
        catch (Exception e) {
            log.error("Failed to retrieve registry data with schema code: {}, registry ID: {}, and history: {}", new Object[]{schemaCode, registryId, history, e});
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to retrieve registry data: " + e.getMessage(), e);
        }
    }

    public RegistryDataResponse searchRegistryData(String schemaCode, String registryId) {
        return this.searchRegistryData(schemaCode, registryId, false);
    }

    public RegistryDataResponse searchRegistryData(String schemaCode, String key, String value) {
        return this.searchRegistryData(schemaCode, key, value, null, null);
    }

    public RegistryDataResponse searchRegistryData(String schemaCode, String key, String value, Integer limit, Integer offset) {
        if (schemaCode == null || schemaCode.trim().isEmpty()) {
            throw new DigitClientException("Schema code cannot be null or empty");
        }
        if (key == null || key.trim().isEmpty()) {
            throw new DigitClientException("Search key cannot be null or empty");
        }
        if (value == null || value.trim().isEmpty()) {
            throw new DigitClientException("Search value cannot be null or empty");
        }
        try {
            int actualLimit = limit != null ? limit : 5;
            int actualOffset = offset != null ? offset : 0;
            log.debug("Searching registry data with schema code: {}, key: {}, value: {}, limit: {}, offset: {}", new Object[]{schemaCode, key, value, actualLimit, actualOffset});
            String url = this.apiProperties.getRegistryServiceUrl() + "/registry/v1/schema/" + schemaCode + "/data/_search?limit=" + actualLimit + "&offset=" + actualOffset;
            Map<String, Map<String, String>> searchRequest = Map.of("contains", Map.of(key, value));
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            HttpEntity entity = new HttpEntity(searchRequest, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, RegistryDataResponse.class, new Object[0]);
            log.debug("Successfully searched registry data with schema code: {}, key: {}, value: {}", new Object[]{schemaCode, key, value});
            return (RegistryDataResponse)response.getBody();
        }
        catch (Exception e) {
            log.error("Failed to search registry data with schema code: {}, key: {}, value: {}", new Object[]{schemaCode, key, value, e});
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to search registry data: " + e.getMessage(), e);
        }
    }

    public RegistryDataResponse updateRegistryData(String schemaCode, RegistryData registryData, String key, String value) {
        if (schemaCode == null || schemaCode.trim().isEmpty()) {
            throw new DigitClientException("Schema code cannot be null or empty");
        }
        if (registryData == null) {
            throw new DigitClientException("Registry data cannot be null");
        }
        if (key == null || key.trim().isEmpty()) {
            throw new DigitClientException("Search key cannot be null or empty");
        }
        if (value == null || value.trim().isEmpty()) {
            throw new DigitClientException("Search value cannot be null or empty");
        }
        if (registryData.getData() == null) {
            throw new DigitClientException("Data cannot be null");
        }
        try {
            log.debug("Updating registry data with schema code: {}, key: {}, and value: {}", new Object[]{schemaCode, key, value});
            RegistryDataResponse searchResponse = this.searchRegistryData(schemaCode, key, value);
            if (searchResponse == null || searchResponse.getData() == null) {
                throw new DigitClientException("Registry data not found for key: " + key + " and value: " + value);
            }
            Integer currentVersion = this.extractVersionFromResponse(searchResponse);
            if (currentVersion == null) {
                throw new DigitClientException("Could not extract version from existing registry data");
            }
            String registryId = this.extractRegistryIdFromResponse(searchResponse);
            if (registryId == null || registryId.trim().isEmpty()) {
                throw new DigitClientException("Could not extract registry ID from existing registry data");
            }
            registryData.setVersion(currentVersion);
            String url = this.apiProperties.getRegistryServiceUrl() + "/registry/v1/schema/" + schemaCode + "/data?id=" + registryId;
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            HttpEntity entity = new HttpEntity((Object)registryData, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PUT, entity, RegistryDataResponse.class, new Object[0]);
            log.debug("Successfully updated registry data with schema code: {}, key: {}, and value: {}", new Object[]{schemaCode, key, value});
            return (RegistryDataResponse)response.getBody();
        }
        catch (Exception e) {
            log.error("Failed to update registry data with schema code: {}, key: {}, and value: {}", new Object[]{schemaCode, key, value, e});
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to update registry data: " + e.getMessage(), e);
        }
    }

    private Integer extractVersionFromResponse(RegistryDataResponse response) {
        try {
            List dataList;
            if (response.getData() instanceof Map) {
                Map dataMap = (Map)response.getData();
                Object versionObj = dataMap.get("version");
                if (versionObj instanceof Integer) {
                    return (Integer)versionObj;
                }
                if (versionObj instanceof Number) {
                    return ((Number)versionObj).intValue();
                }
            } else if (response.getData() instanceof List && !(dataList = (List)response.getData()).isEmpty()) {
                Map firstItem = (Map)dataList.get(0);
                Object versionObj = firstItem.get("version");
                if (versionObj instanceof Integer) {
                    return (Integer)versionObj;
                }
                if (versionObj instanceof Number) {
                    return ((Number)versionObj).intValue();
                }
            }
            return null;
        }
        catch (Exception e) {
            log.warn("Error extracting version from response: {}", (Object)e.getMessage());
            return null;
        }
    }

    private String extractRegistryIdFromResponse(RegistryDataResponse response) {
        try {
            List dataList;
            if (response.getData() instanceof Map) {
                Map dataMap = (Map)response.getData();
                Object registryIdObj = dataMap.get("registryId");
                if (registryIdObj instanceof String) {
                    return (String)registryIdObj;
                }
                if (registryIdObj != null) {
                    return registryIdObj.toString();
                }
            } else if (response.getData() instanceof List && !(dataList = (List)response.getData()).isEmpty()) {
                Map firstItem = (Map)dataList.get(0);
                Object registryIdObj = firstItem.get("registryId");
                if (registryIdObj instanceof String) {
                    return (String)registryIdObj;
                }
                if (registryIdObj != null) {
                    return registryIdObj.toString();
                }
            }
            return null;
        }
        catch (Exception e) {
            log.warn("Error extracting registry ID from response: {}", (Object)e.getMessage());
            return null;
        }
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ApiProperties getApiProperties() {
        return this.apiProperties;
    }
}

