/*
 * Decompiled with CFR 0.152.
 */
package org.digit.services.mdms;

import java.util.List;
import java.util.Set;
import org.digit.config.ApiProperties;
import org.digit.exception.DigitClientException;
import org.digit.services.mdms.model.Mdms;
import org.digit.services.mdms.model.MdmsResponseV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class MdmsClient {
    private static final Logger log = LoggerFactory.getLogger(MdmsClient.class);
    private final RestTemplate restTemplate;
    private final ApiProperties apiProperties;

    public MdmsClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        this.restTemplate = restTemplate;
        this.apiProperties = apiProperties;
        System.out.println("\ud83d\udd0d MdmsClient created with RestTemplate: " + restTemplate.getClass().getSimpleName());
        System.out.println("\ud83d\udd0d RestTemplate interceptors: " + restTemplate.getInterceptors().size());
        restTemplate.getInterceptors().forEach(interceptor -> System.out.println("  - " + interceptor.getClass().getSimpleName()));
    }

    public boolean isMdmsDataValid(String schemaCode, Set<String> uniqueIdentifiers) {
        if (schemaCode == null || schemaCode.trim().isEmpty()) {
            throw new DigitClientException("Schema code cannot be null or empty");
        }
        if (uniqueIdentifiers == null || uniqueIdentifiers.isEmpty()) {
            throw new DigitClientException("Unique identifiers set cannot be null or empty");
        }
        try {
            log.debug("Validating MDMS data for schemaCode: {}, uniqueIdentifiers: {} (tenant from X-Tenant-ID header)", (Object)schemaCode, uniqueIdentifiers);
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.apiProperties.getMdmsServiceUrl() + "/mdms-v2/v2")).queryParam("schemaCode", new Object[]{schemaCode});
            for (String uniqueIdentifier : uniqueIdentifiers) {
                uriBuilder.queryParam("uniqueIdentifiers", new Object[]{uniqueIdentifier});
            }
            String url = uriBuilder.toUriString();
            log.debug("MDMS validation URL: {}", (Object)url);
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, MdmsResponseV2.class, new Object[0]);
            List<Mdms> mdmsList = response.getBody() != null ? ((MdmsResponseV2)response.getBody()).getMdms() : null;
            int foundCount = mdmsList != null ? mdmsList.size() : 0;
            boolean allValid = foundCount == uniqueIdentifiers.size();
            log.debug("MDMS validation result: {} ({} out of {} found)", new Object[]{allValid ? "valid" : "invalid", foundCount, uniqueIdentifiers.size()});
            if (log.isDebugEnabled() && mdmsList != null) {
                log.debug("Found MDMS entries:");
                mdmsList.forEach(mdms -> log.debug("  - ID: {}, UniqueIdentifier: {}", (Object)mdms.getId(), (Object)mdms.getUniqueIdentifier()));
            }
            return allValid;
        }
        catch (Exception e) {
            log.error("Failed to validate MDMS data for schemaCode: {}, uniqueIdentifiers: {} (tenant from X-Tenant-ID header)", new Object[]{schemaCode, uniqueIdentifiers, e});
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to validate MDMS data: " + e.getMessage(), e);
        }
    }

    public List<Mdms> searchMdmsData(String schemaCode, Set<String> uniqueIdentifiers) {
        if (schemaCode == null || schemaCode.trim().isEmpty()) {
            throw new DigitClientException("Schema code cannot be null or empty");
        }
        if (uniqueIdentifiers == null || uniqueIdentifiers.isEmpty()) {
            throw new DigitClientException("Unique identifiers set cannot be null or empty");
        }
        try {
            HttpHeaders headers;
            HttpEntity entity;
            log.debug("Searching MDMS data for schemaCode: {}, uniqueIdentifiers: {} (tenant from X-Tenant-ID header)", (Object)schemaCode, uniqueIdentifiers);
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.apiProperties.getMdmsServiceUrl() + "/mdms-v2/v2")).queryParam("schemaCode", new Object[]{schemaCode});
            for (String uniqueIdentifier : uniqueIdentifiers) {
                uriBuilder.queryParam("uniqueIdentifiers", new Object[]{uniqueIdentifier});
            }
            String url = uriBuilder.toUriString();
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity = new HttpEntity((MultiValueMap)(headers = new HttpHeaders())), MdmsResponseV2.class, new Object[0]);
            List<Mdms> mdmsList = response.getBody() != null ? ((MdmsResponseV2)response.getBody()).getMdms() : null;
            log.debug("Successfully retrieved {} MDMS entries", (Object)(mdmsList != null ? mdmsList.size() : 0));
            return mdmsList;
        }
        catch (Exception e) {
            log.error("Failed to search MDMS data for schemaCode: {}, uniqueIdentifiers: {} (tenant from X-Tenant-ID header)", new Object[]{schemaCode, uniqueIdentifiers, e});
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to search MDMS data: " + e.getMessage(), e);
        }
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ApiProperties getApiProperties() {
        return this.apiProperties;
    }
}

