/*
 * Decompiled with CFR 0.152.
 */
package org.digit.example;

import org.digit.config.ApiConfig;
import org.digit.exception.DigitClientException;
import org.digit.services.account.AccountClient;
import org.digit.services.account.model.Tenant;
import org.digit.services.boundary.BoundaryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class DigitClientExample {
    private static final Logger log = LoggerFactory.getLogger(DigitClientExample.class);

    public static void main(String[] args) {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{ApiConfig.class});
        AccountClient accountClient = (AccountClient)context.getBean(AccountClient.class);
        BoundaryClient boundaryClient = (BoundaryClient)context.getBean(BoundaryClient.class);
        DigitClientExample.demonstrateTenantOperations(accountClient);
        DigitClientExample.demonstrateBoundaryOperations(boundaryClient);
        context.close();
    }

    private static void demonstrateTenantOperations(AccountClient accountClient) {
        log.info("=== Tenant Client Examples ===");
        try {
            log.info("1. Getting tenant by ID...");
            Tenant foundTenant = accountClient.searchTenantByCode("TENANT001");
            log.info("Retrieved tenant: {}", (Object)(foundTenant != null ? foundTenant.getName() : "null"));
        }
        catch (DigitClientException e) {
            log.error("Failed to get tenant by ID: {}", (Object)e.getMessage());
        }
        try {
            log.info("2. Getting all tenants...");
            log.info("Search all tenants operation would be implemented here");
        }
        catch (DigitClientException e) {
            log.error("Failed to get all tenants: {}", (Object)e.getMessage());
        }
        try {
            log.info("3. Getting tenant by code...");
            Tenant tenantByCode = accountClient.searchTenantByCode("TN001");
            log.info("Retrieved tenant by code: {}", (Object)(tenantByCode != null ? tenantByCode.getName() : "null"));
        }
        catch (DigitClientException e) {
            log.error("Failed to get tenant by code: {}", (Object)e.getMessage());
        }
        try {
            log.info("4. Creating new tenant...");
            Tenant newTenant = Tenant.builder().code("TN002").name("Test Tenant").build();
            Tenant createdTenant = accountClient.createTenant(newTenant);
            log.info("Created tenant: {}", (Object)(createdTenant != null ? createdTenant.getName() : "null"));
        }
        catch (DigitClientException e) {
            log.error("Failed to create tenant: {}", (Object)e.getMessage());
        }
    }

    private static void demonstrateBoundaryOperations(BoundaryClient boundaryClient) {
        log.info("=== Boundary Client Examples ===");
        try {
            log.info("1. Getting boundary by code...");
            log.info("Boundary operations would be implemented here");
        }
        catch (DigitClientException e) {
            log.error("Failed to get boundary by code: {}", (Object)e.getMessage());
        }
        try {
            log.info("2. Getting boundary by ID...");
            log.info("Boundary search operations would be implemented here");
        }
        catch (DigitClientException e) {
            log.error("Failed to get boundary by ID: {}", (Object)e.getMessage());
        }
        try {
            log.info("3. Getting all boundaries...");
            log.info("All boundaries operation would be implemented here");
        }
        catch (DigitClientException e) {
            log.error("Failed to get all boundaries: {}", (Object)e.getMessage());
        }
        try {
            log.info("4. Getting boundaries by tenant ID...");
            log.info("Boundaries by tenant operation would be implemented here");
        }
        catch (DigitClientException e) {
            log.error("Failed to get boundaries by tenant: {}", (Object)e.getMessage());
        }
        try {
            log.info("5. Getting boundaries by type...");
            log.info("Boundaries by type operation would be implemented here");
        }
        catch (DigitClientException e) {
            log.error("Failed to get boundaries by type: {}", (Object)e.getMessage());
        }
    }
}

