/*
 * Decompiled with CFR 0.152.
 */
package org.digit.services.boundary;

import java.util.List;
import org.digit.config.ApiProperties;
import org.digit.exception.DigitClientException;
import org.digit.services.boundary.model.Boundary;
import org.digit.services.boundary.model.BoundaryHierarchy;
import org.digit.services.boundary.model.BoundaryHierarchyRequest;
import org.digit.services.boundary.model.BoundaryHierarchyResponse;
import org.digit.services.boundary.model.BoundaryRelationship;
import org.digit.services.boundary.model.BoundaryRelationshipRequest;
import org.digit.services.boundary.model.BoundaryRelationshipResponse;
import org.digit.services.boundary.model.BoundaryRequest;
import org.digit.services.boundary.model.BoundaryResponse;
import org.digit.services.boundary.model.BoundarySearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class BoundaryClient {
    private static final Logger log = LoggerFactory.getLogger(BoundaryClient.class);
    private final RestTemplate restTemplate;
    private final ApiProperties apiProperties;

    public BoundaryClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        this.restTemplate = restTemplate;
        this.apiProperties = apiProperties;
        System.out.println("\ud83d\udd0d BoundaryClient created with RestTemplate: " + restTemplate.getClass().getSimpleName());
        System.out.println("\ud83d\udd0d RestTemplate interceptors: " + restTemplate.getInterceptors().size());
        restTemplate.getInterceptors().forEach(interceptor -> System.out.println("  - " + interceptor.getClass().getSimpleName()));
    }

    public List<Boundary> createBoundaries(List<Boundary> boundaries) {
        if (boundaries == null || boundaries.isEmpty()) {
            throw new DigitClientException("Boundaries list cannot be null or empty");
        }
        try {
            log.debug("Creating {} boundaries", (Object)boundaries.size());
            String url = this.apiProperties.getBoundaryServiceUrl() + "/boundary/v1";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            BoundaryRequest request = BoundaryRequest.builder().boundary(boundaries).build();
            HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, BoundaryResponse.class, new Object[0]);
            List<Boundary> createdBoundaries = response.getBody() != null ? ((BoundaryResponse)response.getBody()).getBoundary() : null;
            log.debug("Successfully created {} boundaries", (Object)(createdBoundaries != null ? createdBoundaries.size() : 0));
            return createdBoundaries;
        }
        catch (Exception e) {
            log.error("Failed to create boundaries", (Throwable)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to create boundaries: " + e.getMessage(), e);
        }
    }

    public List<Boundary> searchBoundariesByCodes(List<String> codes) {
        if (codes == null || codes.isEmpty()) {
            throw new DigitClientException("Codes list cannot be null or empty");
        }
        try {
            HttpHeaders headers;
            HttpEntity entity;
            log.debug("Searching boundaries with codes: {}", codes);
            StringBuilder urlBuilder = new StringBuilder(this.apiProperties.getBoundaryServiceUrl() + "/boundary/v1?");
            for (String code : codes) {
                urlBuilder.append("codes=").append(code).append("&");
            }
            String url = urlBuilder.toString().replaceAll("&$", "");
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity = new HttpEntity((MultiValueMap)(headers = new HttpHeaders())), BoundaryResponse.class, new Object[0]);
            List<Boundary> boundaries = response.getBody() != null ? ((BoundaryResponse)response.getBody()).getBoundary() : null;
            log.debug("Successfully retrieved {} boundaries", (Object)(boundaries != null ? boundaries.size() : 0));
            return boundaries;
        }
        catch (Exception e) {
            log.error("Failed to search boundaries with codes: {}", codes, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to search boundaries: " + e.getMessage(), e);
        }
    }

    public boolean isValidBoundariesByCodes(List<String> codes) {
        if (codes == null || codes.isEmpty()) {
            throw new DigitClientException("Codes list cannot be null or empty");
        }
        try {
            HttpHeaders headers;
            HttpEntity entity;
            log.debug("Validating boundaries with codes: {}", codes);
            StringBuilder urlBuilder = new StringBuilder(this.apiProperties.getBoundaryServiceUrl()).append("/boundary/v1?");
            for (String code : codes) {
                urlBuilder.append("codes=").append(code).append("&");
            }
            String url = urlBuilder.toString().replaceAll("&$", "");
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity = new HttpEntity((MultiValueMap)(headers = new HttpHeaders())), BoundaryResponse.class, new Object[0]);
            List<Boundary> boundaries = response.getBody() != null ? ((BoundaryResponse)response.getBody()).getBoundary() : null;
            int validCount = boundaries != null ? boundaries.size() : 0;
            boolean allValid = validCount == codes.size();
            log.debug("Boundary validation result: {} ({} out of {} found)", new Object[]{allValid ? "valid" : "invalid", validCount, codes.size()});
            return allValid;
        }
        catch (Exception e) {
            log.error("Failed to validate boundaries with codes: {}", codes, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to validate boundaries: " + e.getMessage(), e);
        }
    }

    public Boundary updateBoundary(String boundaryId, Boundary boundary) {
        if (boundaryId == null || boundaryId.trim().isEmpty()) {
            throw new DigitClientException("Boundary ID cannot be null or empty");
        }
        if (boundary == null) {
            throw new DigitClientException("Boundary cannot be null");
        }
        try {
            log.debug("Updating boundary with ID: {}", (Object)boundaryId);
            String url = this.apiProperties.getBoundaryServiceUrl() + "/boundary/v1/" + boundaryId;
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            BoundaryRequest request = BoundaryRequest.builder().boundary(List.of(boundary)).build();
            HttpEntity requestEntity = new HttpEntity((Object)request, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PUT, requestEntity, BoundaryResponse.class, new Object[0]);
            Boundary updatedBoundary = null;
            if (response.getBody() != null && ((BoundaryResponse)response.getBody()).getBoundary() != null && !((BoundaryResponse)response.getBody()).getBoundary().isEmpty()) {
                updatedBoundary = ((BoundaryResponse)response.getBody()).getBoundary().get(0);
            }
            log.debug("Successfully updated boundary: {}", (Object)boundaryId);
            return updatedBoundary;
        }
        catch (Exception e) {
            log.error("Failed to update boundary with ID: {}", (Object)boundaryId, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to update boundary: " + e.getMessage(), e);
        }
    }

    public BoundaryHierarchy createBoundaryHierarchy(BoundaryHierarchy boundaryHierarchy) {
        if (boundaryHierarchy == null) {
            throw new DigitClientException("BoundaryHierarchy cannot be null");
        }
        try {
            log.debug("Creating boundary hierarchy: {}", (Object)boundaryHierarchy.getHierarchyType());
            String url = this.apiProperties.getBoundaryServiceUrl() + "/boundary/v1/boundary-hierarchy-definition";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            BoundaryHierarchyRequest request = BoundaryHierarchyRequest.builder().hierarchy(boundaryHierarchy).build();
            HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)entity, BoundaryHierarchyResponse.class, new Object[0]);
            BoundaryHierarchy createdHierarchy = response.getBody() != null ? ((BoundaryHierarchyResponse)response.getBody()).getHierarchy() : null;
            log.debug("Successfully created boundary hierarchy: {}", (Object)(createdHierarchy != null ? createdHierarchy.getId() : "null"));
            return createdHierarchy;
        }
        catch (Exception e) {
            log.error("Failed to create boundary hierarchy: {}", (Object)boundaryHierarchy.getHierarchyType(), (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to create boundary hierarchy: " + e.getMessage(), e);
        }
    }

    public BoundaryHierarchy searchBoundaryHierarchy(String hierarchyType) {
        if (hierarchyType == null || hierarchyType.trim().isEmpty()) {
            throw new DigitClientException("Hierarchy type cannot be null or empty");
        }
        try {
            log.debug("Searching boundary hierarchy with type: {}", (Object)hierarchyType);
            String url = this.apiProperties.getBoundaryServiceUrl() + "/boundary/v1/boundary-hierarchy-definition?hierarchyType=" + hierarchyType;
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, BoundaryHierarchyResponse.class, new Object[0]);
            BoundaryHierarchy hierarchy = response.getBody() != null ? ((BoundaryHierarchyResponse)response.getBody()).getHierarchy() : null;
            log.debug("Successfully retrieved boundary hierarchy: {}", (Object)hierarchyType);
            return hierarchy;
        }
        catch (Exception e) {
            log.error("Failed to search boundary hierarchy with type: {}", (Object)hierarchyType, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to search boundary hierarchy: " + e.getMessage(), e);
        }
    }

    public BoundaryRelationship createBoundaryRelationship(BoundaryRelationship boundaryRelationship) {
        if (boundaryRelationship == null) {
            throw new DigitClientException("BoundaryRelationship cannot be null");
        }
        try {
            log.debug("Creating boundary relationship: {}", (Object)boundaryRelationship.getCode());
            String url = this.apiProperties.getBoundaryServiceUrl() + "/boundary/v1/boundary-relationships";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            BoundaryRelationshipRequest request = BoundaryRelationshipRequest.builder().relationship(List.of(boundaryRelationship)).build();
            HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)entity, BoundaryRelationshipResponse.class, new Object[0]);
            BoundaryRelationship createdRelationship = null;
            if (response.getBody() != null && ((BoundaryRelationshipResponse)response.getBody()).getRelationship() != null && !((BoundaryRelationshipResponse)response.getBody()).getRelationship().isEmpty()) {
                createdRelationship = ((BoundaryRelationshipResponse)response.getBody()).getRelationship().get(0);
            }
            log.debug("Successfully created boundary relationship: {}", (Object)(createdRelationship != null ? createdRelationship.getId() : "null"));
            return createdRelationship;
        }
        catch (Exception e) {
            log.error("Failed to create boundary relationship: {}", (Object)boundaryRelationship.getCode(), (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to create boundary relationship: " + e.getMessage(), e);
        }
    }

    public List<BoundarySearchResponse.HierarchyRelation> searchBoundaryRelationships(String hierarchyType, String boundaryType, boolean includeChildren) {
        if (hierarchyType == null || hierarchyType.trim().isEmpty()) {
            throw new DigitClientException("Hierarchy type cannot be null or empty");
        }
        try {
            log.debug("Searching boundary relationships with hierarchy type: {}", (Object)hierarchyType);
            StringBuilder urlBuilder = new StringBuilder(this.apiProperties.getBoundaryServiceUrl() + "/boundary/v1/boundary-relationships?");
            urlBuilder.append("hierarchyType=").append(hierarchyType);
            if (boundaryType != null && !boundaryType.trim().isEmpty()) {
                urlBuilder.append("&boundaryType=").append(boundaryType);
            }
            urlBuilder.append("&includeChildren=").append(includeChildren);
            String url = urlBuilder.toString();
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, BoundarySearchResponse.class, new Object[0]);
            List<BoundarySearchResponse.HierarchyRelation> relationships = response.getBody() != null ? ((BoundarySearchResponse)response.getBody()).getTenantBoundary() : null;
            log.debug("Successfully retrieved {} boundary relationships", (Object)(relationships != null ? relationships.size() : 0));
            return relationships;
        }
        catch (Exception e) {
            log.error("Failed to search boundary relationships with hierarchy type: {}", (Object)hierarchyType, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to search boundary relationships: " + e.getMessage(), e);
        }
    }

    public BoundaryRelationship updateBoundaryRelationship(String relationshipId, BoundaryRelationship boundaryRelationship) {
        if (relationshipId == null || relationshipId.trim().isEmpty()) {
            throw new DigitClientException("Relationship ID cannot be null or empty");
        }
        if (boundaryRelationship == null) {
            throw new DigitClientException("BoundaryRelationship cannot be null");
        }
        try {
            log.debug("Updating boundary relationship with ID: {}", (Object)relationshipId);
            String url = this.apiProperties.getBoundaryServiceUrl() + "/boundary/v1/boundary-relationships/" + relationshipId;
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            HttpEntity entity = new HttpEntity((Object)boundaryRelationship, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PUT, entity, BoundaryRelationship.class, new Object[0]);
            BoundaryRelationship updatedRelationship = (BoundaryRelationship)response.getBody();
            log.debug("Successfully updated boundary relationship: {}", (Object)relationshipId);
            return updatedRelationship;
        }
        catch (Exception e) {
            log.error("Failed to update boundary relationship with ID: {}", (Object)relationshipId, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to update boundary relationship: " + e.getMessage(), e);
        }
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ApiProperties getApiProperties() {
        return this.apiProperties;
    }
}

