/*
 * Decompiled with CFR 0.152.
 */
package org.digit.factory;

import java.lang.reflect.Field;
import org.digit.config.ApiProperties;
import org.digit.exception.DigitClientErrorHandler;
import org.digit.services.account.AccountClient;
import org.digit.services.boundary.BoundaryClient;
import org.digit.services.filestore.FilestoreClient;
import org.digit.services.idgen.IdGenClient;
import org.digit.services.individual.IndividualClient;
import org.digit.services.mdms.MdmsClient;
import org.digit.services.notification.NotificationClient;
import org.digit.services.registry.RegistryClient;
import org.digit.services.workflow.WorkflowClient;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class DigitClientFactory {
    public static BoundaryClient createBoundaryClient() {
        return DigitClientFactory.createBoundaryClient("http://localhost:8080");
    }

    public static BoundaryClient createBoundaryClient(String baseUrl) {
        if (baseUrl == null || baseUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("Boundary service base URL cannot be null or empty");
        }
        RestTemplate restTemplate = DigitClientFactory.createRestTemplate();
        ApiProperties apiProperties = DigitClientFactory.createApiProperties(null, baseUrl, null, null);
        return new BoundaryClient(restTemplate, apiProperties);
    }

    public static AccountClient createAccountClient() {
        return DigitClientFactory.createAccountClient("http://localhost:8080");
    }

    public static AccountClient createAccountClient(String baseUrl) {
        if (baseUrl == null || baseUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("Account service base URL cannot be null or empty");
        }
        RestTemplate restTemplate = DigitClientFactory.createRestTemplate();
        ApiProperties apiProperties = DigitClientFactory.createApiProperties(baseUrl, null, null, null);
        return new AccountClient(restTemplate, apiProperties);
    }

    public static WorkflowClient createWorkflowClient() {
        return DigitClientFactory.createWorkflowClient("http://localhost:8080");
    }

    public static WorkflowClient createWorkflowClient(String baseUrl) {
        if (baseUrl == null || baseUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("Workflow service base URL cannot be null or empty");
        }
        RestTemplate restTemplate = DigitClientFactory.createRestTemplate();
        ApiProperties apiProperties = DigitClientFactory.createApiProperties(null, null, baseUrl, null);
        return new WorkflowClient(restTemplate, apiProperties);
    }

    public static IdGenClient createIdGenClient() {
        return DigitClientFactory.createIdGenClient("http://localhost:8100");
    }

    public static IdGenClient createIdGenClient(String baseUrl) {
        ApiProperties apiProperties = new ApiProperties();
        apiProperties.setIdgenServiceUrl(baseUrl);
        RestTemplate restTemplate = DigitClientFactory.createRestTemplate();
        return new IdGenClient(restTemplate, apiProperties);
    }

    public static NotificationClient createNotificationClient() {
        return DigitClientFactory.createNotificationClient("http://localhost:8091");
    }

    public static NotificationClient createNotificationClient(String baseUrl) {
        ApiProperties apiProperties = new ApiProperties();
        apiProperties.setNotificationServiceUrl(baseUrl);
        RestTemplate restTemplate = DigitClientFactory.createRestTemplate();
        return new NotificationClient(restTemplate, apiProperties);
    }

    public static IndividualClient createIndividualClient() {
        return DigitClientFactory.createIndividualClient("http://localhost:8999");
    }

    public static IndividualClient createIndividualClient(String baseUrl) {
        ApiProperties apiProperties = new ApiProperties();
        apiProperties.setIndividualServiceUrl(baseUrl);
        RestTemplate restTemplate = DigitClientFactory.createRestTemplate();
        return new IndividualClient(restTemplate, apiProperties);
    }

    public static FilestoreClient createFilestoreClient() {
        return DigitClientFactory.createFilestoreClient("http://localhost:8080");
    }

    public static FilestoreClient createFilestoreClient(String baseUrl) {
        ApiProperties apiProperties = new ApiProperties();
        apiProperties.setFilestoreServiceUrl(baseUrl);
        RestTemplate restTemplate = DigitClientFactory.createRestTemplate();
        return new FilestoreClient(restTemplate, apiProperties);
    }

    public static MdmsClient createMdmsClient() {
        return DigitClientFactory.createMdmsClient("http://localhost:8080");
    }

    public static MdmsClient createMdmsClient(String baseUrl) {
        ApiProperties apiProperties = new ApiProperties();
        apiProperties.setMdmsServiceUrl(baseUrl);
        RestTemplate restTemplate = DigitClientFactory.createRestTemplate();
        return new MdmsClient(restTemplate, apiProperties);
    }

    public static RegistryClient createRegistryClient() {
        return DigitClientFactory.createRegistryClient("http://localhost:8085");
    }

    public static RegistryClient createRegistryClient(String baseUrl) {
        ApiProperties apiProperties = new ApiProperties();
        apiProperties.setRegistryServiceUrl(baseUrl);
        RestTemplate restTemplate = DigitClientFactory.createRestTemplate();
        return new RegistryClient(restTemplate, apiProperties);
    }

    public static DigitClients createClients() {
        return DigitClientFactory.createClients("http://localhost:8080", "http://localhost:8080");
    }

    public static DigitClients createClients(String accountBaseUrl, String boundaryBaseUrl) {
        return DigitClientFactory.createClients(accountBaseUrl, boundaryBaseUrl, "http://localhost:8085");
    }

    public static DigitClients createClients(String accountBaseUrl, String boundaryBaseUrl, String workflowBaseUrl, String idgenBaseUrl) {
        AccountClient accountClient = DigitClientFactory.createAccountClient(accountBaseUrl);
        BoundaryClient boundaryClient = DigitClientFactory.createBoundaryClient(boundaryBaseUrl);
        WorkflowClient workflowClient = DigitClientFactory.createWorkflowClient(workflowBaseUrl);
        IdGenClient idGenClient = DigitClientFactory.createIdGenClient(idgenBaseUrl);
        return new DigitClients(accountClient, boundaryClient, workflowClient, idGenClient);
    }

    public static DigitClients createClients(String accountBaseUrl, String boundaryBaseUrl, String workflowBaseUrl) {
        return DigitClientFactory.createClients(accountBaseUrl, boundaryBaseUrl, workflowBaseUrl, "http://localhost:8100");
    }

    private static RestTemplate createRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new DigitClientErrorHandler());
        return restTemplate;
    }

    private static ApiProperties createApiProperties(String accountBaseUrl, String boundaryBaseUrl, String workflowBaseUrl, String idgenBaseUrl) {
        ApiProperties apiProperties = new ApiProperties();
        if (accountBaseUrl != null) {
            DigitClientFactory.setField(apiProperties, "accountServiceUrl", accountBaseUrl);
        }
        if (boundaryBaseUrl != null) {
            DigitClientFactory.setField(apiProperties, "boundaryServiceUrl", boundaryBaseUrl);
        }
        if (workflowBaseUrl != null) {
            DigitClientFactory.setField(apiProperties, "workflowServiceUrl", workflowBaseUrl);
        }
        if (idgenBaseUrl != null) {
            DigitClientFactory.setField(apiProperties, "idgenServiceUrl", idgenBaseUrl);
        }
        DigitClientFactory.setField(apiProperties, "mdmsServiceUrl", "http://localhost:8080");
        DigitClientFactory.setField(apiProperties, "registryServiceUrl", "http://localhost:8085");
        DigitClientFactory.setField(apiProperties, "connectTimeout", 5000);
        DigitClientFactory.setField(apiProperties, "readTimeout", 30000);
        DigitClientFactory.setField(apiProperties, "maxRetryAttempts", 3);
        DigitClientFactory.setField(apiProperties, "retryDelay", 1000L);
        return apiProperties;
    }

    private static void setField(Object target, String fieldName, Object value) {
        try {
            Field field = target.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set field: " + fieldName, e);
        }
    }

    public static class DigitClients {
        private final AccountClient accountClient;
        private final BoundaryClient boundaryClient;
        private final WorkflowClient workflowClient;
        private final IdGenClient idGenClient;
        private final IndividualClient individualClient;
        private final MdmsClient mdmsClient;
        private final RegistryClient registryClient;

        public DigitClients(AccountClient accountClient, BoundaryClient boundaryClient) {
            this.accountClient = accountClient;
            this.boundaryClient = boundaryClient;
            this.workflowClient = null;
            this.idGenClient = null;
            this.individualClient = null;
            this.mdmsClient = null;
            this.registryClient = null;
        }

        public DigitClients(AccountClient accountClient, BoundaryClient boundaryClient, WorkflowClient workflowClient) {
            this.accountClient = accountClient;
            this.boundaryClient = boundaryClient;
            this.workflowClient = workflowClient;
            this.idGenClient = null;
            this.individualClient = null;
            this.mdmsClient = null;
            this.registryClient = null;
        }

        public DigitClients(AccountClient accountClient, BoundaryClient boundaryClient, WorkflowClient workflowClient, IdGenClient idGenClient) {
            this.accountClient = accountClient;
            this.boundaryClient = boundaryClient;
            this.workflowClient = workflowClient;
            this.idGenClient = idGenClient;
            this.individualClient = null;
            this.mdmsClient = null;
            this.registryClient = null;
        }

        public DigitClients(AccountClient accountClient, BoundaryClient boundaryClient, WorkflowClient workflowClient, IdGenClient idGenClient, IndividualClient individualClient) {
            this.accountClient = accountClient;
            this.boundaryClient = boundaryClient;
            this.workflowClient = workflowClient;
            this.idGenClient = idGenClient;
            this.individualClient = individualClient;
            this.mdmsClient = null;
            this.registryClient = null;
        }

        public DigitClients(AccountClient accountClient, BoundaryClient boundaryClient, WorkflowClient workflowClient, IdGenClient idGenClient, IndividualClient individualClient, MdmsClient mdmsClient) {
            this.accountClient = accountClient;
            this.boundaryClient = boundaryClient;
            this.workflowClient = workflowClient;
            this.idGenClient = idGenClient;
            this.individualClient = individualClient;
            this.mdmsClient = mdmsClient;
            this.registryClient = null;
        }

        public DigitClients(AccountClient accountClient, BoundaryClient boundaryClient, WorkflowClient workflowClient, IdGenClient idGenClient, IndividualClient individualClient, MdmsClient mdmsClient, RegistryClient registryClient) {
            this.accountClient = accountClient;
            this.boundaryClient = boundaryClient;
            this.workflowClient = workflowClient;
            this.idGenClient = idGenClient;
            this.individualClient = individualClient;
            this.mdmsClient = mdmsClient;
            this.registryClient = registryClient;
        }

        public AccountClient getAccountClient() {
            return this.accountClient;
        }

        public BoundaryClient getBoundaryClient() {
            return this.boundaryClient;
        }

        public WorkflowClient getWorkflowClient() {
            return this.workflowClient;
        }

        public IdGenClient getIdGenClient() {
            return this.idGenClient;
        }

        public IndividualClient getIndividualClient() {
            return this.individualClient;
        }

        public MdmsClient getMdmsClient() {
            return this.mdmsClient;
        }

        public RegistryClient getRegistryClient() {
            return this.registryClient;
        }
    }
}

