/*
 * Decompiled with CFR 0.152.
 */
package org.digit.services.registry;

import org.digit.config.ApiProperties;
import org.digit.exception.DigitClientException;
import org.digit.services.registry.model.RegistryData;
import org.digit.services.registry.model.RegistryDataResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RegistryClient {
    private static final Logger log = LoggerFactory.getLogger(RegistryClient.class);
    private final RestTemplate restTemplate;
    private final ApiProperties apiProperties;

    public RegistryClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        this.restTemplate = restTemplate;
        this.apiProperties = apiProperties;
    }

    public RegistryData createRegistryData(RegistryData registryData) {
        if (registryData == null) {
            throw new DigitClientException("Registry data cannot be null");
        }
        if (registryData.getSchemaCode() == null || registryData.getSchemaCode().trim().isEmpty()) {
            throw new DigitClientException("Schema code cannot be null or empty");
        }
        if (registryData.getData() == null) {
            throw new DigitClientException("Data cannot be null");
        }
        try {
            log.debug("Creating registry data with schema code: {}", (Object)registryData.getSchemaCode());
            String url = this.apiProperties.getRegistryServiceUrl() + "/registry/v1/schema/" + registryData.getSchemaCode() + "/data";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            HttpEntity entity = new HttpEntity((Object)registryData, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)entity, RegistryDataResponse.class, new Object[0]);
            RegistryData createdData = null;
            if (response.getBody() != null && ((RegistryDataResponse)response.getBody()).getRegistryData() != null && !((RegistryDataResponse)response.getBody()).getRegistryData().isEmpty()) {
                createdData = ((RegistryDataResponse)response.getBody()).getRegistryData().get(0);
            }
            log.debug("Successfully created registry data with schema code: {}", (Object)registryData.getSchemaCode());
            return createdData;
        }
        catch (Exception e) {
            log.error("Failed to create registry data with schema code: {}", (Object)registryData.getSchemaCode(), (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to create registry data: " + e.getMessage(), e);
        }
    }

    public RegistryData searchRegistryData(String schemaCode, String registryId) {
        if (schemaCode == null || schemaCode.trim().isEmpty()) {
            throw new DigitClientException("Schema code cannot be null or empty");
        }
        if (registryId == null || registryId.trim().isEmpty()) {
            throw new DigitClientException("Registry ID cannot be null or empty");
        }
        try {
            log.debug("Searching registry data with schema code: {} and registry ID: {}", (Object)schemaCode, (Object)registryId);
            String url = this.apiProperties.getRegistryServiceUrl() + "/registry/v1/schema/" + schemaCode + "/data/_registry?registryId=" + registryId + "&history=true";
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, RegistryDataResponse.class, new Object[0]);
            RegistryData registryData = null;
            if (response.getBody() != null && ((RegistryDataResponse)response.getBody()).getRegistryData() != null && !((RegistryDataResponse)response.getBody()).getRegistryData().isEmpty()) {
                registryData = ((RegistryDataResponse)response.getBody()).getRegistryData().get(0);
            }
            log.debug("Successfully retrieved registry data with schema code: {} and registry ID: {}", (Object)schemaCode, (Object)registryId);
            return registryData;
        }
        catch (Exception e) {
            log.error("Failed to retrieve registry data with schema code: {} and registry ID: {}", new Object[]{schemaCode, registryId, e});
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to retrieve registry data: " + e.getMessage(), e);
        }
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ApiProperties getApiProperties() {
        return this.apiProperties;
    }
}

