/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class Classpath {
    public static String readAsString(String resourceName) {
        try {
            return IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File readAsFile(String resourceName) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (resource == null) {
            throw new RuntimeException(String.format("Resource %s not found in classpath", resourceName));
        }
        return new File(resource.getPath());
    }

    public static String filePathFor(String resourceName) {
        return Classpath.readAsFile(resourceName).getAbsolutePath();
    }

    public static String directoryPathFor(String resourceName) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (resource == null) {
            throw new RuntimeException(String.format("Resource %s not found in classpath", resourceName));
        }
        return resource.getPath();
    }
}

