/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.service;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.egov.search.domain.Searchable;
import org.egov.search.domain.resource.Type;
import org.egov.search.util.Beans;
import org.json.simple.JSONObject;

public class ResourceGenerator<T> {
    private final Class<T> clazz;
    private final Object object;
    private boolean rootLevel;

    public ResourceGenerator(Class<T> clazz, Object object) {
        this(clazz, object, true);
    }

    public ResourceGenerator(Class<T> clazz, Object object, boolean rootLevel) {
        this.clazz = clazz;
        this.object = object;
        this.rootLevel = rootLevel;
    }

    public JSONObject generate() {
        JSONObject jsonObject = new JSONObject();
        List<Field> fields = Beans.findAllDeclaredFields(this.clazz);
        fields.stream().filter(this::isSearchableField).forEach(field -> this.addFieldToJson(jsonObject, (Field)field));
        return jsonObject;
    }

    private void addFieldToJson(JSONObject jsonObject, Field field) {
        Searchable searchable = this.searchableAnnotation(field);
        String fieldName = this.fieldName(field, searchable);
        Object fieldValue = Beans.readPropertyValue(this.object, field);
        if (fieldValue == null) {
            return;
        }
        Type type = Type.newInstanceFor(field, fieldValue.getClass());
        fieldValue = type.jsonValue(this.object);
        if (this.rootLevel) {
            searchable.group().addFieldToJson(jsonObject, fieldName, fieldValue);
        } else {
            jsonObject.put((Object)fieldName, fieldValue);
        }
    }

    private String fieldName(Field field, Searchable searchable) {
        String fieldName = field.getName();
        if (StringUtils.isNotEmpty((String)searchable.name())) {
            fieldName = searchable.name();
        }
        return fieldName;
    }

    private boolean isSearchableField(Field field) {
        return this.searchableAnnotation(field) != null;
    }

    private Searchable searchableAnnotation(Field field) {
        return field.getAnnotation(Searchable.class);
    }
}

