/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.service;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.egov.search.domain.Document;
import org.egov.search.service.ElasticSearchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class IndexQueueListener
implements SessionAwareMessageListener<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexQueueListener.class);
    private final ElasticSearchClient esIndexClient;

    @Autowired
    public IndexQueueListener(ElasticSearchClient esIndexClient) {
        this.esIndexClient = esIndexClient;
    }

    public void onMessage(Message message, Session session) throws JMSException {
        try {
            String documentMessage = ((TextMessage)message).getText();
            Document doc = Document.fromJson(documentMessage);
            this.esIndexClient.index(doc.getIndex(), doc.getType(), doc.getCorrelationId(), doc.getResource().toJSONString());
        }
        catch (Exception e) {
            LOGGER.error("Error while creating search index", (Throwable)e);
            session.rollback();
            throw new JMSException(e.getMessage());
        }
    }
}

