/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.models;

import org.egov.encryption.models.Visibility;

public class AttributeAccess {
    private String attribute = null;
    private Visibility firstLevelVisibility = null;
    private Visibility secondLevelVisibility = null;

    public static AttributeAccessBuilder builder() {
        return new AttributeAccessBuilder();
    }

    public String getAttribute() {
        return this.attribute;
    }

    public Visibility getFirstLevelVisibility() {
        return this.firstLevelVisibility;
    }

    public Visibility getSecondLevelVisibility() {
        return this.secondLevelVisibility;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public void setFirstLevelVisibility(Visibility firstLevelVisibility) {
        this.firstLevelVisibility = firstLevelVisibility;
    }

    public void setSecondLevelVisibility(Visibility secondLevelVisibility) {
        this.secondLevelVisibility = secondLevelVisibility;
    }

    public AttributeAccess(String attribute, Visibility firstLevelVisibility, Visibility secondLevelVisibility) {
        this.attribute = attribute;
        this.firstLevelVisibility = firstLevelVisibility;
        this.secondLevelVisibility = secondLevelVisibility;
    }

    public AttributeAccess() {
    }

    public static class AttributeAccessBuilder {
        private String attribute;
        private Visibility firstLevelVisibility;
        private Visibility secondLevelVisibility;

        AttributeAccessBuilder() {
        }

        public AttributeAccessBuilder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public AttributeAccessBuilder firstLevelVisibility(Visibility firstLevelVisibility) {
            this.firstLevelVisibility = firstLevelVisibility;
            return this;
        }

        public AttributeAccessBuilder secondLevelVisibility(Visibility secondLevelVisibility) {
            this.secondLevelVisibility = secondLevelVisibility;
            return this;
        }

        public AttributeAccess build() {
            return new AttributeAccess(this.attribute, this.firstLevelVisibility, this.secondLevelVisibility);
        }

        public String toString() {
            return "AttributeAccess.AttributeAccessBuilder(attribute=" + this.attribute + ", firstLevelVisibility=" + this.firstLevelVisibility + ", secondLevelVisibility=" + this.secondLevelVisibility + ")";
        }
    }
}

