/*
 * Decompiled with CFR 0.152.
 */
package org.egov.hash;

import jakarta.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HashService {
    private static final Logger log = LoggerFactory.getLogger(HashService.class);
    private MessageDigest messageDigest;

    @PostConstruct
    public void init() throws NoSuchAlgorithmException {
        this.messageDigest = MessageDigest.getInstance("SHA-256");
    }

    public String getHashValue(Object object) {
        String value = object.toString();
        byte[] bytes = this.messageDigest.digest(value.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBase64URLSafeString((byte[])bytes);
    }
}

