/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.egov.encryption.config.EncProperties;
import org.egov.encryption.web.contract.EncReqObject;
import org.egov.encryption.web.contract.EncryptionRequest;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
class EncryptionServiceRestConnection {
    private static final Logger log = LoggerFactory.getLogger(EncryptionServiceRestConnection.class);
    @Autowired
    private EncProperties encProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ObjectMapper objectMapper;

    EncryptionServiceRestConnection() {
    }

    Object callEncrypt(String tenantId, String type, Object value) throws IOException {
        EncReqObject encReqObject = new EncReqObject(tenantId, type, value);
        EncryptionRequest encryptionRequest = new EncryptionRequest();
        encryptionRequest.setEncryptionRequests(new ArrayList<EncReqObject>(Collections.singleton(encReqObject)));
        try {
            String encServiceUrl;
            Map<String, String> tenantNamespaceMap = Arrays.stream(this.encProperties.getEncSeparateTenantsNamespace().split(",")).map(entry -> entry.split(":")).collect(Collectors.toMap(e -> e[0].trim(), e -> e[1].trim()));
            List<String> separateTenants = Arrays.asList(this.encProperties.getEncSeparateTenants().split(","));
            if (separateTenants.contains(tenantId) && tenantNamespaceMap.containsKey(tenantId)) {
                String namespace = tenantNamespaceMap.get(tenantId);
                encServiceUrl = this.encProperties.getEncServiceUrlPattern().replace("{namespace}", namespace);
            } else {
                encServiceUrl = this.encProperties.getEgovEncHost();
            }
            ResponseEntity response = this.restTemplate.postForEntity(encServiceUrl + this.encProperties.getEgovEncEncryptPath(), (Object)encryptionRequest, String.class, new Object[0]);
            return this.objectMapper.readTree((String)response.getBody()).get(0);
        }
        catch (Exception e2) {
            log.error("Error occurred while calling Encryption Service", (Throwable)e2);
            throw new CustomException("ENCRYPTION_SERVICE_ERROR", "Error occurred while calling Encryption Service");
        }
    }

    JsonNode callDecrypt(Object ciphertext, String tenantId) {
        try {
            String encServiceUrl;
            Map<String, String> tenantNamespaceMap = Arrays.stream(this.encProperties.getEncSeparateTenantsNamespace().split(",")).map(entry -> entry.split(":")).collect(Collectors.toMap(e -> e[0].trim(), e -> e[1].trim()));
            List<String> separateTenants = Arrays.asList(this.encProperties.getEncSeparateTenants().split(","));
            if (separateTenants.contains(tenantId) && tenantNamespaceMap.containsKey(tenantId)) {
                String namespace = tenantNamespaceMap.get(tenantId);
                encServiceUrl = this.encProperties.getEncServiceUrlPattern().replace("{namespace}", namespace);
            } else {
                encServiceUrl = this.encProperties.getEgovEncHost();
            }
            ResponseEntity response = this.restTemplate.postForEntity(encServiceUrl + this.encProperties.getEgovEncDecryptPath(), ciphertext, JsonNode.class, new Object[0]);
            return (JsonNode)response.getBody();
        }
        catch (Exception e2) {
            throw new CustomException("ENCRYPTION_SERVICE_ERROR", "Error occurred while calling Encryption Service");
        }
    }
}

